#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.datetime_partitioning_data_for_open_api import DatetimePartitioningDataForOpenApi
from datarobot.models.full_api.generated.model.datetime_partitioning_response import DatetimePartitioningResponse
from datarobot.models.full_api.generated.model.final_datetime_partitioning_response import FinalDatetimePartitioningResponse
from datarobot.models.full_api.generated.model.optimized_datetime_partitioning_data import OptimizedDatetimePartitioningData
from datarobot.models.full_api.generated.model.optimized_datetime_partitioning_list_response import OptimizedDatetimePartitioningListResponse
from datarobot.models.full_api.generated.model.time_series_feature_log_list_controller_response import TimeSeriesFeatureLogListControllerResponse


class DatetimePartitioningApi(APIObject):

        @classmethod
        def projects_datetime_partitioning_create(
            cls,
            project_id,
            **kwargs
        ):
            """Preview the fully specified datetime partitioning generated by the requested configuration.

            Preview the fully specified datetime partitioning generated by the requested configuration.  Populates the full datetime partitioning that would be used if the same arguments were passed to :http:patch:`/api/v2/projects/(projectId)/aim/` based on the requested configuration, generating defaults for all non-specified values, so that potential configurations can be tested prior to setting the target and applying a configuration.  `useTimeSeries` controls whether a time series project should be created or a normal project that uses datetime partitioning. See :ref:`Time-Series Projects<time_series_overview>` for more detail on the differences between time series projects and datetime partitioned projects. Time-series projects are only available to some users and use the additional settings of `featureDerivationWindowStart` and `featureDerivationWindowEnd` to establish feature derivation window and `forecastWindowStart` and `forecastWindowEnd` to establish a forecast window. The overview referenced above provides more information about using feature derivation and forecast windows.  When specifying a feature derivation window of a forecast window, the number of units it spans (end - start) must be an integer multiple of the timeStep of the datetimePartitionColumn.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.
            Args:
                project_id (str): The project ID

            Keyword Args:
                datetime_partitioning_data_for_open_api (DatetimePartitioningDataForOpenApi): [optional]
            Returns:
                DatetimePartitioningResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/datetimePartitioning/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimePartitioningResponse(**server_data)

        @classmethod
        def projects_datetime_partitioning_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve datetime partitioning configuration.

            Retrieve datetime partitioning configuration  The datetime partition object in the response describes the full partitioning parameters. Since it becomes available after the target has been fully specified and the project is ready for modeling, there are some additional fields available compared to the response from :http:post:`/api/v2/projects/(projectId)/datetimePartitioning/`.  The available training data corresponds to all the data available for training, while the primary training data corresponds to the data that can be used to train while ensuring that all backtests are available. If a model is trained with more data than is available in the primary training data, then all backtests may not have scores available.  All durations and datetimes will be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                FinalDatetimePartitioningResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/datetimePartitioning/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FinalDatetimePartitioningResponse(**server_data)

        @classmethod
        def projects_optimized_datetime_partitionings_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create an optimized datetime partitioning configuration using the target.

            Create an optimized datetime partitioning configuration using the target.  Initializes a job to construct an optimized datetime partitioning using the date and target information to ensure that backtests sufficiently cover regions of interest in the target. This is an asynchronous job. The results of the asynchronous job (backtests and other parameters can be used in the synchronous version.  `useTimeSeries` controls whether a time series project should be created or a normal project that uses datetime partitioning. See :ref:`Time-Series Projects<time_series_overview>` for more detail on the differences between time series projects and datetime partitioned projects. Time-series projects are only available to some users and use the additional settings of `featureDerivationWindowStart` and `featureDerivationWindowEnd` to establish feature derivation window and `forecastWindowStart` and `forecastWindowEnd` to establish a forecast window. The overview referenced above provides more information about using feature derivation and forecast windows.  When specifying a feature derivation window of a forecast window, the number of units it spans (end - start) must be an integer multiple of the timeStep of the datetimePartitionColumn.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.
            Args:
                project_id (str): The project ID

            Keyword Args:
                optimized_datetime_partitioning_data (OptimizedDatetimePartitioningData): [optional]
            Returns:
                DatetimePartitioningResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/optimizedDatetimePartitionings/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimePartitioningResponse(**server_data)

        @classmethod
        def projects_optimized_datetime_partitionings_list(
            cls,
            project_id,
            limit=10,
            **kwargs
        ):
            """List all created optimized datetime partitioning configurations

            List all created optimized datetime partitioning configurations
            Args:
                project_id (str): The project ID
                limit (int): At most this many results are returned.. defaults to 10, must be one of [10]

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
            Returns:
                OptimizedDatetimePartitioningListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/optimizedDatetimePartitionings/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OptimizedDatetimePartitioningListResponse(**server_data)

        @classmethod
        def projects_optimized_datetime_partitionings_retrieve(
            cls,
            project_id,
            datetime_partitioning_id,
            **kwargs
        ):
            """Retrieve optimized datetime partitioning configuration

            Retrieve optimized datetime partitioning configuration  The optimized datetime partition objects are structurally identical to the original datetime partition objects, however they are retrieved from a mongo database after creation as opposed to being calculated synchronously. The datetime partition object in the response describes the full partitioning parameters.  The available training data corresponds to all the data available for training, while the primary training data corresponds to the data that can be used to train while ensuring that all backtests are available. If a model is trained with more data than is available in the primary training data, then all backtests may not have scores available.  .. note:: All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules <time_format>`.
            Args:
                project_id (str): The project ID
                datetime_partitioning_id (str): The ID of the datetime partitioning to retrieve.

            Keyword Args:
            Returns:
                DatetimePartitioningResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['datetime_partitioning_id'] = datetime_partitioning_id
            path_args['datetimePartitioningId'] = datetime_partitioning_id
            path = '/api/v2/projects/{projectId}/optimizedDatetimePartitionings/{datetimePartitioningId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimePartitioningResponse(**server_data)

        @classmethod
        def projects_time_series_feature_log_file_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve a text file containing the time series project feature log

            Retrieve a text file containing the time series project feature log.  The Time Series Feature Log provides details about the feature generation process for a time series project. It includes information about which features are generated and their priority,as well as the detected properties of the time series data such as whether the series is stationary, and periodicities detected.  This route is only supported for time series projects that have finished partitioning.  The feature derivation log will include information about:  * Maximum number of feature to be generated, e.g., ``Limit on the maximum number of feature in this project is 500`` * Number of derived features tested during the feature generation process, e.g., ``Total number of derived features during the feature generation process is 571`` * Number of generated features removed during the feature reduction process e.g. ``Total number of features removed during the feature reduction process is 472`` * Number of remaining features after the combined feature generation and reduction process, e.g., ``The finalized number of features is 99`` * Detected stationarity of the series, e.g., ``Series detected as non-stationary`` * Detected presence of multiplicative trend in the series, e.g., ``Multiplicative trend detected`` * Detected periodicities in the series, e.g., ``Detected periodicities: 7 day`` * Window sizes used in rolling statistics / lag extractors, e.g., ``The window sizes chosen to be: 2 months (because the time step is 1 month and Feature Derivation Window is 2 months)`` * Features that are specified as known-in-advance, e.g., ``Variables treated as apriori: holiday`` * Details about why certain variables are transformed in the input data, e.g., ``Generating variable \"y (log)\" from \"y\" because multiplicative trend is detected`` * Details about features generated as time series features, and their priority, e.g., ``Generating feature \"date (actual)\" from \"date\" (priority: 1)``
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/timeSeriesFeatureLog/file/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_time_series_feature_log_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve the feature derivation log content and log length for a time series project as JSON.

            Retrieve the feature derivation log content and log length for a time series project as JSON.  The Time Series Feature Log provides details about the feature generation process for a time series project. It includes information about which features are generated and their priority,as well as the detected properties of the time series data such as whether the series is stationary, and periodicities detected.  This route is only supported for time series projects that have finished partitioning.  The feature derivation log will include information about:  * Detected stationarity of the series, e.g., ``Series detected as non-stationary`` * Detected presence of multiplicative trend in the series, e.g., ``Multiplicative trend detected`` * Detected periodicities in the series, e.g., ``Detected periodicities: 7 day`` * Maximum number of feature to be generated, e.g., ``Maximum number of feature to be generated is 1440`` * Window sizes used in rolling statistics / lag extractors, e.g., ``The window sizes chosen to be: 2 months`` * Features that are specified as known-in-advance, e.g., ``Variables treated as apriori: holiday`` * Details about features generated as timeseries features, and their priority, e.g., ``Generating feature \"date (actual)\" from \"date\" (priority: 1)`` * Details about why certain variables are transformed in the input data, e.g., ``Generating variable \"y (log)\" from \"y\" because multiplicative trend is detected``
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
            Returns:
                TimeSeriesFeatureLogListControllerResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/timeSeriesFeatureLog/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return TimeSeriesFeatureLogListControllerResponse(**server_data)

