#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.accuracy_over_time_response import AccuracyOverTimeResponse
from datarobot.models.full_api.generated.model.accuracy_retrieve_response import AccuracyRetrieveResponse
from datarobot.models.full_api.generated.model.challenger_create import ChallengerCreate
from datarobot.models.full_api.generated.model.challenger_list_response import ChallengerListResponse
from datarobot.models.full_api.generated.model.challenger_response import ChallengerResponse
from datarobot.models.full_api.generated.model.challenger_score import ChallengerScore
from datarobot.models.full_api.generated.model.challenger_update import ChallengerUpdate
from datarobot.models.full_api.generated.model.deleted_deployment_list_response import DeletedDeploymentListResponse
from datarobot.models.full_api.generated.model.deployment_actuals import DeploymentActuals
from datarobot.models.full_api.generated.model.deployment_create_from_learning_model import DeploymentCreateFromLearningModel
from datarobot.models.full_api.generated.model.deployment_create_from_project_recommended_model import DeploymentCreateFromProjectRecommendedModel
from datarobot.models.full_api.generated.model.deployment_create_response import DeploymentCreateResponse
from datarobot.models.full_api.generated.model.deployment_dataset_create import DeploymentDatasetCreate
from datarobot.models.full_api.generated.model.deployment_feature_drift_response import DeploymentFeatureDriftResponse
from datarobot.models.full_api.generated.model.deployment_list_response import DeploymentListResponse
from datarobot.models.full_api.generated.model.deployment_permanent_delete import DeploymentPermanentDelete
from datarobot.models.full_api.generated.model.deployment_retrieve_response import DeploymentRetrieveResponse
from datarobot.models.full_api.generated.model.deployment_settings_response import DeploymentSettingsResponse
from datarobot.models.full_api.generated.model.deployment_settings_update import DeploymentSettingsUpdate
from datarobot.models.full_api.generated.model.deployment_target_drift_response import DeploymentTargetDriftResponse
from datarobot.models.full_api.generated.model.deployment_update import DeploymentUpdate
from datarobot.models.full_api.generated.model.feature_list_response import FeatureListResponse
from datarobot.models.full_api.generated.model.humility_stats_over_time_retrieve_response import HumilityStatsOverTimeRetrieveResponse
from datarobot.models.full_api.generated.model.humility_stats_retrieve_response import HumilityStatsRetrieveResponse
from datarobot.models.full_api.generated.model.model_replacement_submission import ModelReplacementSubmission
from datarobot.models.full_api.generated.model.model_replacement_validation_request import ModelReplacementValidationRequest
from datarobot.models.full_api.generated.model.model_replacement_validation_response import ModelReplacementValidationResponse
from datarobot.models.full_api.generated.model.prediction_dataset_assignment import PredictionDatasetAssignment
from datarobot.models.full_api.generated.model.prediction_proxy_response import PredictionProxyResponse
from datarobot.models.full_api.generated.model.prediction_results_list_response import PredictionResultsListResponse
from datarobot.models.full_api.generated.model.prediction_server_list_response import PredictionServerListResponse
from datarobot.models.full_api.generated.model.scheduled_report_on_demmand import ScheduledReportOnDemmand
from datarobot.models.full_api.generated.model.scoring_code_build_payload import ScoringCodeBuildPayload
from datarobot.models.full_api.generated.model.secondary_dataset_config_response import SecondaryDatasetConfigResponse
from datarobot.models.full_api.generated.model.secondary_dataset_config_update import SecondaryDatasetConfigUpdate
from datarobot.models.full_api.generated.model.secondary_datasets_config_list_response import SecondaryDatasetsConfigListResponse
from datarobot.models.full_api.generated.model.service_stats_over_time_response import ServiceStatsOverTimeResponse
from datarobot.models.full_api.generated.model.service_stats_retrieve_response import ServiceStatsRetrieveResponse
from datarobot.models.full_api.generated.model.shared_roles_update_with_grant import SharedRolesUpdateWithGrant
from datarobot.models.full_api.generated.model.sharing_list_v2_response import SharingListV2Response


class DeploymentsApi(APIObject):

        @classmethod
        def deleted_deployments_list(
            cls,
            offset=0,
            limit=20,
            **kwargs
        ):
            """List deleted deployments

            List deleted deployments.Only available as part of an enterprise (on-prem) installation. Requires a CAN_DELETE_APP_PROJECTS permission to execute.
            Args:
                offset (int): The number of deleted deployments to skip.. defaults to 0, must be one of [0]
                limit (int): The number of deleted deployments to return.. defaults to 20, must be one of [20]

            Keyword Args:
            Returns:
                DeletedDeploymentListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/deletedDeployments/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeletedDeploymentListResponse(**server_data)

        @classmethod
        def deleted_deployments_patch_many(
            cls,
            **kwargs
        ):
            """Erase deleted deployments

            Permanently erase data for deleted deployments. Only available as part of an on-premise or private/hybrid cloud deployment. Requires a CAN_DELETE_APP_PROJECTS permission to execute.

            Keyword Args:
                deployment_permanent_delete (DeploymentPermanentDelete): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/deletedDeployments/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def deployments_accuracy_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve accuracy metric

            Retrieve accuracy metric for a certain time period.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                model_id (str): The id of the model for which metrics are being retrieved.. [optional]
                segment_attribute (str, none_type): The name of the segment on which segment analysis is being performed.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                target_classes (str, none_type): Comma separated list of target classes to filter out response. [optional]
            Returns:
                AccuracyRetrieveResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/accuracy/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AccuracyRetrieveResponse(**server_data)

        @classmethod
        def deployments_accuracy_over_time_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve accuracy over time data for one single metric.

                     Retrieve accuracy over time data for one single metric.          The following metrics can be retrieved.              For classification deployments:              - Accuracy             - AUC             - Balanced Accuracy             - FVE Binomial             - Gini Norm             - Kolmogorov-Smirnov             - LogLoss (default)             - Rate@Top5%             - Rate@Top10%              For regression deployments:              - Gamma Deviance (default)             - FVE Gamma             - FVE Poisson             - FVE Tweedie             - MAD             - MAE             - MAPE             - Poisson Deviance             - R Squared             - RMSE             - RMSLE             - Tweedie Deviance         
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): Start of the period to retrieve metric stats, defaults to 7 days ago from the end of the period.. [optional]
                end (datetime, none_type): End of the period to retrieve metric stats, defaults to the next top of the hour.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
                model_id (str): The id of the model for which metrics are being retrieved.. [optional]
                metric (str): Name of the metric.. [optional]
                segment_attribute (str, none_type): The name of the segment on which segment analysis is being performed.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                target_classes (str, none_type): List of target classes to filter out response. [optional]
            Returns:
                AccuracyOverTimeResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/accuracyOverTime/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AccuracyOverTimeResponse(**server_data)

        @classmethod
        def deployments_actuals_from_dataset_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Submit actuals values from AI Catalog

            Submit actuals values for processing using catalog item. Submission of actuals is limited to 10,000,000 actuals per hour. For time series deployments, total actuals = number of actuals * number of forecast distances. For example, submitting 10 actuals for a deployment with 50 forecast distances = 500 total actuals. For multiclass deployments, a similar calculation is made where total actuals = number of actuals * number of classes. For example, submitting 10 actuals for a deployment with 20 classes = 200 actuals.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                deployment_dataset_create (DeploymentDatasetCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/actuals/fromDataset/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_actuals_from_json_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Submit actuals values

            Submit actuals values for processing. Values are not processed immediately and may take some time to propagate through deployment systems. Submission of actuals is limited to 10,000,000 actuals per hour. For time series deployments, total actuals = number of actuals * number of forecast distances. For example, submitting 10 actuals for a deployment with 50 forecast distances = 500 total actuals. For multiclass deployments, a similar calculation is made where total actuals = number of actuals * number of classes. For example, submitting 10 actuals for a deployment with 20 classes = 200 actuals.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                deployment_actuals (DeploymentActuals): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/actuals/fromJSON/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_challenger_predictions_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Score challenger models

            Score main model prediction requests against challenger model requests.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                challenger_score (ChallengerScore): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/challengerPredictions/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_challengers_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Create challenger model

            Create new challenger model.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                challenger_create (ChallengerCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/challengers/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_challengers_delete(
            cls,
            deployment_id,
            challenger_id,
            **kwargs
        ):
            """Delete challenger model

            Delete challenger model.
            Args:
                deployment_id (str): Unique identifier of the deployment.
                challenger_id (str): Unique identifier of the challenger.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            kwargs['challenger_id'] = challenger_id
            path_args['challengerId'] = challenger_id
            path = '/api/v2/deployments/{deploymentId}/challengers/{challengerId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def deployments_challengers_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """List challenger models

            List challenger models for deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
            Returns:
                ChallengerListResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/challengers/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ChallengerListResponse(**server_data)

        @classmethod
        def deployments_challengers_patch(
            cls,
            deployment_id,
            challenger_id,
            **kwargs
        ):
            """Update challenger model

            Update challenger model.
            Args:
                deployment_id (str): Unique identifier of the deployment.
                challenger_id (str): Unique identifier of the challenger.

            Keyword Args:
                challenger_update (ChallengerUpdate): [optional]
            Returns:
                ChallengerResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            kwargs['challenger_id'] = challenger_id
            path_args['challengerId'] = challenger_id
            path = '/api/v2/deployments/{deploymentId}/challengers/{challengerId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ChallengerResponse(**server_data)

        @classmethod
        def deployments_challengers_retrieve(
            cls,
            deployment_id,
            challenger_id,
            **kwargs
        ):
            """Get challenger model

            Retrieve challenger model.
            Args:
                deployment_id (str): Unique identifier of the deployment.
                challenger_id (str): Unique identifier of the challenger.

            Keyword Args:
            Returns:
                ChallengerResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            kwargs['challenger_id'] = challenger_id
            path_args['challengerId'] = challenger_id
            path = '/api/v2/deployments/{deploymentId}/challengers/{challengerId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ChallengerResponse(**server_data)

        @classmethod
        def deployments_delete(
            cls,
            deployment_id,
            **kwargs
        ):
            """Delete deployment

            Delete a deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def deployments_feature_drift_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve feature drift scores

            Retrieve drift scores for features of the deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                model_id (str): ID of the model in the deployment. If not set, defaults to the deployment current model.. [optional]
                metric (str): Name of the metric used to calculate the drift. Can be one of psi, kl_divergence, dissimilarity, hellinger, and js_divergence. Defaults to psi.. [optional] if omitted the server will use the default value of "psi"
                offset (int): The number of features to skip, defaults to 0.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of features to return, defaults to 25.. [optional] if omitted the server will use the default value of 200
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
            Returns:
                DeploymentFeatureDriftResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/featureDrift/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentFeatureDriftResponse(**server_data)

        @classmethod
        def deployments_features_list(
            cls,
            deployment_id,
            offset=0,
            limit=50,
            **kwargs
        ):
            """Get deployment features

            Retrieve features contained within the universe dataset associated with a specific deployment. By default, this returns all raw features required for predictions.
            Args:
                deployment_id (str): Unique identifier of the deployment.
                offset (int): The number of features to skip, defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of features to return, defaults to 0.. defaults to 50, must be one of [50]

            Keyword Args:
                include_non_prediction_features (str): When True will return all raw features in the universe dataset associated with the deployment, and when False will return only those raw features used to make predictions on the deployment.. [optional] if omitted the server will use the default value of "false"
                for_segmented_analysis (str): When True, features returned will be filtered to those usable for segmented analysis.. [optional] if omitted the server will use the default value of "false"
                search (str): Case insensitive search against names of the deployment's features.. [optional]
            Returns:
                FeatureListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/features/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureListResponse(**server_data)

        @classmethod
        def deployments_from_learning_model_create(
            cls,
            **kwargs
        ):
            """Create deployment from DataRobot model

            Create a deployment from a DataRobot model.

            Keyword Args:
                deployment_create_from_learning_model (DeploymentCreateFromLearningModel): [optional]
            Returns:
                DeploymentCreateResponse
            """
            path_args = {}
            path = '/api/v2/deployments/fromLearningModel/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentCreateResponse(**server_data)

        @classmethod
        def deployments_from_project_recommended_model_create(
            cls,
            **kwargs
        ):
            """Create deployment from recommended model

            Create a deployment for a recommended model

            Keyword Args:
                deployment_create_from_project_recommended_model (DeploymentCreateFromProjectRecommendedModel): [optional]
            Returns:
                DeploymentCreateResponse
            """
            path_args = {}
            path = '/api/v2/deployments/fromProjectRecommendedModel/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentCreateResponse(**server_data)

        @classmethod
        def deployments_humility_stats_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve humility stats

            Retrieve humility rule service triggers statistics overview.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): Start of the period to retrieve service health stats, defaults to 7 days ago from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): End of the period to retrieve service health stats, defaults to the next top of the hour.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                model_id (str): The ID of the model to retrieve service health stats. If provided, only the service health stats for that  specific model will be retrieved. If not provided, the service healthstats for the deployment`s current model will be retrieved.. [optional]
            Returns:
                HumilityStatsRetrieveResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/humilityStats/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return HumilityStatsRetrieveResponse(**server_data)

        @classmethod
        def deployments_humility_stats_over_time_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve humility stats over time

            Retrieve humility service statistics over time.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): Start of the period to retrieve service health stats, defaults to 7 days ago from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): End of the period to retrieve service health stats, defaults to the next top of the hour.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                model_id (str): The ID of the model to retrieve service health stats. If provided, only the service health stats for that  specific model will be retrieved. If not provided, the service healthstats for the deployment`s current model will be retrieved.. [optional]
            Returns:
                HumilityStatsOverTimeRetrieveResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/humilityStatsOverTime/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return HumilityStatsOverTimeRetrieveResponse(**server_data)

        @classmethod
        def deployments_list(
            cls,
            offset=0,
            limit=20,
            **kwargs
        ):
            """List deployments

            List deployments a user can view.
            Args:
                offset (int): The number of deployments to skip. Defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of deployments (greater than zero, max 100) to return. Defaults to 20.. defaults to 20, must be one of [20]

            Keyword Args:
                order_by (str): The order to sort the deployments.Defaults to order by deployment last prediction timestamp in descending order.. [optional]
                search (str): Case insensitive search against deployment's label and description.. [optional]
                service_health ([str]): Filters deployments by their service health status.. [optional]
                model_health ([str]): Filters deployments by their model health status.. [optional]
                accuracy_health ([str]): Filters deployments by their accuracy health status.. [optional]
                role (str): Filter deployments to only those that the authenticated user has the specified role for.. [optional]
                status ([str]): Filters deployments by their status. [optional]
                importance ([str]): Filters deployments by their importance. [optional]
                last_prediction_timestamp_start (datetime): Only include deployments that have had a prediction request on or after the specified timestamp.. [optional]
                last_prediction_timestamp_end (datetime): Only include deployments that have had a prediction request before the specified timestamp.. [optional]
                prediction_usage_daily_avg_greater_than (int): only include deployments that have had more than the specified number of predictions per day on average over the past week.. [optional]
                prediction_usage_daily_avg_less_than (int): Only include deployments that have had fewer than the specified number of predictions per day on average over the past week.. [optional]
                default_prediction_server_id ([str]): Filter deployments to those whose default prediction server has the specified id.. [optional]
                build_environment_type ([str]): Filter deployments based on the type of their current model's build environment type.. [optional]
                execution_environment_type ([str]): Filter deployments based on the type of their execution environment.. [optional]
                prediction_environment_platform ([str]): Filter deployments based on prediction environment platform. [optional]
                has_decision_flow (str): Filter deployments based if it is a decision flow. [optional]
            Returns:
                DeploymentListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/deployments/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentListResponse(**server_data)

        @classmethod
        def deployments_model_patch_many(
            cls,
            deployment_id,
            **kwargs
        ):
            """Model Replacement.

            Replace the model used to make predictions for the deployment. A validation process will be performed to make sure the new model is eligible as a replacement. If the validation fails, the model replacement will not occur.The Model Replacement Validation endpoint can be used to confirm the new model is eligible as a replacement.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                model_replacement_submission (ModelReplacementSubmission): [optional]
            Returns:
                ModelReplacementValidationResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/model/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelReplacementValidationResponse(**server_data)

        @classmethod
        def deployments_model_secondary_dataset_configuration_history_list(
            cls,
            deployment_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List the secondary datasets configuration history for a deployment

            List all the secondary datasets configuration used by a given Feature Discovery deployment
            Args:
                deployment_id (str): Unique identifier of the deployment.
                offset (int): Number of items to skip. Defaults to 0 if not provided.. defaults to 0, must be one of [0]
                limit (int): Number of items to return, defaults to 100 if not provided.. defaults to 100, must be one of [100]

            Keyword Args:
            Returns:
                SecondaryDatasetsConfigListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/model/secondaryDatasetConfigurationHistory/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SecondaryDatasetsConfigListResponse(**server_data)

        @classmethod
        def deployments_model_secondary_dataset_configuration_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve secondary datasets configuration for a deployment.

            Retrieve the secondary datasets configuration used by a deployed Feature discovery model.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
            Returns:
                SecondaryDatasetConfigResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/model/secondaryDatasetConfiguration/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SecondaryDatasetConfigResponse(**server_data)

        @classmethod
        def deployments_model_secondary_dataset_configuration_patch_many(
            cls,
            deployment_id,
            **kwargs
        ):
            """Update the secondary datasets configuration for the deployed model.

            Update the secondary datasets configuration used by the deployed feature discovery model.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                secondary_dataset_config_update (SecondaryDatasetConfigUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/model/secondaryDatasetConfiguration/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def deployments_model_validation_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Model Replacement Validation.

            Validate that a model can be used to replace the current model of the deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                model_replacement_validation_request (ModelReplacementValidationRequest): [optional]
            Returns:
                ModelReplacementValidationResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/model/validation/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelReplacementValidationResponse(**server_data)

        @classmethod
        def deployments_on_demand_reports_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Add report to execution queue.

            Add report to execution queue.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                scheduled_report_on_demmand (ScheduledReportOnDemmand): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/onDemandReports/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_patch(
            cls,
            deployment_id,
            **kwargs
        ):
            """Update deployment

            Update a deployment's label and description.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                deployment_update (DeploymentUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def deployments_prediction_inputs_from_dataset_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Submit external deployment prediction data.

            Assigns prediction dataset to the external deployment to enable the analysis of historical model performance. Multiple datasets containing historical predictions for the external deployment can be uploaded. This requires one request for each dataset. For a regression deployment, predictions can be either an int or float. For a classification (binary/multiclass) deployment, predictions must be lists with each list containing probabilities for each class.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                prediction_dataset_assignment (PredictionDatasetAssignment): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/predictionInputs/fromDataset/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_prediction_results_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve predictions results.

            Retrieve predictions results of the deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                model_id (str): The id of the model for which prediction results are being retrieved.. [optional]
                actuals_present (bool): Filters predictions results to only those who have actuals present or with missing actuals.. [optional]
                accept (str): Requested MIME type for the returned data. [optional]
            Returns:
                PredictionResultsListResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/predictionResults/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionResultsListResponse(**server_data)

        @classmethod
        def deployments_predictions_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Compute predictions synchronously

            The route can be used for low-latency (hence synchronous) predictions. Scoring dataset, however, must be up to 50 MB and is limited by comma-delimited CSV and record oriented JSON. All other formats are not supported.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                passthrough_columns ([str]): List of columns from a scoring dataset to return in the prediction response. If not specified, no columns will be present in the response. Mutually exclusive with `passthroughColumnsSet`.. [optional]
                passthrough_columns_set (str): If `passthroughColumnsSet=all` is passed, all columns from the scoring dataset are returned in the prediction response. All other values for this parameter are invalid. Mutually exclusive with `passthroughColumns`.. [optional] if omitted the server will use the default value of "all"
                max_explanations (bool, date, datetime, dict, float, int, list, str, none_type): The maximum number of prediction explanations to supply per row of the dataset. The default `maxExplanations` is `3` when `xemp` based explanations are requested.  The default `maxExplanations` is `all` (no limit) when `shap` based explanations are requested.. [optional]
                max_codes (bool, date, datetime, dict, float, int, list, str, none_type): Deprecated alias of `maxExplanations`.. [optional]
                threshold_high (float): The high threshold, above which a prediction must score in order for prediction explanations to be computed for a row in the dataset. If neither `thresholdHigh` nor `thresholdLow` is specified, prediction explanations will be computed for all rows. This option is ignored when `shap` based explanations are requested.. [optional]
                threshold_low (float): The lower threshold, below which a prediction must score in order for prediction explanations to be computed for a row in the dataset. If neither `thresholdHigh` nor `thresholdLow` is specified, prediction explanations will be computed for all rows. This option is ignored when `shap` based explanations are requested.. [optional]
                exclude_adjusted_predictions (bool): If `false`, include exposure-adjusted predictions in the response.. [optional] if omitted the server will use the default value of True
                forecast_point (datetime): The time in the dataset relative to which predictions are generated. If not specified the default value is the value in the row with the latest specified timestamp.. [optional]
                predictions_start_date (datetime): The time in the dataset starting from which bulk predictions are generated. Should be defined together with `predictionsEndDate`. `forecastPoint` param can not be used if either `predictionsStartDate` or `predictionsEndDate` is passed.. [optional]
                predictions_end_date (datetime): The time in the dataset until which bulk predictions are generated. Should be defined together with `predictionsStartDate`. `forecastPoint` param can not be used if either `predictionsStartDate` or `predictionsEndDate` is passed.. [optional]
                relax_known_in_advance_features_check (bool): If `true`, missing values in the known in advance features are allowed in the forecast window at the prediction time. If omitted or `false`, missing values are not allowed.. [optional]
                prediction_warning_enabled (bool): If `true` is passed, predictions response will include `isOutlierPrediction` key for each record with result of outlier check.. [optional]
            Returns:
                PredictionProxyResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/predictions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionProxyResponse(**server_data)

        @classmethod
        def deployments_retrieve(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve deployment

            Retrieve a deployment.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
            Returns:
                DeploymentRetrieveResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentRetrieveResponse(**server_data)

        @classmethod
        def deployments_scoring_code_builds_create(
            cls,
            deployment_id,
            **kwargs
        ):
            """Build Java package containing Scoring Code with agent integration.

            Build Java package containing Scoring Code with agent integration.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                scoring_code_build_payload (ScoringCodeBuildPayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/scoringCodeBuilds/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def deployments_scoring_code_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve Scoring Code

            Retrieve Scoring Code of the current deployed model for making predictions outside of a DataRobot prediction server. You need the \"Scoring Code\" feature enabled to use this route.  By default, returns a compiled executable JAR that can be executed locally to calculate model predictions, or it can be used as a library for a Java application. Execute it with the '--help` parameters to learn how to use it as a command-line utility. See model API documentation at https://javadoc.io/doc/com.datarobot/datarobot-prediction/latest/index.html to be able to use it inside an existing Java application.  With sourceCode query parameter set to 'true', returns a source code archive that can be used to review internal calculations of the model. This JAR is NOT executable.  See \"https://app.datarobot.com/docs/predictions/scoring-code/scorecode.html\" documentation in DataRobot application for more information.  *Note* Cannot retrieve source code if agent is included.     
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                source_code (str): Whether source code or binary of the Scoring Code will be retrieved. [optional] if omitted the server will use the default value of "false"
                include_agent (str): Whether the Scoring code retrieved will include tracking agent. [optional] if omitted the server will use the default value of "false"
                include_pe (str): Whether the Scoring Code retrieved will include prediction explanations. [optional] if omitted the server will use the default value of "false"
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/scoringCode/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def deployments_service_stats_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve service statistics

            Retrieve deployment service health statistics overview.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                model_id (str): The id of the model for which metrics are being retrieved.. [optional]
                execution_time_quantile (float): Quantile for `executionTime` metric, defaults to 0.5.. [optional] if omitted the server will use the default value of 0.5
                response_time_quantile (float): Quantile for `responseTime` metric, defaults to 0.5.. [optional] if omitted the server will use the default value of 0.5
                slow_requests_threshold (int): Threshold for `slowRequests` metric, defaults to 1000.. [optional] if omitted the server will use the default value of 1000
                monitoring_type (str): The monitoring type for which segment attributes and segment values are being retrieved. Can be one of three options which corresponds to a deployment monitoring tab. [optional] if omitted the server will use the default value of "serviceHealth"
            Returns:
                ServiceStatsRetrieveResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/serviceStats/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ServiceStatsRetrieveResponse(**server_data)

        @classmethod
        def deployments_service_stats_over_time_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve service statistics over time

            Retrieve deployment service health statistics over time data for one single metric.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
                metric (str): Name of the metric. See below for a list of supported metrics.. [optional] if omitted the server will use the default value of "totalPredictions"
                quantile (float): A quantile for resulting data, used if `metric` is `executionTime` or `responseTime`, defaults to 0.5.. [optional]
                threshold (int): A threshold for filtering results, used if `metric` is `slowQueries`, defaults to 1000.. [optional]
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
                model_id (str): The id of the model for which metrics are being retrieved.. [optional]
            Returns:
                ServiceStatsOverTimeResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/serviceStatsOverTime/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ServiceStatsOverTimeResponse(**server_data)

        @classmethod
        def deployments_settings_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Get deployment settings

            Retrieve deployment settings.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
            Returns:
                DeploymentSettingsResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/settings/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentSettingsResponse(**server_data)

        @classmethod
        def deployments_settings_patch_many(
            cls,
            deployment_id,
            **kwargs
        ):
            """Update deployment settings

            Updates deployment settings.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                deployment_settings_update (DeploymentSettingsUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/settings/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def deployments_shared_roles_list(
            cls,
            deployment_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get model deployment's access control list

            Get a list of users, groups and organizations who have access to this deployment and their roles.
            Args:
                deployment_id (str): The deployment ID.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                SharingListV2Response
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharingListV2Response(**server_data)

        @classmethod
        def deployments_shared_roles_patch_many(
            cls,
            deployment_id,
            **kwargs
        ):
            """Update model deployment's controls

            Set roles for users on this model deployment.
            Args:
                deployment_id (str): The deployment ID.

            Keyword Args:
                shared_roles_update_with_grant (SharedRolesUpdateWithGrant): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def deployments_target_drift_list(
            cls,
            deployment_id,
            **kwargs
        ):
            """Retrieve target drift

            Retrieve target drift data.
            Args:
                deployment_id (str): Unique identifier of the deployment.

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                model_id (str): An ID of the model in the deployment. If not set, defaults to the deployment current model.. [optional]
                metric (str): Metric used to calculate drift score.. [optional] if omitted the server will use the default value of "psi"
                segment_attribute (str): The name of a segment attribute used for segment analysis.. [optional]
                segment_value (str, none_type): The value of the `segmentAttribute` to segment on.. [optional] if omitted the server will use the default value of ""
            Returns:
                DeploymentTargetDriftResponse
            """
            path_args = {}
            kwargs['deployment_id'] = deployment_id
            path_args['deploymentId'] = deployment_id
            path = '/api/v2/deployments/{deploymentId}/targetDrift/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DeploymentTargetDriftResponse(**server_data)

        @classmethod
        def prediction_servers_list(
            cls,
            **kwargs
        ):
            """List prediction servers.

            List prediction servers available for a user.

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                PredictionServerListResponse
            """
            path_args = {}
            path = '/api/v2/predictionServers/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionServerListResponse(**server_data)

