#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.automated_doc_create import AutomatedDocCreate
from datarobot.models.full_api.generated.model.automated_doc_list_response import AutomatedDocListResponse
from datarobot.models.full_api.generated.model.automated_doc_options_response import AutomatedDocOptionsResponse
from datarobot.models.full_api.generated.model.compliance_doc_template_create import ComplianceDocTemplateCreate
from datarobot.models.full_api.generated.model.compliance_doc_template_create_response import ComplianceDocTemplateCreateResponse
from datarobot.models.full_api.generated.model.compliance_doc_template_default_retrieve_response import ComplianceDocTemplateDefaultRetrieveResponse
from datarobot.models.full_api.generated.model.compliance_doc_template_list_response import ComplianceDocTemplateListResponse
from datarobot.models.full_api.generated.model.compliance_doc_template_update import ComplianceDocTemplateUpdate
from datarobot.models.full_api.generated.model.shared_roles_update import SharedRolesUpdate
from datarobot.models.full_api.generated.model.sharing_list_v2_response import SharingListV2Response
from datarobot.models.full_api.generated.model.template_response import TemplateResponse


class DocumentationApi(APIObject):

        @classmethod
        def automated_document_options_list(
            cls,
            **kwargs
        ):
            """List all available document types and locales.

            Check which document types and locales are available for generation with your account.

            Keyword Args:
            Returns:
                AutomatedDocOptionsResponse
            """
            path_args = {}
            path = '/api/v2/automatedDocumentOptions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AutomatedDocOptionsResponse(**server_data)

        @classmethod
        def automated_documents_create(
            cls,
            **kwargs
        ):
            """Request generation of automated document

             Request generation of an automated document that's available for your account. Below is an example request body to generate Model Compliance documentation:  .. sourcecode:: json      {         \"documentType\": \"MODEL_COMPLIANCE\",         \"entityId\": \"507f191e810c19729de860ea\",         \"outputFormat\": \"docx\"     }  For Autopilot Summary, set a corresponding document type, ``AUTOPILOT_SUMMARY``, and assign a needed project ID to the ``entityId`` value.  After the request is sent, the jobs needed for document generation are queued. You can see the status of the generation by polling the URL in the ``Location`` headers. After the generation is complete, the status URL will automatically redirect you to the resource location to download the document.  

            Keyword Args:
                automated_doc_create (AutomatedDocCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/automatedDocuments/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def automated_documents_delete(
            cls,
            document_id,
            **kwargs
        ):
            """Delete automated document.

            Delete a document using its ID. Example request:      .. code-block:: text              DELETE https://app.datarobot.com/api/v2/automatedDocuments/5ec4ea7e41054c158c5b002f/ HTTP/1.1             Authorization: Bearer DnwzBUSTOtKBO5Sp1hoUByG4YgZwCCw4      
            Args:
                document_id (str): Unique identifier of the generated document.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['document_id'] = document_id
            path_args['documentId'] = document_id
            path = '/api/v2/automatedDocuments/{documentId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def automated_documents_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List all generated documents.

             Get information about all previously generated documents available for your account. The information includes document ID and type, ID of the entity it was generated for, time of creation, and other information.  Example request to get a list of all documents:  .. code-block:: text      GET https://app.datarobot.com/api/v2/automatedDocuments/ HTTP/1.1     Authorization: Bearer DnwzBUSTOtKBO5Sp1hoUByG4YgZwCCw4  Query for specific documents. For example, request a list of documents generated for a specific model in ``docx`` and ``html`` formats:  .. code-block:: text      GET https://app.datarobot.com/api/v2/automatedDocuments?entityId=     5ec4ea7e41054c158c5b002f&outputFormat=docx&outputFormat=html HTTP/1.1     Authorization: Bearer DnwzBUSTOtKBO5Sp1hoUByG4YgZwCCw4  In response body, you will get a page with queried documents. This is an example response with one document returned:  .. code-block:: json      {         \"totalCount\": 1,         \"count\": 1,         \"previous\": null,         \"next\": null,         \"data\": [             {                 \"id\": \"5ebdb5e911a5fb85edff2b3c\",                 \"documentType\": \"MODEL_COMPLIANCE\",                 \"entityId\": \"5ebbb5e7d9d7b96e3d48e3b5\",                 \"templateId\": \"5bd812e5f750edd392fa880f\",                 \"locale\": \"EN_US\",                 \"outputFormat\": \"DOCX\",                 \"createdAt\": \"2019-11-07T11:12:13.141516Z\"             }         ]     }  If there are no matching documents, you will get a page with an empty data array.
            Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. defaults to 0, must be one of [0]
                limit (int): Number of items to return, defaults to 100 if not provided.. defaults to 100, must be one of [100]

            Keyword Args:
                document_type (bool, date, datetime, dict, float, int, list, str, none_type): Query for one or more document types.. [optional]
                output_format (bool, date, datetime, dict, float, int, list, str, none_type): Query for one or more output formats.. [optional]
                locale (bool, date, datetime, dict, float, int, list, str, none_type): Query generated documents by one or more locales.. [optional]
                entity_id (bool, date, datetime, dict, float, int, list, str, none_type): Query generated documents by one or more entity IDs. For Model Compliance docs, the entity ID is a model ID. For Autopilot Summary reports, query by project IDs.. [optional]
            Returns:
                AutomatedDocListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/automatedDocuments/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AutomatedDocListResponse(**server_data)

        @classmethod
        def automated_documents_retrieve(
            cls,
            document_id,
            **kwargs
        ):
            """Download generated document.

             Download a generated Automated Documentation file.  .. code-block:: text      GET https://app.datarobot.com/api/v2/automatedDocuments/5ec4ea7e41054c158c5b002f/ HTTP/1.1     Authorization: Bearer DnwzBUSTOtKBO5Sp1hoUByG4YgZwCCw4  In response, you will get a file containing the generated documentation.
            Args:
                document_id (str): Unique identifier of the generated document.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['document_id'] = document_id
            path_args['documentId'] = document_id
            path = '/api/v2/automatedDocuments/{documentId}/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def compliance_doc_templates_create(
            cls,
            **kwargs
        ):
            """Create a new compliance documentation template

            Create a new compliance documentation template. One can retrieve the default DataRobot template via ``GET /api/v2/complianceDocTemplates/default/`` endpoint.

            Keyword Args:
                compliance_doc_template_create (ComplianceDocTemplateCreate): [optional]
            Returns:
                ComplianceDocTemplateCreateResponse
            """
            path_args = {}
            path = '/api/v2/complianceDocTemplates/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ComplianceDocTemplateCreateResponse(**server_data)

        @classmethod
        def compliance_doc_templates_default_list(
            cls,
            type="normal",
            **kwargs
        ):
            """Retrieve the default documentation template

            Retrieve the default documentation template.
            Args:
                type (str): Specifies the type of the default template to retrieve, either ``normal`` or ``timeSeries``. The ``normal`` template is applicable for all AutoML projects that are not time series. The ``timeSeries`` template is only applicable to time series projects.. defaults to "normal", must be one of ["normal"]

            Keyword Args:
            Returns:
                ComplianceDocTemplateDefaultRetrieveResponse
            """
            path_args = {}
            kwargs['type'] = type
            path_args['type'] = type
            path = '/api/v2/complianceDocTemplates/default/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ComplianceDocTemplateDefaultRetrieveResponse(**server_data)

        @classmethod
        def compliance_doc_templates_delete(
            cls,
            template_id,
            **kwargs
        ):
            """Delete a compliance documentation template

            Delete a compliance documentation template. Documentation previously generated using this template will remain unchanged.
            Args:
                template_id (str): The Id of a model compliance document template accessible by the user

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['template_id'] = template_id
            path_args['templateId'] = template_id
            path = '/api/v2/complianceDocTemplates/{templateId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def compliance_doc_templates_list(
            cls,
            **kwargs
        ):
            """List compliance documentation templates

            List user's custom-built compliance documentation templates.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                name_part (str): When present, only return templates with names that contain the given substring.. [optional] if omitted the server will use the default value of ""
                order_by (str): Sort order to apply to the dataset list. Prefix the attribute name with a dash to sort in descending order (e.g., orderBy='-id').. [optional] if omitted the server will use the default value of "id"
                labels (str, none_type): Name of labels to filter by.. [optional]
                project_type (str, none_type): Type of project templates to search for. If not specified, returns all project templates types.. [optional]
            Returns:
                ComplianceDocTemplateListResponse
            """
            path_args = {}
            path = '/api/v2/complianceDocTemplates/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ComplianceDocTemplateListResponse(**server_data)

        @classmethod
        def compliance_doc_templates_patch(
            cls,
            template_id,
            **kwargs
        ):
            """Update an existing model compliance documentation template

            Update an existing model compliance documentation template with the given ``templateId``. The template must be accessible by the user. If the ``templateId`` is not found for the user, the update cannot be performed. For a description of the template ``sections`` object options, see the sample ``sections`` on the schema below.
            Args:
                template_id (str): The Id of a model compliance document template accessible by the user

            Keyword Args:
                compliance_doc_template_update (ComplianceDocTemplateUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['template_id'] = template_id
            path_args['templateId'] = template_id
            path = '/api/v2/complianceDocTemplates/{templateId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def compliance_doc_templates_retrieve(
            cls,
            template_id,
            **kwargs
        ):
            """Retrieve a documentation template

            Retrieve a JSON representation of a custom Compliance Documentation template.
            Args:
                template_id (str): The Id of a model compliance document template accessible by the user

            Keyword Args:
            Returns:
                TemplateResponse
            """
            path_args = {}
            kwargs['template_id'] = template_id
            path_args['templateId'] = template_id
            path = '/api/v2/complianceDocTemplates/{templateId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return TemplateResponse(**server_data)

        @classmethod
        def compliance_doc_templates_shared_roles_list(
            cls,
            template_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get template's access control list

            Get a list of users, groups and organizations who have access to this template and their roles on the template.
            Args:
                template_id (str): The template identifier
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                SharingListV2Response
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['template_id'] = template_id
            path_args['templateId'] = template_id
            path = '/api/v2/complianceDocTemplates/{templateId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharingListV2Response(**server_data)

        @classmethod
        def compliance_doc_templates_shared_roles_patch_many(
            cls,
            template_id,
            **kwargs
        ):
            """Update template's access controls

            Set roles for users on this template.
            Args:
                template_id (str): The template identifier

            Keyword Args:
                shared_roles_update (SharedRolesUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['template_id'] = template_id
            path_args['templateId'] = template_id
            path = '/api/v2/complianceDocTemplates/{templateId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

