#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_driver_request import CreateDriverRequest
from datarobot.models.full_api.generated.model.driver_configuration_retrieve_response import DriverConfigurationRetrieveResponse
from datarobot.models.full_api.generated.model.driver_list_response import DriverListResponse
from datarobot.models.full_api.generated.model.driver_response import DriverResponse
from datarobot.models.full_api.generated.model.driver_upload_request import DriverUploadRequest
from datarobot.models.full_api.generated.model.driver_upload_response import DriverUploadResponse
from datarobot.models.full_api.generated.model.update_driver_request import UpdateDriverRequest


class DriversApi(APIObject):

        @classmethod
        def external_data_driver_file_create(
            cls,
            **kwargs
        ):
            """Upload JDBC driver from file.

            Upload JDBC driver from file. Only Java archive (.jar) files are supported.

            Keyword Args:
                driver_upload_request (DriverUploadRequest): [optional]
            Returns:
                DriverUploadResponse
            """
            path_args = {}
            path = '/api/v2/externalDataDriverFile/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverUploadResponse(**server_data)

        @classmethod
        def external_data_drivers_configuration_list(
            cls,
            driver_id,
            **kwargs
        ):
            """Driver configuration details.

            Retrieve the driver configuration with the specified ID.
            Args:
                driver_id (str): Driver ID.

            Keyword Args:
            Returns:
                DriverConfigurationRetrieveResponse
            """
            path_args = {}
            kwargs['driver_id'] = driver_id
            path_args['driverId'] = driver_id
            path = '/api/v2/externalDataDrivers/{driverId}/configuration/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverConfigurationRetrieveResponse(**server_data)

        @classmethod
        def external_data_drivers_create(
            cls,
            **kwargs
        ):
            """Create a new JDBC driver.

            Create a new JDBC driver. To create connections from fields, rather than supplying a JDBC URL, use 'configurationId'. When using 'configurationId', do not include 'canonicalName' or 'className' as they are part of the driver configuration. Specifying a 'version' is required as it is used in the construction of the canonicalName.

            Keyword Args:
                create_driver_request (CreateDriverRequest): [optional]
            Returns:
                DriverResponse
            """
            path_args = {}
            path = '/api/v2/externalDataDrivers/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverResponse(**server_data)

        @classmethod
        def external_data_drivers_delete(
            cls,
            driver_id,
            **kwargs
        ):
            """Delete the driver.

            Delete the driver with given ID if it is not used by any data store or data source.
            Args:
                driver_id (str): Driver ID.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['driver_id'] = driver_id
            path_args['driverId'] = driver_id
            path = '/api/v2/externalDataDrivers/{driverId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def external_data_drivers_list(
            cls,
            **kwargs
        ):
            """List drivers

            Fetch all drivers a user has access to.

            Keyword Args:
            Returns:
                DriverListResponse
            """
            path_args = {}
            path = '/api/v2/externalDataDrivers/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverListResponse(**server_data)

        @classmethod
        def external_data_drivers_patch(
            cls,
            driver_id,
            **kwargs
        ):
            """Update properties of an existing JDBC Driver.

            Update properties of an existing JDBC driver. To change the canonicalName and className, you must first remove the driver configuration, if it exists, as its properties will otherwise override name changes.
            Args:
                driver_id (str): Driver ID.

            Keyword Args:
                update_driver_request (UpdateDriverRequest): [optional]
            Returns:
                DriverResponse
            """
            path_args = {}
            kwargs['driver_id'] = driver_id
            path_args['driverId'] = driver_id
            path = '/api/v2/externalDataDrivers/{driverId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverResponse(**server_data)

        @classmethod
        def external_data_drivers_retrieve(
            cls,
            driver_id,
            **kwargs
        ):
            """Retrieve driver details.

            Retrieve driver details by ID.
            Args:
                driver_id (str): Driver ID.

            Keyword Args:
            Returns:
                DriverResponse
            """
            path_args = {}
            kwargs['driver_id'] = driver_id
            path_args['driverId'] = driver_id
            path = '/api/v2/externalDataDrivers/{driverId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverResponse(**server_data)

