#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.eureqa_distribution_detail_response import EureqaDistributionDetailResponse
from datarobot.models.full_api.generated.model.eureqa_leaderboard_entry_payload import EureqaLeaderboardEntryPayload
from datarobot.models.full_api.generated.model.eureqa_model_detail_response import EureqaModelDetailResponse
from datarobot.models.full_api.generated.model.pareto_front_response import ParetoFrontResponse


class EureqaApi(APIObject):

        @classmethod
        def projects_eureqa_distribution_plot_retrieve(
            cls,
            project_id,
            solution_id,
            **kwargs
        ):
            """Retrieve Eureqa model details plot.

            Retrieve Eureqa model details plot.  Available for classification projects only
            Args:
                project_id (str): The project ID
                solution_id (str): The ID of the solution to return data for.

            Keyword Args:
            Returns:
                EureqaDistributionDetailResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['solution_id'] = solution_id
            path_args['solutionId'] = solution_id
            path = '/api/v2/projects/{projectId}/eureqaDistributionPlot/{solutionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return EureqaDistributionDetailResponse(**server_data)

        @classmethod
        def projects_eureqa_model_detail_retrieve(
            cls,
            project_id,
            solution_id,
            **kwargs
        ):
            """Retrieve Eureqa model details plot.

            Retrieve Eureqa model details plot.  Available for regression projects only
            Args:
                project_id (str): The project ID
                solution_id (str): The ID of the solution to return data for.

            Keyword Args:
            Returns:
                EureqaModelDetailResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['solution_id'] = solution_id
            path_args['solutionId'] = solution_id
            path = '/api/v2/projects/{projectId}/eureqaModelDetail/{solutionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return EureqaModelDetailResponse(**server_data)

        @classmethod
        def projects_eureqa_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new model from an existing eureqa solution.

            Create a new model from an existing eureqa solution.
            Args:
                project_id (str): The project ID

            Keyword Args:
                eureqa_leaderboard_entry_payload (EureqaLeaderboardEntryPayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/eureqaModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_eureqa_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the pareto front for the specified Eureqa model.

            Retrieve the pareto front for the specified Eureqa model.  Only the best solution in the pareto front will have a corresponding model initially. Models can be created for other solutions using :http:post:`/api/v2/projects/(projectId)/eureqaModels/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ParetoFrontResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/eureqaModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ParetoFrontResponse(**server_data)

