#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.driver_configuration_list_response import DriverConfigurationListResponse
from datarobot.models.full_api.generated.model.driver_configuration_retrieve_response import DriverConfigurationRetrieveResponse


class ExternalDriversApi(APIObject):

        @classmethod
        def external_driver_configurations_list(
            cls,
            **kwargs
        ):
            """List available driver configurations.

            Retrieve matching driver configurations based on query.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                type (str): Type of driver configurations to return.. [optional] if omitted the server will use the default value of "jdbc"
                show_hidden (str): If True, include hidden configurations in response.. [optional] if omitted the server will use the default value of "False"
            Returns:
                DriverConfigurationListResponse
            """
            path_args = {}
            path = '/api/v2/externalDriverConfigurations/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverConfigurationListResponse(**server_data)

        @classmethod
        def external_driver_configurations_retrieve(
            cls,
            configuration_id,
            **kwargs
        ):
            """Driver configuration details.

            Retrieve the driver configuration with the specified ID.
            Args:
                configuration_id (str): Driver configuration ID

            Keyword Args:
            Returns:
                DriverConfigurationRetrieveResponse
            """
            path_args = {}
            kwargs['configuration_id'] = configuration_id
            path_args['configurationId'] = configuration_id
            path = '/api/v2/externalDriverConfigurations/{configurationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DriverConfigurationRetrieveResponse(**server_data)

