#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.feature_discovery_log_list_response import FeatureDiscoveryLogListResponse
from datarobot.models.full_api.generated.model.feature_discovery_recipe_sqls_export import FeatureDiscoveryRecipeSQLsExport
from datarobot.models.full_api.generated.model.relationships_config_create import RelationshipsConfigCreate
from datarobot.models.full_api.generated.model.relationships_config_response import RelationshipsConfigResponse


class FeatureDiscoveryApi(APIObject):

        @classmethod
        def projects_feature_discovery_dataset_download_list(
            cls,
            project_id,
            **kwargs
        ):
            """Download the project dataset with features added by feature discovery

            Download the project dataset with features added by feature discovery
            Args:
                project_id (str): The project ID

            Keyword Args:
                dataset_id (str): The ID of the dataset to use for the prediction.. [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureDiscoveryDatasetDownload/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_feature_discovery_logs_download_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve a text file containing the feature discovery log

            Retrieve a text file containing the feature discovery log. This route is only supported for feature discovery projects that have finished partitioning.
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureDiscoveryLogs/download/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_feature_discovery_logs_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve the feature discovery log content and log length

            Retrieve the feature discovery log content and log length for a feature discovery project. This route is only supported for feature discovery projects that have finished partitioning
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
            Returns:
                FeatureDiscoveryLogListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureDiscoveryLogs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureDiscoveryLogListResponse(**server_data)

        @classmethod
        def projects_feature_discovery_recipe_sql_exports_create(
            cls,
            project_id,
            **kwargs
        ):
            """Generate feature discovery SQL recipe

            Generate feature discovery SQL recipe for a project
            Args:
                project_id (str): The project ID

            Keyword Args:
                feature_discovery_recipe_sqls_export (FeatureDiscoveryRecipeSQLsExport): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureDiscoveryRecipeSqlExports/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_feature_discovery_recipe_sqls_download_list(
            cls,
            project_id,
            **kwargs
        ):
            """Download feature discovery SQL recipe

            Download feature discovery SQL recipe for a project
            Args:
                project_id (str): The project ID

            Keyword Args:
                model_id (str): Model ID to export recipe for. [optional]
                status_only (str): Return status only for availability check. [optional] if omitted the server will use the default value of "false"
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureDiscoveryRecipeSQLs/download/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def relationships_configurations_create(
            cls,
            **kwargs
        ):
            """Create a relationships configuration

            Create a relationships configuration

            Keyword Args:
                relationships_config_create (RelationshipsConfigCreate): [optional]
            Returns:
                RelationshipsConfigResponse
            """
            path_args = {}
            path = '/api/v2/relationshipsConfigurations/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RelationshipsConfigResponse(**server_data)

        @classmethod
        def relationships_configurations_delete(
            cls,
            relationships_configuration_id,
            **kwargs
        ):
            """Delete a relationships configuration

            Delete a relationships configuration
            Args:
                relationships_configuration_id (str): Id of the relationships configuration to delete

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['relationships_configuration_id'] = relationships_configuration_id
            path_args['relationshipsConfigurationId'] = relationships_configuration_id
            path = '/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def relationships_configurations_put(
            cls,
            relationships_configuration_id,
            **kwargs
        ):
            """Replace a relationships configuration

            Replace a relationships configuration
            Args:
                relationships_configuration_id (str): Id of the relationships configuration to delete

            Keyword Args:
                relationships_config_create (RelationshipsConfigCreate): [optional]
            Returns:
                RelationshipsConfigResponse
            """
            path_args = {}
            kwargs['relationships_configuration_id'] = relationships_configuration_id
            path_args['relationshipsConfigurationId'] = relationships_configuration_id
            path = '/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(**path_args)
            server_data = (cls._client.put(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RelationshipsConfigResponse(**server_data)

        @classmethod
        def relationships_configurations_retrieve(
            cls,
            relationships_configuration_id,
            **kwargs
        ):
            """Retrieve a relationships configuration

            Retrieve a relationships configuration
            Args:
                relationships_configuration_id (str): Id of the relationships configuration to delete

            Keyword Args:
            Returns:
                RelationshipsConfigResponse
            """
            path_args = {}
            kwargs['relationships_configuration_id'] = relationships_configuration_id
            path_args['relationshipsConfigurationId'] = relationships_configuration_id
            path = '/api/v2/relationshipsConfigurations/{relationshipsConfigurationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RelationshipsConfigResponse(**server_data)

