#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_featurelist import CreateFeaturelist
from datarobot.models.full_api.generated.model.featurelist_destroy_response import FeaturelistDestroyResponse
from datarobot.models.full_api.generated.model.featurelist_list_response import FeaturelistListResponse
from datarobot.models.full_api.generated.model.featurelist_response import FeaturelistResponse
from datarobot.models.full_api.generated.model.update_featurelist import UpdateFeaturelist


class FeaturelistsApi(APIObject):

        @classmethod
        def projects_featurelists_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new featurelist.

            Create a new featurelist from list of feature names.
            Args:
                project_id (str): The project ID

            Keyword Args:
                create_featurelist (CreateFeaturelist): [optional]
            Returns:
                FeaturelistResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featurelists/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistResponse(**server_data)

        @classmethod
        def projects_featurelists_delete(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Delete a specified featurelist.

            Delete a specified featurelist. All models using a featurelist, whether as the training featurelist or as a monotonic constraint featurelist, will also be deleted when the deletion is executed and any queued or running jobs using it will be cancelled. Similarly, predictions made on these models will also be deleted. All the entities that are to be deleted with a featurelist are described as \"dependencies\" of it. When deleting a featurelist with dependencies, users must pass an additional query parameter `deleteDependencies` to confirm they want to delete the featurelist and all its dependencies. Without that option, only featurelists with no dependencies may be successfully deleted. Featurelists configured into the project as a default featurelist or as a default monotonic constraint featurelist cannot be deleted. Featurelists used in a model deployment cannot be deleted until the model deployment is deleted.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
                dry_run (str): Preview the deletion results without actually deleting the featurelist.. [optional] if omitted the server will use the default value of "false"
                delete_dependencies (str): Automatically delete all dependencies of a featurelist. If false (default), will only delete the featurelist if it has no dependencies. The value of deleteDependencies will not be used if dryRun is true.If a featurelist has dependencies, deleteDependencies must be true for the request to succeed.. [optional] if omitted the server will use the default value of "false"
            Returns:
                FeaturelistDestroyResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.delete(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistDestroyResponse(**server_data)

        @classmethod
        def projects_featurelists_list(
            cls,
            project_id,
            **kwargs
        ):
            """List featurelists

            List all featurelists for a project.
            Args:
                project_id (str): The project ID.

            Keyword Args:
            Returns:
                FeaturelistListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featurelists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistListResponse(**server_data)

        @classmethod
        def projects_featurelists_patch(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Update an existing featurelist

            Update an existing featurelist by ID.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
                update_featurelist (UpdateFeaturelist): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def projects_featurelists_retrieve(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Retrieve a feature list

            Retrieve a single known feature list.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
            Returns:
                FeaturelistResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/featurelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistResponse(**server_data)

        @classmethod
        def projects_modeling_featurelists_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new modeling featurelist.

            Create new modeling featurelist from list of feature names. Only time series projects differentiate between modeling and input featurelists. On other projects, this route will behave the same as :http:post:`/api/v2/projects/(projectId)/featurelists/`. On time series projects, this can be used after the target has been set in order to create a new featurelist on the modeling features, although the previously mentioned route for creating featurelists will be disabled. On time series projects, only modeling features may be passed to this route to create a featurelist.
            Args:
                project_id (str): The project ID

            Keyword Args:
                create_featurelist (CreateFeaturelist): [optional]
            Returns:
                FeaturelistResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/modelingFeaturelists/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistResponse(**server_data)

        @classmethod
        def projects_modeling_featurelists_delete(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Delete a specified modeling featurelist.

            Delete a specified modeling featurelist. All models using a featurelist, whether as the training featurelist or as a monotonic constraint featurelist, will also be deleted when the deletion is executed and any queued or running jobs using it will be cancelled. Similarly, predictions made on these models will also be deleted. All the entities that are to be deleted with a featurelist are described as \"dependencies\" of it. When deleting a featurelist with dependencies, users must pass an additional query parameter `deleteDependencies` to confirm they want to delete the featurelist and all its dependencies. Without that option, only featurelists with no dependencies may be successfully deleted. Featurelists configured into the project as a default featurelist or as a default monotonic constraint featurelist cannot be deleted. Featurelists used in a model deployment cannot be deleted until the model deployment is deleted. Modeling featurelists are featurelists of modeling features, and are the appropriate featurelists to use when creating models or restarting the autopilot. In a time series project, these will be distinct from those returned from :http:get:`/api/v2/projects/(projectId)/featurelists/` while in other projects these will be identical.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
                dry_run (str): Preview the deletion results without actually deleting the featurelist.. [optional] if omitted the server will use the default value of "false"
                delete_dependencies (str): Automatically delete all dependencies of a featurelist. If false (default), will only delete the featurelist if it has no dependencies. The value of deleteDependencies will not be used if dryRun is true.If a featurelist has dependencies, deleteDependencies must be true for the request to succeed.. [optional] if omitted the server will use the default value of "false"
            Returns:
                FeaturelistDestroyResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.delete(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistDestroyResponse(**server_data)

        @classmethod
        def projects_modeling_featurelists_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List all modeling featurelists from a project

            List all modeling featurelists from the project requested by ID. This route will only become available after the target and partitioning options have been set for a project. Modeling featurelists are featurelists of modeling features, and are the correct featurelists to use when creating models or restarting the autopilot. In a time series project, these will differ from those returned from :http:get:`/api/v2/projects/(projectId)/featurelists/` while in other projects these will be identical. See the :ref:`documentation <input_vs_modeling>` for more information on the distinction between input and modeling data in time series projects.
            Args:
                project_id (str): The project ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                FeaturelistListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/modelingFeaturelists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistListResponse(**server_data)

        @classmethod
        def projects_modeling_featurelists_patch(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Update an existing modeling featurelist

            Update an existing modeling featurelist by ID. In non-time series projects, \"modeling featurelists\" and \"featurelists\" routes behave the same, except \"modeling featurelists\" are only accessible after the project is ready for modeling.  In time series projects, \"featurelists\" contain the input features before feature derivation that are used to derive the time series features, while  \"modeling featurelists\" contain the derived time series features used for modeling.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
                update_featurelist (UpdateFeaturelist): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def projects_modeling_featurelists_retrieve(
            cls,
            project_id,
            featurelist_id,
            **kwargs
        ):
            """Retrieve a single modeling featurelist by ID

            Retrieve a single modeling featurelist by ID. When reporting the number of models that \"use\" a featurelist, a model is considered to use a featurelist if it is used as to train the model or as a monotonic constraint featurelist, or if the model is a blender with component models that use the featurelist. This route will only become available after the target and partitioning options have been set for a project. Modeling featurelists are featurelists of modeling features, and are the appropriate featurelists to use when creating models or restarting the autopilot. In a time series project, these will be distinct from those returned from :http:get:`/api/v2/projects/(projectId)/featurelists/` while in other projects these will be identical.
            Args:
                project_id (str): The project ID.
                featurelist_id (str): The featurelist ID.

            Keyword Args:
            Returns:
                FeaturelistResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['featurelist_id'] = featurelist_id
            path_args['featurelistId'] = featurelist_id
            path = '/api/v2/projects/{projectId}/modelingFeaturelists/{featurelistId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeaturelistResponse(**server_data)

