#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.batch_feature_transform import BatchFeatureTransform
from datarobot.models.full_api.generated.model.batch_feature_transform_retrieve_response import BatchFeatureTransformRetrieveResponse
from datarobot.models.full_api.generated.model.feature_histogram_response import FeatureHistogramResponse
from datarobot.models.full_api.generated.model.feature_lineage_response import FeatureLineageResponse
from datarobot.models.full_api.generated.model.feature_metrics_response import FeatureMetricsResponse
from datarobot.models.full_api.generated.model.feature_transform import FeatureTransform
from datarobot.models.full_api.generated.model.modeling_feature_list_response import ModelingFeatureListResponse
from datarobot.models.full_api.generated.model.modeling_feature_response import ModelingFeatureResponse
from datarobot.models.full_api.generated.model.project_feature_response import ProjectFeatureResponse


class FeaturesApi(APIObject):

        @classmethod
        def projects_batch_type_transform_features_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create multiple new features by changing the type of existing features.

            Create multiple new features by changing the type of existing features.
            Args:
                project_id (str): The project to create the feature in.

            Keyword Args:
                batch_feature_transform (BatchFeatureTransform): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/batchTypeTransformFeatures/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_batch_type_transform_features_result_retrieve(
            cls,
            project_id,
            job_id,
            **kwargs
        ):
            """Retrieve the result of a batch variable type transformation.

            Retrieve the result of a batch variable type transformation.
            Args:
                project_id (str): The project containing transformed features.
                job_id (int): ID of the batch variable type transformation job.

            Keyword Args:
                batch_feature_transform (BatchFeatureTransform): [optional]
            Returns:
                BatchFeatureTransformRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/projects/{projectId}/batchTypeTransformFeaturesResult/{jobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchFeatureTransformRetrieveResponse(**server_data)

        @classmethod
        def projects_feature_histograms_retrieve(
            cls,
            project_id,
            feature_name,
            bin_limit=60,
            **kwargs
        ):
            """Get feature histogram

            Get histogram chart data for a specific feature. Information that can be used to build histogram charts. Plot data returned is based on raw data that is calculated during initial project creation and updated after the project's target variable has been selected. The number of bins in the histogram is no greater than the requested limit.
            Args:
                project_id (str): The ID of the project
                feature_name (str): the name of the feature Note: DataRobot renames some features, so the feature name may not be the one from your original data. You can use :http:get:`/api/v2/projects/(projectId)/features/` to list the features and check the name. Note to users with non-ascii features names: The feature name should be utf-8-encoded (before URL-quoting) 
                bin_limit (int): maximum number of bins in the returned plot. defaults to 60, must be one of [60]

            Keyword Args:
                key (str): name of the top 50 key for which plot to be retrieved. (Only required for the Summarized categorical feature). [optional]
            Returns:
                FeatureHistogramResponse
            """
            path_args = {}
            kwargs['bin_limit'] = bin_limit
            path_args['binLimit'] = bin_limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/projects/{projectId}/featureHistograms/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureHistogramResponse(**server_data)

        @classmethod
        def projects_feature_lineages_retrieve(
            cls,
            project_id,
            feature_lineage_id,
            **kwargs
        ):
            """Retrieve Feature Discovery Lineage

            Retrieve single Feature Discovery feature lineage.
            Args:
                project_id (str): The project to retrieve a lineage from.
                feature_lineage_id (str): id of a feature lineage object to return. You can access the id with  *ModelingFeatureRetrieveController*.

            Keyword Args:
            Returns:
                FeatureLineageResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_lineage_id'] = feature_lineage_id
            path_args['featureLineageId'] = feature_lineage_id
            path = '/api/v2/projects/{projectId}/featureLineages/{featureLineageId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureLineageResponse(**server_data)

        @classmethod
        def projects_features_list(
            cls,
            project_id,
            **kwargs
        ):
            """List project features

            List the features from a project with descriptive information.
            Args:
                project_id (str): The project ID.

            Keyword Args:
                for_segmented_analysis (str): When True, features returned will be filtered to those usable for segmented analysis.. [optional] if omitted the server will use the default value of "false"
            Returns:
                ProjectFeatureResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/features/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ProjectFeatureResponse(**server_data)

        @classmethod
        def projects_features_metrics_list(
            cls,
            feature_name,
            project_id,
            **kwargs
        ):
            """List feature metrics

            List the appropriate metrics if a feature were chosen as the target. The metrics listed will include both weighted and unweighted metrics - which are appropriate will depend on whether a weights column is used.
            Args:
                feature_name (str): The name of the feature to check
                project_id (str): The project ID.

            Keyword Args:
            Returns:
                FeatureMetricsResponse
            """
            path_args = {}
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/features/metrics/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureMetricsResponse(**server_data)

        @classmethod
        def projects_features_retrieve(
            cls,
            project_id,
            feature_name,
            **kwargs
        ):
            """Get project feature

            Retrieve the specified feature with descriptive information. Descriptive information for features also includes summary statistics as of v2.8. These are returned via the fields max, min, mean, median, and stdDev. These fields are formatted according to the original feature type of the feature. For example, the format will be numeric if your feature is numeric, in feet and inches if your feature is length type, in currency if your feature is currency type, in time format if your feature is time type, or in ISO date format if your feature is a date type. Numbers will be rounded so that they have at most two non-zero decimal digits. For projects created prior to v2.8, these descriptive statistics will not be available. Also, some features, like categorical and text features, may not have summary statistics.
            Args:
                project_id (str): The ID of the project
                feature_name (str): the name of the feature Note: DataRobot renames some features, so the feature name may not be the one from your original data. You can use :http:get:`/api/v2/projects/(projectId)/features/` to list the features and check the name. Note to users with non-ascii features names: The feature name should be utf-8-encoded (before URL-quoting) 

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/projects/{projectId}/features/{featureName}/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_modeling_features_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List project modeling features.

            List the features from a project that are used for modeling with descriptive information.
            Args:
                project_id (str): The project ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                ModelingFeatureListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/modelingFeatures/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelingFeatureListResponse(**server_data)

        @classmethod
        def projects_modeling_features_retrieve(
            cls,
            project_id,
            feature_name,
            **kwargs
        ):
            """Retrieve project modeling feature.

            Retrieve the specified modeling feature with descriptive information.
            Args:
                project_id (str): The ID of the project
                feature_name (str): the name of the feature Note: DataRobot renames some features, so the feature name may not be the one from your original data. You can use :http:get:`/api/v2/projects/(projectId)/features/` to list the features and check the name. Note to users with non-ascii features names: The feature name should be utf-8-encoded (before URL-quoting) 

            Keyword Args:
            Returns:
                ModelingFeatureResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/projects/{projectId}/modelingFeatures/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelingFeatureResponse(**server_data)

        @classmethod
        def projects_type_transform_features_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new feature by changing the type of an existing one.

            Create a new feature by changing the type of an existing one.
            Args:
                project_id (str): The project to create the feature in.

            Keyword Args:
                feature_transform (FeatureTransform): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/typeTransformFeatures/'.format(**path_args)
            cls._client.post(path, data=kwargs)

