#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.approval_policy import ApprovalPolicy
from datarobot.models.full_api.generated.model.approval_policy_list_response import ApprovalPolicyListResponse
from datarobot.models.full_api.generated.model.approval_policy_match_response import ApprovalPolicyMatchResponse
from datarobot.models.full_api.generated.model.approval_policy_response import ApprovalPolicyResponse
from datarobot.models.full_api.generated.model.approval_workflow_list_trigger_response import ApprovalWorkflowListTriggerResponse
from datarobot.models.full_api.generated.model.change_request_info_list_response import ChangeRequestInfoListResponse


class GovernanceApi(APIObject):

        @classmethod
        def approval_policies_create(
            cls,
            **kwargs
        ):
            """Create a new Approval Policy.

            Create a new Approval Policy.

            Keyword Args:
                approval_policy (ApprovalPolicy): [optional]
            Returns:
                ApprovalPolicyResponse
            """
            path_args = {}
            path = '/api/v2/approvalPolicies/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalPolicyResponse(**server_data)

        @classmethod
        def approval_policies_delete(
            cls,
            approval_policy_id,
            **kwargs
        ):
            """Delete an Approval Policy.

            Delete the policy with the given ID.
            Args:
                approval_policy_id (str): ID of the Approval Policy.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['approval_policy_id'] = approval_policy_id
            path_args['approvalPolicyId'] = approval_policy_id
            path = '/api/v2/approvalPolicies/{approvalPolicyId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def approval_policies_list(
            cls,
            **kwargs
        ):
            """List Approval Policies.

            List Approval Policies.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                entity_type (str): Type of entity to filter policies by.. [optional]
                name_part (str): Part of the policy name to search by.. [optional]
            Returns:
                ApprovalPolicyListResponse
            """
            path_args = {}
            path = '/api/v2/approvalPolicies/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalPolicyListResponse(**server_data)

        @classmethod
        def approval_policies_put(
            cls,
            approval_policy_id,
            **kwargs
        ):
            """Update an Approval Policy.

            Update the policy with the given ID.
            Args:
                approval_policy_id (str): ID of the Approval Policy.

            Keyword Args:
                approval_policy (ApprovalPolicy): [optional]
            Returns:
                ApprovalPolicyResponse
            """
            path_args = {}
            kwargs['approval_policy_id'] = approval_policy_id
            path_args['approvalPolicyId'] = approval_policy_id
            path = '/api/v2/approvalPolicies/{approvalPolicyId}/'.format(**path_args)
            server_data = (cls._client.put(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalPolicyResponse(**server_data)

        @classmethod
        def approval_policies_retrieve(
            cls,
            approval_policy_id,
            **kwargs
        ):
            """Retrieve an Approval Policy.

            Retrieve the policy with the given ID.
            Args:
                approval_policy_id (str): ID of the Approval Policy.

            Keyword Args:
            Returns:
                ApprovalPolicyResponse
            """
            path_args = {}
            kwargs['approval_policy_id'] = approval_policy_id
            path_args['approvalPolicyId'] = approval_policy_id
            path = '/api/v2/approvalPolicies/{approvalPolicyId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalPolicyResponse(**server_data)

        @classmethod
        def approval_policies_shareable_change_requests_list(
            cls,
            approval_policy_id,
            **kwargs
        ):
            """Retrieve associated Change Requests Info.

            Get information about Change Requests submitted for a certain Approval Policy.
            Args:
                approval_policy_id (str): ID of the Approval Policy.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                order_by (str): Attribute to order Change Requests by.. [optional] if omitted the server will use the default value of ""
            Returns:
                ChangeRequestInfoListResponse
            """
            path_args = {}
            kwargs['approval_policy_id'] = approval_policy_id
            path_args['approvalPolicyId'] = approval_policy_id
            path = '/api/v2/approvalPolicies/{approvalPolicyId}/shareableChangeRequests/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ChangeRequestInfoListResponse(**server_data)

        @classmethod
        def approval_policy_match_list(
            cls,
            entity_type,
            action,
            **kwargs
        ):
            """Get policy ID matching the query

            Get policy ID matching the query
            Args:
                entity_type (str): Searched typed of the entity.
                action (str): Searched policy action.

            Keyword Args:
                field_name (str, none_type): Name of the entity field to filter policies by.. [optional]
                field_value (str, none_type): Value of the entity field to filter policies by.. [optional]
            Returns:
                ApprovalPolicyMatchResponse
            """
            path_args = {}
            kwargs['entity_type'] = entity_type
            path_args['entityType'] = entity_type
            kwargs['action'] = action
            path_args['action'] = action
            path = '/api/v2/approvalPolicyMatch/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalPolicyMatchResponse(**server_data)

        @classmethod
        def approval_policy_triggers_list(
            cls,
            **kwargs
        ):
            """Get a list of available policy triggers.

            Get a list of available policy triggers.

            Keyword Args:
            Returns:
                ApprovalWorkflowListTriggerResponse
            """
            path_args = {}
            path = '/api/v2/approvalPolicyTriggers/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ApprovalWorkflowListTriggerResponse(**server_data)

