#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.add_users_to_group_response import AddUsersToGroupResponse
from datarobot.models.full_api.generated.model.list_users_in_group_response import ListUsersInGroupResponse
from datarobot.models.full_api.generated.model.modify_users_in_group import ModifyUsersInGroup
from datarobot.models.full_api.generated.model.user_group_bulk_delete import UserGroupBulkDelete
from datarobot.models.full_api.generated.model.user_group_create import UserGroupCreate
from datarobot.models.full_api.generated.model.user_group_response import UserGroupResponse
from datarobot.models.full_api.generated.model.user_group_update import UserGroupUpdate


class GroupsApi(APIObject):

        @classmethod
        def groups_create(
            cls,
            **kwargs
        ):
            """Create user group

            Create a new user group.

            Keyword Args:
                user_group_create (UserGroupCreate): [optional]
            Returns:
                UserGroupResponse
            """
            path_args = {}
            path = '/api/v2/groups/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserGroupResponse(**server_data)

        @classmethod
        def groups_delete(
            cls,
            group_id,
            **kwargs
        ):
            """Delete user group

            Delete the user group.
            Args:
                group_id (str): The identifier of the user group.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def groups_delete_many(
            cls,
            **kwargs
        ):
            """Delete multiple user groups

            Delete the user groups.

            Keyword Args:
                user_group_bulk_delete (UserGroupBulkDelete): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/groups/'.format(**path_args)
            cls._client.delete(path, data=kwargs)

        @classmethod
        def groups_patch(
            cls,
            group_id,
            **kwargs
        ):
            """Update user group

            Update the user group.
            Args:
                group_id (str): The identifier of the user group.

            Keyword Args:
                user_group_update (UserGroupUpdate): [optional]
            Returns:
                UserGroupResponse
            """
            path_args = {}
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserGroupResponse(**server_data)

        @classmethod
        def groups_retrieve(
            cls,
            group_id,
            **kwargs
        ):
            """Retrieve user group

            Retrieve the user group.
            Args:
                group_id (str): The identifier of the user group.

            Keyword Args:
            Returns:
                UserGroupResponse
            """
            path_args = {}
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserGroupResponse(**server_data)

        @classmethod
        def groups_users_create(
            cls,
            group_id,
            **kwargs
        ):
            """Add users to group

            Add users to the group.
            Args:
                group_id (str): The identifier of the user group.

            Keyword Args:
                modify_users_in_group (ModifyUsersInGroup): [optional]
            Returns:
                AddUsersToGroupResponse
            """
            path_args = {}
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/users/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AddUsersToGroupResponse(**server_data)

        @classmethod
        def groups_users_delete_many(
            cls,
            group_id,
            **kwargs
        ):
            """Remove users from group

            Remove users from the group.
            Args:
                group_id (str): The identifier of the user group.

            Keyword Args:
                modify_users_in_group (ModifyUsersInGroup): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/users/'.format(**path_args)
            cls._client.delete(path, data=kwargs)

        @classmethod
        def groups_users_list(
            cls,
            group_id,
            offset=0,
            limit=50,
            **kwargs
        ):
            """List users in group

            List users in the group.
            Args:
                group_id (str): The identifier of the user group.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned.. defaults to 50, must be one of [50]

            Keyword Args:
                name_part (str): User groups must contain the substring.. [optional] if omitted the server will use the default value of ""
                order_by (str): The order that the results should be retrieved in. Prefix the attribute name with a dash to sort in descending order, e.g. `orderBy=-name`.. [optional] if omitted the server will use the default value of ""
            Returns:
                ListUsersInGroupResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['group_id'] = group_id
            path_args['groupId'] = group_id
            path = '/api/v2/groups/{groupId}/users/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ListUsersInGroupResponse(**server_data)

