#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.image_augmentation_create_list import ImageAugmentationCreateList
from datarobot.models.full_api.generated.model.image_augmentation_list_create_response import ImageAugmentationListCreateResponse
from datarobot.models.full_api.generated.model.image_augmentation_list_patch_param import ImageAugmentationListPatchParam
from datarobot.models.full_api.generated.model.image_augmentation_lists_response import ImageAugmentationListsResponse
from datarobot.models.full_api.generated.model.image_augmentation_options_response import ImageAugmentationOptionsResponse
from datarobot.models.full_api.generated.model.image_augmentation_retrieve_list import ImageAugmentationRetrieveList
from datarobot.models.full_api.generated.model.image_augmentation_retrieve_samples_response import ImageAugmentationRetrieveSamplesResponse
from datarobot.models.full_api.generated.model.image_augmentation_samples_request import ImageAugmentationSamplesRequest
from datarobot.models.full_api.generated.model.image_augmentation_samples_response import ImageAugmentationSamplesResponse


class ImageAugmentationApi(APIObject):

        @classmethod
        def image_augmentation_lists_create(
            cls,
            **kwargs
        ):
            """Creates a new augmentation list based on the posted payload data.

            Creates a new augmentation list based on the posted payload data.

            Keyword Args:
                image_augmentation_create_list (ImageAugmentationCreateList): [optional]
            Returns:
                ImageAugmentationListCreateResponse
            """
            path_args = {}
            path = '/api/v2/imageAugmentationLists/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationListCreateResponse(**server_data)

        @classmethod
        def image_augmentation_lists_delete(
            cls,
            augmentation_id,
            **kwargs
        ):
            """Delete an existing augmentation lists by id

            Delete an existing augmentation lists by id
            Args:
                augmentation_id (str): The id of the augmentation list to fetch

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['augmentation_id'] = augmentation_id
            path_args['augmentationId'] = augmentation_id
            path = '/api/v2/imageAugmentationLists/{augmentationId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def image_augmentation_lists_list(
            cls,
            project_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List of augmentation lists that match the specified query.

            List of augmentation lists that match the specified query.
            Args:
                project_id (str): Project ID to retrieve augmentation lists from
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change without notice.. defaults to 100, must be one of [100]

            Keyword Args:
                feature_name (str): Name of the image feature that the augmentation list is associated with. [optional]
            Returns:
                ImageAugmentationListsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/imageAugmentationLists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationListsResponse(**server_data)

        @classmethod
        def image_augmentation_lists_patch(
            cls,
            augmentation_id,
            **kwargs
        ):
            """Update and existing augmentation list, with passed in values.

            Update and existing augmentation list, with passed in values.
            Args:
                augmentation_id (str): The id of the augmentation list to fetch

            Keyword Args:
                image_augmentation_list_patch_param (ImageAugmentationListPatchParam): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['augmentation_id'] = augmentation_id
            path_args['augmentationId'] = augmentation_id
            path = '/api/v2/imageAugmentationLists/{augmentationId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def image_augmentation_lists_retrieve(
            cls,
            augmentation_id,
            **kwargs
        ):
            """Returns a single augmentation list with the specified id.

            Returns a single augmentation list with the specified id.
            Args:
                augmentation_id (str): The id of the augmentation list to fetch

            Keyword Args:
            Returns:
                ImageAugmentationRetrieveList
            """
            path_args = {}
            kwargs['augmentation_id'] = augmentation_id
            path_args['augmentationId'] = augmentation_id
            path = '/api/v2/imageAugmentationLists/{augmentationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationRetrieveList(**server_data)

        @classmethod
        def image_augmentation_options_retrieve(
            cls,
            project_id,
            **kwargs
        ):
            """Augmentation list of all available transformations that are supported in the system.

            Augmentation list of all available transformations that are supported in the system.
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                ImageAugmentationOptionsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/imageAugmentationOptions/{projectId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationOptionsResponse(**server_data)

        @classmethod
        def image_augmentation_samples_create(
            cls,
            **kwargs
        ):
            """Requests the creation of sample augmentations based on the augmentation list passed in.

            This endpoint will schedule a job to augment the specified images from a project's dataset and return a link to monitor the status of the job, as well as a link to retrieve the resulting augmented images.

            Keyword Args:
                image_augmentation_samples_request (ImageAugmentationSamplesRequest): [optional]
            Returns:
                ImageAugmentationSamplesResponse
            """
            path_args = {}
            path = '/api/v2/imageAugmentationSamples/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationSamplesResponse(**server_data)

        @classmethod
        def image_augmentation_samples_retrieve(
            cls,
            samples_id,
            **kwargs
        ):
            """Retrieve previously generated Augmentation Samples

            Retrieve previously generated Augmentation Samples
            Args:
                samples_id (str): Id of the augmentation sample

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                ImageAugmentationRetrieveSamplesResponse
            """
            path_args = {}
            kwargs['samples_id'] = samples_id
            path_args['samplesId'] = samples_id
            path = '/api/v2/imageAugmentationSamples/{samplesId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageAugmentationRetrieveSamplesResponse(**server_data)

