#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.activation_maps_compute_response import ActivationMapsComputeResponse
from datarobot.models.full_api.generated.model.activation_maps_list_response import ActivationMapsListResponse
from datarobot.models.full_api.generated.model.activation_maps_retrieve_response import ActivationMapsRetrieveResponse
from datarobot.models.full_api.generated.model.embeddings_list_response import EmbeddingsListResponse
from datarobot.models.full_api.generated.model.embeddings_retrieve_response import EmbeddingsRetrieveResponse
from datarobot.models.full_api.generated.model.image_embeddings_compute_response import ImageEmbeddingsComputeResponse


class ImageInsightsApi(APIObject):

        @classmethod
        def projects_image_activation_maps_list(
            cls,
            project_id,
            **kwargs
        ):
            """List all Image Activation Maps for the project.

            List all Image Activation Maps for the project.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): The number of items to skip over.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of items to return.. [optional] if omitted the server will use the default value of 100
            Returns:
                ActivationMapsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imageActivationMaps/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ActivationMapsListResponse(**server_data)

        @classmethod
        def projects_image_embeddings_list(
            cls,
            project_id,
            **kwargs
        ):
            """List all Image Embeddings for the project.

            List all Image Embeddings for the project.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): The number of items to skip over.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of items to return.. [optional] if omitted the server will use the default value of 100
            Returns:
                EmbeddingsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imageEmbeddings/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return EmbeddingsListResponse(**server_data)

        @classmethod
        def projects_models_image_activation_maps_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Request the computation of image activation maps for the specified model.

            Request the computation of image activation maps for the specified model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ActivationMapsComputeResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/imageActivationMaps/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ActivationMapsComputeResponse(**server_data)

        @classmethod
        def projects_models_image_activation_maps_list(
            cls,
            feature_name,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Image Activation Maps for a feature of a model.

            Retrieve Image Activation Maps for a feature of a model. Image Activation maps are a technique to get the discriminative image regions used by a CNN to identify a specific class in the image. In other words, an image activation map lets us see which regions in the image were relevant to this class.  The higher the value in the activation map the greater the effect the region had on the prediction.
            Args:
                feature_name (str): Name of the feature to query
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ActivationMapsRetrieveResponse
            """
            path_args = {}
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/imageActivationMaps/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ActivationMapsRetrieveResponse(**server_data)

        @classmethod
        def projects_models_image_embeddings_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Request the computation of image embeddings for the specified model.

            Request the computation of image embeddings for the specified model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ImageEmbeddingsComputeResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/imageEmbeddings/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageEmbeddingsComputeResponse(**server_data)

        @classmethod
        def projects_models_image_embeddings_list(
            cls,
            feature_name,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve ImageEmbeddings for a feature of a model.

            Retrieve ImageEmbeddings for a feature of a model.
            Args:
                feature_name (str): Name of the feature to query
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                EmbeddingsRetrieveResponse
            """
            path_args = {}
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/imageEmbeddings/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return EmbeddingsRetrieveResponse(**server_data)

