#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.duplicate_image_table_response import DuplicateImageTableResponse
from datarobot.models.full_api.generated.model.image_bins_list_response import ImageBinsListResponse
from datarobot.models.full_api.generated.model.image_metadata_list_response import ImageMetadataListResponse
from datarobot.models.full_api.generated.model.image_metadata_response import ImageMetadataResponse
from datarobot.models.full_api.generated.model.images_data_quality_log_lines_response import ImagesDataQualityLogLinesResponse


class ImagesApi(APIObject):

        @classmethod
        def datasets_images_data_quality_log_file_list(
            cls,
            dataset_id,
            **kwargs
        ):
            """Retrieve a text file containing the images data quality log.

            Retrieve a text file containing the images data quality log.
            Args:
                dataset_id (str): The ID of the dataset

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/imagesDataQualityLog/file/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def datasets_images_data_quality_log_list(
            cls,
            dataset_id,
            **kwargs
        ):
            """Retrieve the images data quality log content and log length as JSON

            Retrieve the images data quality log content and log length as JSON
            Args:
                dataset_id (str): The ID of the dataset

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                ImagesDataQualityLogLinesResponse
            """
            path_args = {}
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/datasets/{datasetId}/imagesDataQualityLog/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImagesDataQualityLogLinesResponse(**server_data)

        @classmethod
        def projects_duplicate_images_retrieve(
            cls,
            project_id,
            column,
            **kwargs
        ):
            """Get a list of duplicate images containing the number of occurrences of each image

            Get a list of duplicate images containing the number of occurrences of each image
            Args:
                project_id (str): The project ID
                column (str): Column parameter to filter the list of duplicate images returned

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                DuplicateImageTableResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['column'] = column
            path_args['column'] = column
            path = '/api/v2/projects/{projectId}/duplicateImages/{column}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DuplicateImageTableResponse(**server_data)

        @classmethod
        def projects_image_bins_list(
            cls,
            feature_name,
            project_id,
            **kwargs
        ):
            """List image bins and covers for every target value or range.

            List image bins and covers for every target value or range.
            Args:
                feature_name (str): Name of the image feature
                project_id (str): The project ID

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                ImageBinsListResponse
            """
            path_args = {}
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imageBins/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageBinsListResponse(**server_data)

        @classmethod
        def projects_image_samples_list(
            cls,
            feature_name,
            project_id,
            **kwargs
        ):
            """List all metadata for images in the EDA sample

            List all metadata for images in the EDA sample
            Args:
                feature_name (str): Name of the image feature
                project_id (str): The project ID

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                ImageMetadataListResponse
            """
            path_args = {}
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imageSamples/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageMetadataListResponse(**server_data)

        @classmethod
        def projects_images_data_quality_log_file_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve a text file containing the images data quality log

            Retrieve a text file containing the images data quality log
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imagesDataQualityLog/file/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_images_data_quality_log_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve the images data quality log content and log length as JSON

            Retrieve the images data quality log content and log length as JSON
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                ImagesDataQualityLogLinesResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/imagesDataQualityLog/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImagesDataQualityLogLinesResponse(**server_data)

        @classmethod
        def projects_images_file_list(
            cls,
            project_id,
            image_id,
            **kwargs
        ):
            """Returns a file for a single image

            Returns a file for a single image
            Args:
                project_id (str): The project ID
                image_id (str): Id of the image

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['image_id'] = image_id
            path_args['imageId'] = image_id
            path = '/api/v2/projects/{projectId}/images/{imageId}/file/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_images_list(
            cls,
            project_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """Returns a list of image metadata elements.

            Returns a list of image metadata elements.
            Args:
                project_id (str): The project ID
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 100, must be one of [100]

            Keyword Args:
                column (str): Name of the column to query. [optional]
                target_value (bool, date, datetime, dict, float, int, list, str, none_type): For classification projects - when specified, only images corresponding to this target value will be returned. Mutually exclusive with targetBinStart/targetBinEnd.. [optional]
                target_bin_start (bool, date, datetime, dict, float, int, list, str, none_type): For regression projects - when specified, only images corresponding to the target values above this will be returned. Mutually exclusive with targetValue. Must be specified with targetBinEnd.. [optional]
                target_bin_end (bool, date, datetime, dict, float, int, list, str, none_type): For regression projects - when specified, only images corresponding to the target values below this will be returned. Mutually exclusive with targetValue. Must be specified with targetBinStart.. [optional]
            Returns:
                ImageMetadataListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/images/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageMetadataListResponse(**server_data)

        @classmethod
        def projects_images_retrieve(
            cls,
            project_id,
            image_id,
            **kwargs
        ):
            """Returns a single image metadata.

            Returns a single image metadata.
            Args:
                project_id (str): The project ID
                image_id (str): Id of the image

            Keyword Args:
            Returns:
                ImageMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['image_id'] = image_id
            path_args['imageId'] = image_id
            path = '/api/v2/projects/{projectId}/images/{imageId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImageMetadataResponse(**server_data)

