#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.cluster_license_retrieve_response import ClusterLicenseRetrieveResponse
from datarobot.models.full_api.generated.model.cluster_license_update import ClusterLicenseUpdate
from datarobot.models.full_api.generated.model.cluster_license_validation_response import ClusterLicenseValidationResponse
from datarobot.models.full_api.generated.model.version_retrieve_response import VersionRetrieveResponse


class InfrastructureApi(APIObject):

        @classmethod
        def cluster_license_list(
            cls,
            **kwargs
        ):
            """Retrieve the information about cluster license

            Retrieve the information about the currently deployed cluster license.

            Keyword Args:
            Returns:
                ClusterLicenseRetrieveResponse
            """
            path_args = {}
            path = '/api/v2/clusterLicense/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ClusterLicenseRetrieveResponse(**server_data)

        @classmethod
        def cluster_license_put_many(
            cls,
            **kwargs
        ):
            """Create or replace license

            Create or replace the cluster license.

            Keyword Args:
                cluster_license_update (ClusterLicenseUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/clusterLicense/'.format(**path_args)
            cls._client.put(path, data=kwargs)

        @classmethod
        def cluster_license_validation_create(
            cls,
            **kwargs
        ):
            """Check if a license is valid

            Check if a cluster license is valid.

            Keyword Args:
                cluster_license_update (ClusterLicenseUpdate): [optional]
            Returns:
                ClusterLicenseValidationResponse
            """
            path_args = {}
            path = '/api/v2/clusterLicenseValidation/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ClusterLicenseValidationResponse(**server_data)

        @classmethod
        def version_list(
            cls,
            **kwargs
        ):
            """Retrieve version information.

            Provides the version information for the current version of the API.

            Keyword Args:
            Returns:
                VersionRetrieveResponse
            """
            path_args = {}
            path = '/api/v2/version/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return VersionRetrieveResponse(**server_data)

