#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.aot_chart_metadata_response import AOTChartMetadataResponse
from datarobot.models.full_api.generated.model.aot_chart_preview_response import AOTChartPreviewResponse
from datarobot.models.full_api.generated.model.aot_chart_retrieve_response import AOTChartRetrieveResponse
from datarobot.models.full_api.generated.model.anomaly_assessment_explanations_response import AnomalyAssessmentExplanationsResponse
from datarobot.models.full_api.generated.model.anomaly_assessment_initialize import AnomalyAssessmentInitialize
from datarobot.models.full_api.generated.model.anomaly_assessment_preview_response import AnomalyAssessmentPreviewResponse
from datarobot.models.full_api.generated.model.anomaly_assessment_records_response import AnomalyAssessmentRecordsResponse
from datarobot.models.full_api.generated.model.bias_vs_accuracy_insight_retrieve import BiasVsAccuracyInsightRetrieve
from datarobot.models.full_api.generated.model.confusion_chart_for_datasets_list_response import ConfusionChartForDatasetsListResponse
from datarobot.models.full_api.generated.model.confusion_chart_retrieve_for_datasets import ConfusionChartRetrieveForDatasets
from datarobot.models.full_api.generated.model.confusion_chart_retrieve_metadata_for_datasets import ConfusionChartRetrieveMetadataForDatasets
from datarobot.models.full_api.generated.model.cross_class_accuracy_create_response import CrossClassAccuracyCreateResponse
from datarobot.models.full_api.generated.model.cross_class_accuracy_list import CrossClassAccuracyList
from datarobot.models.full_api.generated.model.data_disparity_create_payload import DataDisparityCreatePayload
from datarobot.models.full_api.generated.model.data_disparity_create_response import DataDisparityCreateResponse
from datarobot.models.full_api.generated.model.data_disparity_retrieve_response import DataDisparityRetrieveResponse
from datarobot.models.full_api.generated.model.external_scores_create import ExternalScoresCreate
from datarobot.models.full_api.generated.model.external_scores_list_response import ExternalScoresListResponse
from datarobot.models.full_api.generated.model.fairness_insights_list_response import FairnessInsightsListResponse
from datarobot.models.full_api.generated.model.fairness_insights_start_calculation_payload import FairnessInsightsStartCalculationPayload
from datarobot.models.full_api.generated.model.fairness_insights_start_calculation_response import FairnessInsightsStartCalculationResponse
from datarobot.models.full_api.generated.model.feature_association_create_payload import FeatureAssociationCreatePayload
from datarobot.models.full_api.generated.model.feature_association_details_retrieve_controller_response import FeatureAssociationDetailsRetrieveControllerResponse
from datarobot.models.full_api.generated.model.feature_association_list_controller_response import FeatureAssociationListControllerResponse
from datarobot.models.full_api.generated.model.feature_association_retrieve_controller_response import FeatureAssociationRetrieveControllerResponse
from datarobot.models.full_api.generated.model.feature_effect_create import FeatureEffectCreate
from datarobot.models.full_api.generated.model.feature_effects_create_datetime import FeatureEffectsCreateDatetime
from datarobot.models.full_api.generated.model.feature_effects_datetime_response import FeatureEffectsDatetimeResponse
from datarobot.models.full_api.generated.model.feature_effects_response import FeatureEffectsResponse
from datarobot.models.full_api.generated.model.feature_fit_datetime_response import FeatureFitDatetimeResponse
from datarobot.models.full_api.generated.model.feature_fit_response import FeatureFitResponse
from datarobot.models.full_api.generated.model.feature_impact_create_payload import FeatureImpactCreatePayload
from datarobot.models.full_api.generated.model.feature_impact_response import FeatureImpactResponse
from datarobot.models.full_api.generated.model.frequent_values_response import FrequentValuesResponse
from datarobot.models.full_api.generated.model.lift_chart_for_datasets_list import LiftChartForDatasetsList
from datarobot.models.full_api.generated.model.model_confusion_chart_class_details_for_dataset_retrieve import ModelConfusionChartClassDetailsForDatasetRetrieve
from datarobot.models.full_api.generated.model.model_xray_create_datetime import ModelXrayCreateDatetime
from datarobot.models.full_api.generated.model.model_xray_metadata_datetime_response import ModelXrayMetadataDatetimeResponse
from datarobot.models.full_api.generated.model.model_xray_metadata_response import ModelXrayMetadataResponse
from datarobot.models.full_api.generated.model.multiclass_feature_impact_response import MulticlassFeatureImpactResponse
from datarobot.models.full_api.generated.model.multiclass_lift_chart_for_datasets_list import MulticlassLiftChartForDatasetsList
from datarobot.models.full_api.generated.model.payoff_matrices_create import PayoffMatricesCreate
from datarobot.models.full_api.generated.model.payoff_matrices_list_response import PayoffMatricesListResponse
from datarobot.models.full_api.generated.model.payoff_matrices_response import PayoffMatricesResponse
from datarobot.models.full_api.generated.model.prediction_explanations_create import PredictionExplanationsCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_create import PredictionExplanationsInitializationCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_retrieve import PredictionExplanationsInitializationRetrieve
from datarobot.models.full_api.generated.model.prediction_explanations_record import PredictionExplanationsRecord
from datarobot.models.full_api.generated.model.prediction_explanations_record_list import PredictionExplanationsRecordList
from datarobot.models.full_api.generated.model.prediction_explanations_retrieve import PredictionExplanationsRetrieve
from datarobot.models.full_api.generated.model.residuals_chart_for_datasets_list import ResidualsChartForDatasetsList
from datarobot.models.full_api.generated.model.roc_curve_for_datasets_list import RocCurveForDatasetsList
from datarobot.models.full_api.generated.model.shap_impact_retrieve_response import ShapImpactRetrieveResponse


class InsightsApi(APIObject):

        @classmethod
        def projects_anomaly_assessment_records_delete(
            cls,
            project_id,
            record_id,
            **kwargs
        ):
            """Delete the anomaly assessment record.

            Delete the anomaly assessment record.
            Args:
                project_id (str): The project ID
                record_id (str): The anomaly assessment record ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['record_id'] = record_id
            path_args['recordId'] = record_id
            path = '/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_anomaly_assessment_records_explanations_list(
            cls,
            project_id,
            record_id,
            **kwargs
        ):
            """Retrieve anomaly assessment record.

            Retrieve anomaly assessment record. Two out of three parameters: `startDate`, `endDate` or `pointsCount` must be specified.
            Args:
                project_id (str): The project ID
                record_id (str): The anomaly assessment record ID

            Keyword Args:
                start_date (datetime): The start of the date range to return. Date should be in UTC format. For example: ``2019-08-01T00:00:00.000000Z``.. [optional]
                end_date (datetime): The end of the date range to return, inclusive. Date should be in UTC format. For example: ``2020-01-01T00:00:00.000000Z``.. [optional]
                points_count (int): Count of points to return.. [optional]
            Returns:
                AnomalyAssessmentExplanationsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['record_id'] = record_id
            path_args['recordId'] = record_id
            path = '/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/explanations/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyAssessmentExplanationsResponse(**server_data)

        @classmethod
        def projects_anomaly_assessment_records_list(
            cls,
            project_id,
            **kwargs
        ):
            """Retrieve anomaly assessment records.

            Retrieve anomaly assessment records.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                model_id (str): The model ID to filter records by.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): The backtest to filter records by.. [optional]
                source (str): The source of the data to filter records by.. [optional]
                series_id (str): Can be specified for multiseries projects. The series id to filter records by.. [optional]
            Returns:
                AnomalyAssessmentRecordsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/anomalyAssessmentRecords/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyAssessmentRecordsResponse(**server_data)

        @classmethod
        def projects_anomaly_assessment_records_predictions_preview_list(
            cls,
            project_id,
            record_id,
            **kwargs
        ):
            """Retrieve predictions preview for the anomaly assessment record.

            Retrieve predictions preview for the anomaly assessment record.
            Args:
                project_id (str): The project ID
                record_id (str): The anomaly assessment record ID

            Keyword Args:
            Returns:
                AnomalyAssessmentPreviewResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['record_id'] = record_id
            path_args['recordId'] = record_id
            path = '/api/v2/projects/{projectId}/anomalyAssessmentRecords/{recordId}/predictionsPreview/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyAssessmentPreviewResponse(**server_data)

        @classmethod
        def projects_bias_vs_accuracy_insights_list(
            cls,
            project_id,
            **kwargs
        ):
            """List Bias vs Accuracy insights.

            Retrieve a list of Bias vs Accuracy insights for the model.
            Args:
                project_id (str): The project ID

            Keyword Args:
                accuracy_metric (str): The metric to return model accuracy scores. Defaults to the optimization metric configured in project options.. [optional]
                protected_feature (bool, date, datetime, dict, float, int, list, str, none_type): Name of the protected feature.. [optional]
                fairness_metric (bool, date, datetime, dict, float, int, list, str, none_type): The fairness metric used to calculate the fairness scores.. [optional]
            Returns:
                BiasVsAccuracyInsightRetrieve
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/biasVsAccuracyInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BiasVsAccuracyInsightRetrieve(**server_data)

        @classmethod
        def projects_datetime_models_dataset_accuracy_over_time_plots_metadata_list(
            cls,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Retrieve the metadata of the Accuracy Over Time (AOT) chart for an external dataset.

            Retrieve the metadata of the Accuracy Over Time (AOT) chart for an external dataset. Datetimes are specified in accordance with :ref:`timestamp and duration formatting rules <time_format>`.
            Args:
                project_id (str): The project id which was used to compute the AOT chart.
                model_id (str): The model id which was used to compute the AOT chart.
                dataset_id (str): The dataset id which was used to compute the AOT chart.

            Keyword Args:
            Returns:
                AOTChartMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AOTChartMetadataResponse(**server_data)

        @classmethod
        def projects_datetime_models_dataset_accuracy_over_time_plots_preview_list(
            cls,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Retrieve a preview of the Accuracy Over Time (AOT) chart for an external dataset.

            Retrieve a preview of the Accuracy Over Time (AOT) chart for an external dataset. Datetimes are specified in accordance with :ref:`timestamp and duration formatting rules <time_format>`.
            Args:
                project_id (str): The project id which was used to compute the AOT chart.
                model_id (str): The model id which was used to compute the AOT chart.
                dataset_id (str): The dataset id which was used to compute the AOT chart.

            Keyword Args:
            Returns:
                AOTChartPreviewResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/preview/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AOTChartPreviewResponse(**server_data)

        @classmethod
        def projects_datetime_models_dataset_accuracy_over_time_plots_retrieve(
            cls,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Retrieve the Accuracy Over Time (AOT) chart data for an external dataset for a project.

            Retrieve the Accuracy Over Time (AOT) chart data for an external dataset for a project. Datetimes are specified in accordance with :ref:`timestamp and duration formatting rules <time_format>`.
            Args:
                project_id (str): The project id which was used to compute the AOT chart.
                model_id (str): The model id which was used to compute the AOT chart.
                dataset_id (str): The dataset id which was used to compute the AOT chart.

            Keyword Args:
                max_bin_size (int): The limit of returned bins.. [optional] if omitted the server will use the default value of 500
                start_date (datetime): The start of the date range to return (UTC string), for example: '2010-05-13T00:00:00.000000Z'. If not specified, the start date for this model and source of the data will be used instead.. [optional]
                end_date (datetime): The end of the date range to return (UTC string), for example: '2010-05-13T00:00:00.000000Z'. If not specified, the end date for this model and source of the data will be used instead.. [optional]
                resolution (str): Specifies at which resolution the data should be binned. If not specified, optimal resolution will be used to build chart data such that bins <= `maxBinSize`.. [optional]
            Returns:
                AOTChartRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/datasetAccuracyOverTimePlots/{datasetId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AOTChartRetrieveResponse(**server_data)

        @classmethod
        def projects_datetime_models_feature_effects_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Add a request to the queue to calculate Feature Effects for a backtest.

            Add a request to the queue to calculate Feature Effects for a backtest. If the job has been previously submitted, the request fails, returning the `jobId` of the previously submitted job. Use this `jobId` to check status of the previously submitted job.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                feature_effects_create_datetime (FeatureEffectsCreateDatetime): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffects/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_datetime_models_feature_effects_list(
            cls,
            backtest_index,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Effects for a model backtest.

            Retrieve Feature Effects for a model backtest. Feature Effects provides partial dependence and predicted vs actual values for the top 500 features, ordered by feature impact score. The partial dependence shows marginal effect of a feature on the target variable after accounting for the average effects of all other predictive features. It indicates how, holding all other variables except the feature of interest as they were, the value of this feature affects your prediction. If a Feature Effects job was previously submitted for a given backtest, this endpoint will return a response structured as {\"message\": <message>, \"jobId\": <jobId>} where `jobId` is the ID of the job. Retrieve the job with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`
            Args:
                backtest_index (str): The backtest index. For example: `0`, `1`, ..., `20`, `holdout`, `startstop`.
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                source (str): Models data source.. [optional] if omitted the server will use the default value of "training"
            Returns:
                FeatureEffectsDatetimeResponse
            """
            path_args = {}
            kwargs['backtest_index'] = backtest_index
            path_args['backtestIndex'] = backtest_index
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffects/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureEffectsDatetimeResponse(**server_data)

        @classmethod
        def projects_datetime_models_feature_effects_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Effects metadata for each backtest. Response contains status and available sources for each backtest of the model.

            Retrieve Feature Effects metadata for each backtest. Response contains status and available sources for each backtest of the model. One of the provided `backtestIndex` indexes used for submitting the compute request and retrieving Feature Effects. * Start/stop models contain a single `backtestIndex` response value of `startstop`. * Other models contain `backtestIndex` of `0`, `1`, ..., `holdout`. One of the provided `source` parameters used for retrieving Feature Effects. * Each backtest source can be, at a minimum, `training` or `validation`. If holdout is configured for the project, `backtestIndex` also includes `holdout` with sources `training` and `holdout`. * Source value of `training` is always available. (versions prior to v2.17 support `validation` only) * When a start/stop model is trained into `validation` or `holdout` without stacked predictions (i.e., no out-of-sample predictions in `validation` or `holdout`), `validation` and `holdout` sources are not available. * Source `holdout` is not available when there is no holdout configured for the project.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelXrayMetadataDatetimeResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureEffectsMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelXrayMetadataDatetimeResponse(**server_data)

        @classmethod
        def projects_datetime_models_feature_fit_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Add a request to the queue to calculate Feature Fit for a backtest.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Add a request to the queue to calculate Feature Fit for a backtest. If the job has been previously submitted, the request fails, returning the `jobId` of the previously submitted job. Use this `jobId` to check status of the previously submitted job.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                model_xray_create_datetime (ModelXrayCreateDatetime): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFit/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_datetime_models_feature_fit_list(
            cls,
            backtest_index,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Fit for a model backtest.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Retrieve Feature Fit for a model backtest. Feature Fit provides partial dependence and predicted vs actual values for the top 500 features, ordered by feature importance score. The partial dependence shows marginal effect of a feature on the target variable after accounting for the average effects of all other predictive features. It indicates how, holding all other variables except the feature of interest as they were, the value of this feature affects your prediction. If a Feature Fit job was previously submitted for a given backtest, this endpoint will return a response structured as {\"message\": <message>, \"jobId\": <jobId>} where jobId is the ID of the job. Retrieve the job with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`
            Args:
                backtest_index (str): The backtest index. For example: `0`, `1`, ..., `20`, `holdout`, `startstop`.
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                source (str): Models data source.. [optional] if omitted the server will use the default value of "training"
            Returns:
                FeatureFitDatetimeResponse
            """
            path_args = {}
            kwargs['backtest_index'] = backtest_index
            path_args['backtestIndex'] = backtest_index
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFit/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureFitDatetimeResponse(**server_data)

        @classmethod
        def projects_datetime_models_feature_fit_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Fit metadata for each backtest. Response contains status and available sources for each backtest of the model.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Retrieve Feature Fit metadata for each backtest. Response contains status and available sources for each backtest of the model. One of the provided `backtestIndex` indexes used for submitting the compute request and retrieving Feature Fit. * Start/stop models contain a single `backtestIndex` response value of `startstop`. * Other models contain `backtestIndex` of `0`, `1`, ..., `holdout`. One of the provided `source` parameters used for retrieving Feature Fit. * Each backtest source can be, at a minimum, `training` or `validation`. If holdout is configured for the project, `backtestIndex` also includes `holdout` with sources `training` and `holdout`. * Source value of `training` is always available. (versions prior to v2.17 support `validation` only) * When a start/stop model is trained into `validation` or `holdout` without stacked predictions (i.e., no out-of-sample predictions in `validation` or `holdout`), `validation` and `holdout` sources are not available. * Source `holdout` is not available when there is no holdout configured for the project.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelXrayMetadataDatetimeResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/featureFitMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelXrayMetadataDatetimeResponse(**server_data)

        @classmethod
        def projects_external_scores_create(
            cls,
            project_id,
            **kwargs
        ):
            """Compute model scores for external dataset.

            Compute model scores for external dataset, first upload your dataset to the project, and then using the corresponding datasetId, compute scores against that dataset. Computing external scores and insights depends on computed prediction, predictions will be computed if they are not available for this dataset. In order to compute scores and insights, uploaded dataset should contain actual value column. This api is not available in time series projects.
            Args:
                project_id (str): The project ID

            Keyword Args:
                external_scores_create (ExternalScoresCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/externalScores/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_external_scores_list(
            cls,
            project_id,
            **kwargs
        ):
            """List of scores on prediction datasets for a project.

            List of scores on prediction datasets for a project with filtering option by dataset or model or both of them. Prediction dataset may have scores if it contained a column with actual values and predictions were computed on this dataset.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                dataset_id (str): If provided will return scores for dataset with matching datasetId.. [optional]
                model_id (str): If provided will return scores for model with matching modelId.. [optional]
            Returns:
                ExternalScoresListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/externalScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ExternalScoresListResponse(**server_data)

        @classmethod
        def projects_feature_association_featurelists_list(
            cls,
            project_id,
            **kwargs
        ):
            """List all featurelists with feature association matrix availability flags for a project.

            List all featurelists with feature association matrix availability flags for a project.
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                FeatureAssociationListControllerResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureAssociationFeaturelists/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureAssociationListControllerResponse(**server_data)

        @classmethod
        def projects_feature_association_matrix_create(
            cls,
            project_id,
            **kwargs
        ):
            """Compute feature association matrix.

            Compute feature association matrix for given featurelist.
            Args:
                project_id (str): The project ID

            Keyword Args:
                feature_association_create_payload (FeatureAssociationCreatePayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureAssociationMatrix/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_feature_association_matrix_details_list(
            cls,
            feature1,
            feature2,
            project_id,
            **kwargs
        ):
            """Retrieval for feature association plotting between a pair of features.

            Retrieval for feature association plotting between a pair of features.         Projects created prior to v2.17 are not supported by this feature.
            Args:
                feature1 (str): The name of a feature.
                feature2 (str): the name of another feature.
                project_id (str): The project ID

            Keyword Args:
                featurelist_id (str): the feature list to lookup FAM data for. By default, depending on the type of the project `Informative Features` or `Timeseries Informative Features` list will be used.. [optional]
            Returns:
                FeatureAssociationDetailsRetrieveControllerResponse
            """
            path_args = {}
            kwargs['feature1'] = feature1
            path_args['feature1'] = feature1
            kwargs['feature2'] = feature2
            path_args['feature2'] = feature2
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureAssociationMatrixDetails/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureAssociationDetailsRetrieveControllerResponse(**server_data)

        @classmethod
        def projects_feature_association_matrix_list(
            cls,
            project_id,
            type="association",
            metric="mutualInfo",
            **kwargs
        ):
            """Retrieval for pairwise feature association statistics.

             Retrieval for pairwise feature association statistics.         Projects created prior to v2.17 are not supported by this feature.
            Args:
                project_id (str): The project ID
                type (str): the type of dependence for the data. Must be either `association` or `correlation`. Since v2.19 this is optional and defaults to `association`.. defaults to "association", must be one of ["association"]
                metric (str): the name of a metric to get pairwise data for. Must be one of `mutualInfo`, `cramersV`, `spearman`, `pearson`, or `tau`. Since v2.19 this is optional and defaults to `mutualInfo`.. defaults to "mutualInfo", must be one of ["mutualInfo"]

            Keyword Args:
                featurelist_id (str): the feature list to lookup FAM data for. By default, depending on the type of the project `Informative Features` or `Timeseries Informative Features` list will be used.. [optional]
            Returns:
                FeatureAssociationRetrieveControllerResponse
            """
            path_args = {}
            kwargs['type'] = type
            path_args['type'] = type
            kwargs['metric'] = metric
            path_args['metric'] = metric
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/featureAssociationMatrix/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureAssociationRetrieveControllerResponse(**server_data)

        @classmethod
        def projects_features_frequent_values_list(
            cls,
            project_id,
            feature_name,
            **kwargs
        ):
            """Retrieve the frequent values information for a particular feature.

            Retrieve the frequent values information for a particular feature.         Only valid for numeric features.         This route returns information about the frequent values seen for a particular feature,         based on the EDA sample of the dataset. Up to 60 values will be returned,         and when more values are present, they will be bucketed into a level called \"==All Other==\"         at the end of the response.
            Args:
                project_id (str): project id
                feature_name (str): name of the feature

            Keyword Args:
            Returns:
                FrequentValuesResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/projects/{projectId}/features/{featureName}/frequentValues/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FrequentValuesResponse(**server_data)

        @classmethod
        def projects_models_anomaly_assessment_initialization_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Calculate the anomaly assessment insight.

            Initialize the anomaly assessment insight and calculate Shapley explanations for the most anomalous points in the subset. The insight is available for anomaly detection models in time series unsupervised projects which also support calculation of Shapley values.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                anomaly_assessment_initialize (AnomalyAssessmentInitialize): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/anomalyAssessmentInitialization/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_cross_class_accuracy_scores_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start Cross Class Accuracy calculations.

            Submits a job to start Cross Class Accuracy scores calculations for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                CrossClassAccuracyCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyCreateResponse(**server_data)

        @classmethod
        def projects_models_cross_class_accuracy_scores_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List Cross Class Accuracy scores.

            Retrieves a list of Cross Class Accuracy scores for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                CrossClassAccuracyList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossClassAccuracyScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossClassAccuracyList(**server_data)

        @classmethod
        def projects_models_data_disparity_insights_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start insight calculations.

            Submits a job to start Cross Class Data Disparity insight calculations.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                data_disparity_create_payload (DataDisparityCreatePayload): [optional]
            Returns:
                DataDisparityCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityCreateResponse(**server_data)

        @classmethod
        def projects_models_data_disparity_insights_list(
            cls,
            feature,
            class_name1,
            class_name2,
            project_id,
            model_id,
            **kwargs
        ):
            """Get Cross Class Data Disparity results.

            Retrieve a list of Cross Class Data Disparity insights for the model.
            Args:
                feature (str): Feature for which insight is computed.
                class_name1 (str): One of the compared classes.
                class_name2 (str): Another compared class.
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
            Returns:
                DataDisparityRetrieveResponse
            """
            path_args = {}
            kwargs['feature'] = feature
            path_args['feature'] = feature
            kwargs['class_name1'] = class_name1
            path_args['className1'] = class_name1
            kwargs['class_name2'] = class_name2
            path_args['className2'] = class_name2
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/dataDisparityInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DataDisparityRetrieveResponse(**server_data)

        @classmethod
        def projects_models_dataset_confusion_charts_class_details_list(
            cls,
            class_name,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Calculate and sends frequency of class in distributed among other classes for actual and predicted data.

            Calculate and sends frequency of class in distributed among other classes for actual and predicted data. A confusion chart class details for given class gives stats of misclassification done by model for given class for actual and predicted data. Available for multiclass projects only.
            Args:
                class_name (str): Name of a class for which distribution frequency is requested.
                project_id (str): The project to retrieve a Confusion chart from.
                model_id (str): The model to retrieve a Confusion chart from.
                dataset_id (str): The dataset to retrieve a Confusion chart from.

            Keyword Args:
            Returns:
                ModelConfusionChartClassDetailsForDatasetRetrieve
            """
            path_args = {}
            kwargs['class_name'] = class_name
            path_args['className'] = class_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/classDetails/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelConfusionChartClassDetailsForDatasetRetrieve(**server_data)

        @classmethod
        def projects_models_dataset_confusion_charts_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List of Confusion Charts objects on external datasets for a project with filtering option by dataset.

            List of Confusion Charts objects on external datasets for a project with filtering option by dataset. Prediction dataset may have Confusion Chart for multiclass projects computed if it contained a target with actual values and insights were computed on this dataset. A confusion chart consists of the confusion matrix for all classes, classes frequencies and oneVsAll metrics for all classes. The confusion matrix can be requested in a particular sort order and orientated by rows or columns. Available for multiclass projects only.
            Args:
                project_id (str): The project to retrieve a Confusion chart from.
                model_id (str): The model to retrieve a Confusion chart from.

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                order_by (str): Ordering the chart data by following attributes.Prefix the attribute name with a dash to sort in descending order, e.g. orderBy='-predictedCount'. [optional] if omitted the server will use the default value of "className"
                orientation (str): Determines whether the values in the rows of the confusion matrix should correspond to the same actual class ('actual') or predicted class ('predicted').. [optional] if omitted the server will use the default value of "actual"
                row_start (int): start index of row for slicing the confusion matrix.. [optional]
                row_end (int): end index of row for slicing the confusion matrix.. [optional]
                col_start (int): start index of column for slicing the confusion matrix.. [optional]
                col_end (int): end index of column for slicing the confusion matrix.. [optional]
                dataset_id (str): The datasetId to retrieve a Confusion chart from.. [optional]
            Returns:
                ConfusionChartForDatasetsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ConfusionChartForDatasetsListResponse(**server_data)

        @classmethod
        def projects_models_dataset_confusion_charts_metadata_list(
            cls,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Retrieve metadata for the confusion chart of a model on external dataset for a project.

            Retrieve metadata for the confusion chart of a model on external dataset for a project. Available for multiclass projects only.
            Args:
                project_id (str): The project to retrieve a Confusion chart from.
                model_id (str): The model to retrieve a Confusion chart from.
                dataset_id (str): The dataset to retrieve a Confusion chart from.

            Keyword Args:
                order_by (str): Ordering the chart data by following attributes.Prefix the attribute name with a dash to sort in descending order, e.g. orderBy='-predictedCount'. [optional] if omitted the server will use the default value of "className"
                orientation (str): Determines whether the values in the rows of the confusion matrix should correspond to the same actual class ('actual') or predicted class ('predicted').. [optional] if omitted the server will use the default value of "actual"
                thumbnail_cell_size (int): Number of classes in a single 'thumbnail' cell.. [optional] if omitted the server will use the default value of 10
            Returns:
                ConfusionChartRetrieveMetadataForDatasets
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ConfusionChartRetrieveMetadataForDatasets(**server_data)

        @classmethod
        def projects_models_dataset_confusion_charts_retrieve(
            cls,
            project_id,
            model_id,
            dataset_id,
            **kwargs
        ):
            """Retrieve Confusion Chart objects on external datasets for a project.

            Retrieve Confusion Chart objects on external datasets for a project. Prediction dataset may have Confusion Chart for multiclass projects computed if it contained a target with actual values and insights were computed on this dataset. A confusion chart consists of the confusion matrix for all classes, classes frequencies and oneVsAll metrics for all classes. The confusion matrix can be requested in a particular sort order and oriented by rows or columns (zero-indexed). Available for multiclass projects only.
            Args:
                project_id (str): The project to retrieve a Confusion chart from.
                model_id (str): The model to retrieve a Confusion chart from.
                dataset_id (str): The dataset to retrieve a Confusion chart from.

            Keyword Args:
                order_by (str): Ordering the chart data by following attributes.Prefix the attribute name with a dash to sort in descending order, e.g. orderBy='-predictedCount'. [optional] if omitted the server will use the default value of "className"
                orientation (str): Determines whether the values in the rows of the confusion matrix should correspond to the same actual class ('actual') or predicted class ('predicted').. [optional] if omitted the server will use the default value of "actual"
                row_start (int): start index of row for slicing the confusion matrix.. [optional]
                row_end (int): end index of row for slicing the confusion matrix.. [optional]
                col_start (int): start index of column for slicing the confusion matrix.. [optional]
                col_end (int): end index of column for slicing the confusion matrix.. [optional]
            Returns:
                ConfusionChartRetrieveForDatasets
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetConfusionCharts/{datasetId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ConfusionChartRetrieveForDatasets(**server_data)

        @classmethod
        def projects_models_dataset_lift_charts_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve List of Lift chart data on prediction datasets for a project.

            List of Lift chart objects on prediction datasets for a project with filtering option by dataset. Prediction dataset may have Lift chart computed if it contained a column with actual values and predictions were computed on this dataset. This controller is not supported for multiclass classification projects. For multiclass, instead use /projects/<projectId>/models/<modelId>/datasetMulticlassLiftCharts/.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                dataset_id (str): If provided will return Lift chart for dataset with matching datasetId.. [optional]
            Returns:
                LiftChartForDatasetsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetLiftCharts/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return LiftChartForDatasetsList(**server_data)

        @classmethod
        def projects_models_dataset_multiclass_lift_charts_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve List of Multiclass Lift chart data on prediction datasets for a project.

            List of Multiclass Lift chart objects on prediction datasets for a project with filtering option by dataset. Prediction dataset may have Multiclass Lift chart computed if it contained a column with actual values and predictions were computed on this dataset. Multiclass Lift charts are supported for multiclass classification projects only.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                dataset_id (str): If provided will return Lift chart for dataset with matching datasetId.. [optional]
            Returns:
                MulticlassLiftChartForDatasetsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetMulticlassLiftCharts/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return MulticlassLiftChartForDatasetsList(**server_data)

        @classmethod
        def projects_models_dataset_residuals_charts_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List of residuals charts objects on prediction datasets.

            List of residuals charts objects on prediction datasets for a project with filtering option by dataset. Prediction dataset may have residuals chart computed if it contained a column with actual values and predictions were computed on this dataset. Residuals charts are supported for regression projects only.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                dataset_id (str): If provided will return ROC curve for dataset with matching `datasetId`.. [optional]
            Returns:
                ResidualsChartForDatasetsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetResidualsCharts/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ResidualsChartForDatasetsList(**server_data)

        @classmethod
        def projects_models_dataset_roc_curves_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List of ROC curve objects on prediction datasets for a project with filtering option by dataset.

            List of ROC curve objects on prediction datasets for a project with filtering option by dataset.  Prediction dataset may have ROC curve computed if it contained a column with actual values and predictions were computed on this dataset. Each ROC curve object includes an array of points showing the performance of the model at different thresholds for classification, and arrays of sample predictions for both the positive and negative classes.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                dataset_id (str): If provided will return ROC curve for dataset with matching `datasetId`.. [optional]
            Returns:
                RocCurveForDatasetsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/datasetRocCurves/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RocCurveForDatasetsList(**server_data)

        @classmethod
        def projects_models_fairness_insights_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Start insight calculations.

            Submits a job to start Per Class Bias insight calculations for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                fairness_insights_start_calculation_payload (FairnessInsightsStartCalculationPayload): [optional]
            Returns:
                FairnessInsightsStartCalculationResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FairnessInsightsStartCalculationResponse(**server_data)

        @classmethod
        def projects_models_fairness_insights_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List calculated Per Class Bias insights.

            Retrieve a list of Per Class Bias insights for the model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                offset (int): Number of items to skip. Defaults to 0 if not provided.. [optional] if omitted the server will use the default value of 0
                limit (int): Number of items to return, defaults to 100 if not provided.. [optional] if omitted the server will use the default value of 100
                fairness_metrics_set (str): The fairness metric used to calculate the fairness scores.. [optional]
            Returns:
                FairnessInsightsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/fairnessInsights/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FairnessInsightsListResponse(**server_data)

        @classmethod
        def projects_models_feature_effects_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Add a request to the queue to calculate Feature Effects.

            Add a request to the queue to calculate Feature Effects. If the job has been previously submitted, the request fails, returning the `jobId` of the previously submitted job. Use this `jobId` to check status of the previously submitted job.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                feature_effect_create (FeatureEffectCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureEffects/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_feature_effects_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Effects for the model.

            Retrieve Feature Effects for the model. Feature Effects provides partial dependence and predicted vs actual values for the top 500 features, ordered by feature impact score. The partial dependence shows marginal effect of a feature on the target variable after accounting for the average effects of all other predictive features. It indicates how, holding all other variables except the feature of interest as they were, the value of this feature affects your prediction. If a Feature Effects job was previously submitted, this endpoint will return a response structured as {\"message\": <message>, \"jobId\": <jobId>} where jobId is the ID of the job. Retrieve the job with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                source (str): Models data source.. [optional] if omitted the server will use the default value of "training"
            Returns:
                FeatureEffectsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureEffects/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureEffectsResponse(**server_data)

        @classmethod
        def projects_models_feature_effects_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Effects metadata. Response contains status and available sources.

            Retrieve Feature Effects metadata. Response contains status and available sources. One of the provided `source` parameters used for retrieving Feature Effects. * Source can be, at a minimum, `training` or `validation`. If holdout is configured for the project, `source` also includes `holdout`. * Source value of `training` is always available. (versions prior to v2.17 support `validation` only) * When a model is trained into `validation` or `holdout` without stacked predictions (i.e., no out-of-sample predictions in `validation` or `holdout`), `validation` and `holdout` sources are not available.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelXrayMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureEffectsMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelXrayMetadataResponse(**server_data)

        @classmethod
        def projects_models_feature_fit_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Add a request to the queue to calculate Feature Fit.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Add a request to the queue to calculate Feature Fit. If the job has been previously submitted, the request fails, returning the `jobId` of the previously submitted job. Use this `jobId` to check status of the previously submitted job.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureFit/'.format(**path_args)
            cls._client.post(path)

        @classmethod
        def projects_models_feature_fit_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Fit for the model.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Retrieve Feature Fit for the model. Feature Fit provides partial dependence and predicted vs actual values for the top 500 features, ordered by feature importance score. The partial dependence shows marginal effect of a feature on the target variable after accounting for the average effects of all other predictive features. It indicates how, holding all other variables except the feature of interest as they were, the value of this feature affects your prediction. If a Feature Fit job was previously submitted, this endpoint will return a response structured as {\"message\": <message>, \"jobId\": <jobId>} where jobId is the ID of the job. Retrieve the job with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                source (str): Models data source.. [optional] if omitted the server will use the default value of "training"
            Returns:
                FeatureFitResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureFit/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureFitResponse(**server_data)

        @classmethod
        def projects_models_feature_fit_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Fit metadata. Response contains status and available sources.

            NOTE: Starting from API v2.29 this endpoint will be deprecated. Retrieve Feature Fit metadata. Response contains status and available sources. One of the provided `source` parameters used for retrieving Feature Fit. * Source can be, at a minimum, `training` or `validation`. If holdout is configured for the project, `source` also includes `holdout`. * Source value of `training` is always available.(versions prior to v2.17 support `validation` only) * When a model is trained into `validation` or `holdout` without stacked predictions (i.e., no out-of-sample predictions in `validation` or `holdout`), `validation` and `holdout` sources are not available.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelXrayMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureFitMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelXrayMetadataResponse(**server_data)

        @classmethod
        def projects_models_feature_impact_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Add a request to calculate feature impact to the queue.

            Add a request to calculate feature impact to the queue. If the job has been previously submitted, the request  will fail and return the `jobId` of previously submitted job. This `jobId` can be used to check status of previously submitted job.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                feature_impact_create_payload (FeatureImpactCreatePayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureImpact/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_feature_impact_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve feature impact scores for features in a model.

            Retrieve feature impact scores for features in a model. Feature Impact is computed for each column by creating new data with that column randomly permuted (but the others left unchanged), and seeing how the error metric score for the predictions is affected. Elsewhere this technique is sometimes called 'Permutation Importance'. The `impactUnnormalized` is how much worse the error metric score is when making predictions on this modified data. The `impactNormalized` is normalized so that the largest value is 1. In both cases, larger values indicate more important features. If a feature is a redundant feature, i.e. once other features are considered it doesn't contribute much in addition, the `redundantWith` value is the name of feature that has the highest correlation with this feature. If a feature impact job was previously submitted, this endpoint will return a response structured like {{\"message\": <message>, \"jobId\": <jobId>}} where jobId is the ID of the job that can be retrieved with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                FeatureImpactResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/featureImpact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureImpactResponse(**server_data)

        @classmethod
        def projects_models_multiclass_feature_impact_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve feature impact scores for each class in a multiclass model.

            Retrieve feature impact scores for each class in a multiclass model. Feature Impact is computed for each column by creating new data with that column randomly permuted (but the others left unchanged), and seeing how the error metric score for the predictions is affected. Elsewhere this technique is sometimes called 'Permutation Importance'. The `impactUnnormalized` is how much worse the error metric score is when making predictions on this modified data. The `impactNormalized` is normalized so that the largest value is 1. In both cases, larger values indicate more important features. If a feature impact job was previously submitted, this endpoint will return a response structured like {\"message\": <message>, \"jobId\": <jobId>} where jobId is the ID of the job that can be retrieved with :http:get:`/api/v2/projects/(projectId)/jobs/(jobId)/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                MulticlassFeatureImpactResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/multiclassFeatureImpact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return MulticlassFeatureImpactResponse(**server_data)

        @classmethod
        def projects_models_prediction_explanations_initialization_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Create a new prediction explanations initialization.

            Create a new prediction explanations initialization. This is a necessary prerequisite for generating prediction explanations.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                prediction_explanations_initialization_create (PredictionExplanationsInitializationCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_prediction_explanations_initialization_delete_many(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Delete an existing PredictionExplanationsInitialization.

            Delete an existing PredictionExplanationsInitialization.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_models_prediction_explanations_initialization_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the current PredictionExplanationsInitialization.

            Retrieve the current PredictionExplanationsInitialization. A PredictionExplanationsInitialization is a pre-requisite for successfully computing prediction explanations using a particular model, and can be used to preview the prediction explanations that would be generated for a complete dataset.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                exclude_adjusted_predictions (str): Whether to include adjusted prediction in the PredictionExplanationsSample response.. [optional] if omitted the server will use the default value of "true"
                prediction_explanations_initialization_retrieve (PredictionExplanationsInitializationRetrieve): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_models_shap_impact_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Create a Shap based Feature Impact.

            Create a Shap based Feature Impact with a model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                feature_impact_create_payload (FeatureImpactCreatePayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/shapImpact/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_shap_impact_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Feature Impact for a model.

            Retrieve Feature Impact for a model. Shap impact is computed by calculating the shap values on a sample of training data and then taking the mean absolute value for each column. The larger value of impact indicate more important feature.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ShapImpactRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/shapImpact/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ShapImpactRetrieveResponse(**server_data)

        @classmethod
        def projects_payoff_matrices_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a payoff matrix.

            Create a payoff matrix associated with a project.
            Args:
                project_id (str): The project ID

            Keyword Args:
                payoff_matrices_create (PayoffMatricesCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/payoffMatrices/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_payoff_matrices_delete(
            cls,
            project_id,
            payoff_matrix_id,
            **kwargs
        ):
            """Delete a payoff matrix in a project.

            Delete a payoff matrix in a project.
            Args:
                project_id (str): The project ID
                payoff_matrix_id (str): ObjectId of the payoff matrix.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['payoff_matrix_id'] = payoff_matrix_id
            path_args['payoffMatrixId'] = payoff_matrix_id
            path = '/api/v2/projects/{projectId}/payoffMatrices/{payoffMatrixId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_payoff_matrices_list(
            cls,
            project_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List of all payoff matrices for a project.

            List of all payoff matrices for a project.
            Args:
                project_id (str): The project ID
                offset (int): Number of payoff matrices to skip.. defaults to 0, must be one of [0]
                limit (int): Number of payoff matrices to return.. defaults to 100, must be one of [100]

            Keyword Args:
            Returns:
                PayoffMatricesListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/payoffMatrices/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PayoffMatricesListResponse(**server_data)

        @classmethod
        def projects_payoff_matrices_put(
            cls,
            project_id,
            payoff_matrix_id,
            **kwargs
        ):
            """Update a payoff matrix.

            Update all fields in a payoff matrix, including values and label.
            Args:
                project_id (str): The project ID
                payoff_matrix_id (str): ObjectId of the payoff matrix.

            Keyword Args:
                payoff_matrices_create (PayoffMatricesCreate): [optional]
            Returns:
                PayoffMatricesResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['payoff_matrix_id'] = payoff_matrix_id
            path_args['payoffMatrixId'] = payoff_matrix_id
            path = '/api/v2/projects/{projectId}/payoffMatrices/{payoffMatrixId}/'.format(**path_args)
            server_data = (cls._client.put(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PayoffMatricesResponse(**server_data)

        @classmethod
        def projects_prediction_explanations_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new PredictionExplanations object (and its accompanying PredictionExplanationsRecord).

            Create a new PredictionExplanations object (and its accompanying PredictionExplanationsRecord). In order to successfully create PredictionExplanations for a particular model and dataset, you must first - Compute feature impact for the model via :http:post:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` - Compute a PredictionExplanationsInitialization for the model via :http:post:`/api/v2/projects/(projectId)/models/(modelId)/predictionExplanationsInitialization/` - Compute predictions for the model and dataset via :http:post:`/api/v2/projects/(projectId)/predictions/` `thresholdHigh` and `thresholdLow` are optional filters applied to speed up computation. When at least one is specified, only the selected outlier rows will have prediction explanations computed. Rows are considered to be outliers if their predicted value (in case of regression projects) or probability of being the positive class (in case of classification projects) isless than `thresholdLow` or greater than `thresholdHigh`. If neither is specified, prediction explanations will be computed for all rows.
            Args:
                project_id (str): The project ID

            Keyword Args:
                prediction_explanations_create (PredictionExplanationsCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionExplanations/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prediction_explanations_records_delete(
            cls,
            project_id,
            prediction_explanations_id,
            **kwargs
        ):
            """Delete saved Prediction Explanations.

            Delete saved Prediction Explanations. Deletes both the actual prediction explanations and the corresponding PredictionExplanationsRecord.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_prediction_explanations_records_list(
            cls,
            project_id,
            **kwargs
        ):
            """List PredictionExplanationsRecord objects for a project.

            List PredictionExplanationsRecord objects for a project. These contain metadata about the computed prediction explanations and the location at which the PredictionExplanations can be retrieved.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
                model_id (str): If specified, only prediction explanations records computed for this model will be returned.. [optional]
            Returns:
                PredictionExplanationsRecordList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionExplanationsRecordList(**server_data)

        @classmethod
        def projects_prediction_explanations_records_retrieve(
            cls,
            project_id,
            prediction_explanations_id,
            **kwargs
        ):
            """Retrieve a PredictionExplanationsRecord object.

            Retrieve a PredictionExplanationsRecord object. A PredictionExplanationsRecord contains metadata about the computed prediction explanations and the location at which the PredictionExplanations can be retrieved.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.

            Keyword Args:
                prediction_explanations_record (PredictionExplanationsRecord): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_prediction_explanations_retrieve(
            cls,
            project_id,
            prediction_explanations_id,
            limit=300000,
            **kwargs
        ):
            """Retrieve stored Prediction Explanations.

            Retrieve stored Prediction Explanations. Each PredictionExplanationsRow retrieved corresponds to a row of the prediction dataset, although some rows may not have had prediction explanations computed depending on the thresholds selected.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. defaults to 300000, must be one of [300000]

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                exclude_adjusted_predictions (str): Whether to include adjusted prediction in PredictionExplanationsRow response.. [optional] if omitted the server will use the default value of "true"
                prediction_explanations_retrieve (PredictionExplanationsRetrieve): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanations/{predictionExplanationsId}/'.format(**path_args)
            cls._client.get(path, data=kwargs)

