#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.geometry_feature_p_lot_create_payload import GeometryFeaturePLotCreatePayload
from datarobot.models.full_api.generated.model.geometry_feature_plot_retrieve_response import GeometryFeaturePlotRetrieveResponse


class LocationAiApi(APIObject):

        @classmethod
        def projects_geometry_feature_plots_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a map of one location feature

            Create a map of one location feature
            Args:
                project_id (str): Project Id. It is the project to select the location feature from.

            Keyword Args:
                geometry_feature_p_lot_create_payload (GeometryFeaturePLotCreatePayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/geometryFeaturePlots/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_geometry_feature_plots_retrieve(
            cls,
            project_id,
            feature_name,
            **kwargs
        ):
            """Retrieve a map of one location feature

            Retrieve a map of one location feature
            Args:
                project_id (str): Project Id. It is the project to select the feature from.
                feature_name (str): Name of location feature to plot on map. Must be supplied in order to determine which plot to retrieve.

            Keyword Args:
            Returns:
                GeometryFeaturePlotRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['feature_name'] = feature_name
            path_args['featureName'] = feature_name
            path = '/api/v2/projects/{projectId}/geometryFeaturePlots/{featureName}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return GeometryFeaturePlotRetrieveResponse(**server_data)

