#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.pps_image_metadata_response import PPSImageMetadataResponse


class MlopsApi(APIObject):

        @classmethod
        def mlops_portable_prediction_server_image_list(
            cls,
            **kwargs
        ):
            """Downloads the latest Portable Prediction Server (PPS) Docker image

            Fetches the latest Portable Prediction Server (PPS) Docker imageThe resulting image can be docker-loaded. Since the image can be quite large (14GB+) consider querying its metadata to check the image size in advance and content hash to verify the downloaded image afterwards. In some environments it can HTTP redirect to some other service (like S3 or GCP) using pre-signed URLs

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/mlops/portablePredictionServerImage/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def mlops_portable_prediction_server_image_metadata_list(
            cls,
            **kwargs
        ):
            """Fetches currently active PPS docker image metadata

            Fetches currently active PPS docker image metadata

            Keyword Args:
            Returns:
                PPSImageMetadataResponse
            """
            path_args = {}
            path = '/api/v2/mlops/portablePredictionServerImage/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PPSImageMetadataResponse(**server_data)

