#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.feature_list_response import FeatureListResponse
from datarobot.models.full_api.generated.model.model_package_create_from_learning_model import ModelPackageCreateFromLearningModel
from datarobot.models.full_api.generated.model.model_package_list_response import ModelPackageListResponse
from datarobot.models.full_api.generated.model.model_package_retrieve_response import ModelPackageRetrieveResponse
from datarobot.models.full_api.generated.model.sharing_list_v2_response import SharingListV2Response


class ModelPackagesApi(APIObject):

        @classmethod
        def model_packages_archive_create(
            cls,
            model_package_id,
            **kwargs
        ):
            """Archive a model package.

            Permanently archive a model package. It will no longer be able to be used in new deployments or replacement. It will not be accessible in the model package list api. It will only be accessible at the model package retrieve route for this model package.
            Args:
                model_package_id (str): ID of the model package.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['model_package_id'] = model_package_id
            path_args['modelPackageId'] = model_package_id
            path = '/api/v2/modelPackages/{modelPackageId}/archive/'.format(**path_args)
            cls._client.post(path)

        @classmethod
        def model_packages_features_list(
            cls,
            model_package_id,
            offset=0,
            limit=50,
            **kwargs
        ):
            """Retrieve feature list.

            Retrieve the feature list for given model package.
            Args:
                model_package_id (str): ID of the model package.
                offset (int): The number of features to skip, defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of features to return, defaults to 0.. defaults to 50, must be one of [50]

            Keyword Args:
                include_non_prediction_features (str): When True will return all raw features in the universe dataset associated with the deployment, and when False will return only those raw features used to make predictions on the deployment.. [optional] if omitted the server will use the default value of "false"
                for_segmented_analysis (str): When True, features returned will be filtered to those usable for segmented analysis.. [optional] if omitted the server will use the default value of "false"
                search (str): Case insensitive search against names of the deployment's features.. [optional]
                order_by (str): Sort order which will be applied to model package feature list. Prefix the attribute name with a dash to sort in descending order, e.g. \"-name\".. [optional]
            Returns:
                FeatureListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['model_package_id'] = model_package_id
            path_args['modelPackageId'] = model_package_id
            path = '/api/v2/modelPackages/{modelPackageId}/features/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FeatureListResponse(**server_data)

        @classmethod
        def model_packages_from_learning_model_create(
            cls,
            **kwargs
        ):
            """Create model package from DataRobot model.

            Create model package from DataRobot model.

            Keyword Args:
                model_package_create_from_learning_model (ModelPackageCreateFromLearningModel): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/modelPackages/fromLearningModel/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def model_packages_list(
            cls,
            **kwargs
        ):
            """List model packages

            Retrieve the list of model packages a user has access to.

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
                model_id (str): If specified, limit results to model packages for the model with the specified ID.. [optional]
                similar_to (str): Return model packages similar to a given model package ID. If used, will only return model packages that match `target.name`, `target.type`, `target.classNames` (for classification models), `modelKind.isTimeSeries`, and `modelKind.isMultiseries` of the specified model package.. [optional]
                for_challenger (bool): Can be used with similarTo to request similar model packages with the intent to use them as challenger models; for external model packages, instead of returning similar external model packages, similar DataRobot and Custom model packages will be retrieved.. [optional]
                search (str): Provide a term to search for in package name, model name, or description. [optional]
                prediction_threshold (float): Prediction threshold used for binary classification models. [optional]
                imported (bool): If specified, filter for either imported (true) or non-imported (false) model packages. [optional]
                prediction_environment_id (str): Can be used to filter packages by what is supported by the prediction environment. [optional]
                model_kind (bool, date, datetime, dict, float, int, list, str, none_type): Return models from the registry that match a specific format.. [optional]
            Returns:
                ModelPackageListResponse
            """
            path_args = {}
            path = '/api/v2/modelPackages/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelPackageListResponse(**server_data)

        @classmethod
        def model_packages_retrieve(
            cls,
            model_package_id,
            **kwargs
        ):
            """Retrieve info about a model package.

            Retrieve info about a model package.
            Args:
                model_package_id (str): ID of the model package.

            Keyword Args:
            Returns:
                ModelPackageRetrieveResponse
            """
            path_args = {}
            kwargs['model_package_id'] = model_package_id
            path_args['modelPackageId'] = model_package_id
            path = '/api/v2/modelPackages/{modelPackageId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelPackageRetrieveResponse(**server_data)

        @classmethod
        def model_packages_shared_roles_list(
            cls,
            model_package_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get model package's access control list

            Get a list of users, groups and organizations who have access to this template and their roles on the template.
            Args:
                model_package_id (str): ID of the model package.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                SharingListV2Response
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['model_package_id'] = model_package_id
            path_args['modelPackageId'] = model_package_id
            path = '/api/v2/modelPackages/{modelPackageId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SharingListV2Response(**server_data)

