#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.accuracy_over_time_plots_data_response import AccuracyOverTimePlotsDataResponse
from datarobot.models.full_api.generated.model.accuracy_over_time_plots_metadata_response import AccuracyOverTimePlotsMetadataResponse
from datarobot.models.full_api.generated.model.advanced_tuning_arguments_retrieve_response import AdvancedTuningArgumentsRetrieveResponse
from datarobot.models.full_api.generated.model.all_multiclass_model_lift_charts_response import AllMulticlassModelLiftChartsResponse
from datarobot.models.full_api.generated.model.anomaly_insight_table_retrieve import AnomalyInsightTableRetrieve
from datarobot.models.full_api.generated.model.anomaly_over_time_plots_data_response import AnomalyOverTimePlotsDataResponse
from datarobot.models.full_api.generated.model.anomaly_over_time_plots_metadata_response import AnomalyOverTimePlotsMetadataResponse
from datarobot.models.full_api.generated.model.anomaly_over_time_plots_preview_response import AnomalyOverTimePlotsPreviewResponse
from datarobot.models.full_api.generated.model.backtest_stability_plot_response import BacktestStabilityPlotResponse
from datarobot.models.full_api.generated.model.base_blender_builder_create import BaseBlenderBuilderCreate
from datarobot.models.full_api.generated.model.blender_create import BlenderCreate
from datarobot.models.full_api.generated.model.blender_info_retrieve_response import BlenderInfoRetrieveResponse
from datarobot.models.full_api.generated.model.blender_list_response import BlenderListResponse
from datarobot.models.full_api.generated.model.blender_retrieve_response import BlenderRetrieveResponse
from datarobot.models.full_api.generated.model.create_shap_matrix_payload import CreateShapMatrixPayload
from datarobot.models.full_api.generated.model.cross_validation_retrieve_response import CrossValidationRetrieveResponse
from datarobot.models.full_api.generated.model.datetime_model_details_response import DatetimeModelDetailsResponse
from datarobot.models.full_api.generated.model.datetime_model_submission_response import DatetimeModelSubmissionResponse
from datarobot.models.full_api.generated.model.datetime_models_response import DatetimeModelsResponse
from datarobot.models.full_api.generated.model.datetime_trend_plots_create import DatetimeTrendPlotsCreate
from datarobot.models.full_api.generated.model.datetime_trend_plots_preview_response import DatetimeTrendPlotsPreviewResponse
from datarobot.models.full_api.generated.model.datetime_trend_plots_response import DatetimeTrendPlotsResponse
from datarobot.models.full_api.generated.model.forecast_distance_stability_plot_response import ForecastDistanceStabilityPlotResponse
from datarobot.models.full_api.generated.model.forecast_vs_actual_plots_data_response import ForecastVsActualPlotsDataResponse
from datarobot.models.full_api.generated.model.forecast_vs_actual_plots_metadata_response import ForecastVsActualPlotsMetadataResponse
from datarobot.models.full_api.generated.model.frozen_model_create import FrozenModelCreate
from datarobot.models.full_api.generated.model.frozen_model_list_response import FrozenModelListResponse
from datarobot.models.full_api.generated.model.frozen_model_retrieve_response import FrozenModelRetrieveResponse
from datarobot.models.full_api.generated.model.missing_report_retrieve import MissingReportRetrieve
from datarobot.models.full_api.generated.model.model_advanced_tuning import ModelAdvancedTuning
from datarobot.models.full_api.generated.model.model_capabilities_retrieve_response import ModelCapabilitiesRetrieveResponse
from datarobot.models.full_api.generated.model.model_confusion_chart_class_details_retrieve_reponse_controller import ModelConfusionChartClassDetailsRetrieveReponseController
from datarobot.models.full_api.generated.model.model_confusion_chart_list_response import ModelConfusionChartListResponse
from datarobot.models.full_api.generated.model.model_confusion_chart_metadata_retrieve_response import ModelConfusionChartMetadataRetrieveResponse
from datarobot.models.full_api.generated.model.model_confusion_chart_retrieve_response import ModelConfusionChartRetrieveResponse
from datarobot.models.full_api.generated.model.model_details_response import ModelDetailsResponse
from datarobot.models.full_api.generated.model.model_export import ModelExport
from datarobot.models.full_api.generated.model.model_feature_list_response import ModelFeatureListResponse
from datarobot.models.full_api.generated.model.model_job_response import ModelJobResponse
from datarobot.models.full_api.generated.model.model_lift_chart_list_response import ModelLiftChartListResponse
from datarobot.models.full_api.generated.model.model_lift_chart_response import ModelLiftChartResponse
from datarobot.models.full_api.generated.model.model_parameters_retrieve_response import ModelParametersRetrieveResponse
from datarobot.models.full_api.generated.model.model_residuals_list import ModelResidualsList
from datarobot.models.full_api.generated.model.model_retrain_response import ModelRetrainResponse
from datarobot.models.full_api.generated.model.model_roc_curve_list_response import ModelRocCurveListResponse
from datarobot.models.full_api.generated.model.model_roc_curve_response import ModelRocCurveResponse
from datarobot.models.full_api.generated.model.model_update import ModelUpdate
from datarobot.models.full_api.generated.model.modeling_job_list_response import ModelingJobListResponse
from datarobot.models.full_api.generated.model.multiclass_model_lift_chart_response import MulticlassModelLiftChartResponse
from datarobot.models.full_api.generated.model.num_iterations_trained_response import NumIterationsTrainedResponse
from datarobot.models.full_api.generated.model.prediction_intervals_create import PredictionIntervalsCreate
from datarobot.models.full_api.generated.model.prediction_intervals_create_response import PredictionIntervalsCreateResponse
from datarobot.models.full_api.generated.model.prediction_intervals_list_response import PredictionIntervalsListResponse
from datarobot.models.full_api.generated.model.prepare_for_deployment import PrepareForDeployment
from datarobot.models.full_api.generated.model.recommended_model_response import RecommendedModelResponse
from datarobot.models.full_api.generated.model.retrain_datetime_model import RetrainDatetimeModel
from datarobot.models.full_api.generated.model.retrain_model import RetrainModel
from datarobot.models.full_api.generated.model.shap_matrix_list_response import ShapMatrixListResponse
from datarobot.models.full_api.generated.model.shap_matrix_retrieve_response import ShapMatrixRetrieveResponse
from datarobot.models.full_api.generated.model.train_datetime_frozen_model import TrainDatetimeFrozenModel
from datarobot.models.full_api.generated.model.train_datetime_model import TrainDatetimeModel
from datarobot.models.full_api.generated.model.train_model import TrainModel
from datarobot.models.full_api.generated.model.word_cloud_retrieve_response import WordCloudRetrieveResponse


class ModelsApi(APIObject):

        @classmethod
        def model_exports_create(
            cls,
            **kwargs
        ):
            """Create model export job

            Create model export job. Note: Export of User and Open-Source models (and blenders including these models) is not supported at the moment.

            Keyword Args:
                model_export (ModelExport): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/modelExports/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_blender_builders_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create blenders using the blender builder system.

            Create a blender builder job, which will create one or more blenders.  The CORRELATION     method uses a combination of model accuracy score along with correlation between models to     select models for blending.  The VALIDATION method uses the raw model accuracy scores, but     can be useful for creating different types of blenders with those models.
            Args:
                project_id (str): The project ID

            Keyword Args:
                base_blender_builder_create (BaseBlenderBuilderCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/blenderBuilders/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_blender_builders_list(
            cls,
            project_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """Get information about all blender builder jobs associated with the project.

            Get information about all blender builder jobs associated with the project.
            Args:
                project_id (str): The project ID that the blender builder is associated with.
                offset (int): The maximum number of blender builder job records to return. defaults to 0, must be one of [0]
                limit (int): pagination offset. defaults to 100, must be one of [100]

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/projects/{projectId}/blenderBuilders/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_blender_builders_retrieve(
            cls,
            project_id,
            build_id,
            **kwargs
        ):
            """Get information about a completed blender builder job.

            Get information about a completed blender builder job.
            Args:
                project_id (str): The project ID that the blender builder is associated with.
                build_id (str): The ID of the blender builder job to get data for.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['build_id'] = build_id
            path_args['buildId'] = build_id
            path = '/api/v2/projects/{projectId}/blenderBuilders/{buildId}/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_blender_models_blend_check_create(
            cls,
            project_id,
            **kwargs
        ):
            """Check if models can be blended.

            Check if models can be blended.
            Args:
                project_id (str): The project ID

            Keyword Args:
                blender_create (BlenderCreate): [optional]
            Returns:
                BlenderInfoRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/blenderModels/blendCheck/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlenderInfoRetrieveResponse(**server_data)

        @classmethod
        def projects_blender_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a blender from other models using a specified blender method.

            Create a blender from other models using a specified blender method. Note: Time Series projects only allow the following blender methods: \"AVG\", \"MED\", \"FORECAST_DISTANCE_ENET\", and \"FORECAST_DISTANCE_AVG\".
            Args:
                project_id (str): The project ID

            Keyword Args:
                blender_create (BlenderCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/blenderModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_blender_models_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List all blenders in a project.

            List all blenders in a project.
            Args:
                project_id (str): The project ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                BlenderListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/blenderModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlenderListResponse(**server_data)

        @classmethod
        def projects_blender_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a blender.

            Retrieve a blender. Blenders are a special type of models, so the response includes all attributes that would be in a response to :http:get:`/api/v2/projects/(projectId)/models/(modelId)/` as well as some additional ones.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                BlenderRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/blenderModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BlenderRetrieveResponse(**server_data)

        @classmethod
        def projects_datetime_models_accuracy_over_time_plots_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the data for the Accuracy over Time plots.

            Retrieve the data for the Accuracy over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
                forecast_distance (int): Forecast distance to retrieve the data for. If not specified, the first forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. [optional]
                resolution (str): Specifying at which resolution the data should be binned. If not specified, optimal resolution will be used to build chart data with number of bins <= `maxBinSize`. [optional]
                max_bin_size (int): Specifies the maximum number of bins for the retrieval.. [optional] if omitted the server will use the default value of 500
                start_date (datetime): The start of the date range to return. If not specified, start date for requested plots will be used.. [optional]
                end_date (datetime): The end of the date range to return. If not specified, end date for requested plots will be used.. [optional]
            Returns:
                AccuracyOverTimePlotsDataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AccuracyOverTimePlotsDataResponse(**server_data)

        @classmethod
        def projects_datetime_models_accuracy_over_time_plots_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the metadata for the Accuracy over Time plots.

            Retrieve the metadata for the Accuracy over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                forecast_distance (int): Forecast distance to retrieve the data for. If not specified, the first forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. [optional]
            Returns:
                AccuracyOverTimePlotsMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AccuracyOverTimePlotsMetadataResponse(**server_data)

        @classmethod
        def projects_datetime_models_accuracy_over_time_plots_preview_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the preview for the Accuracy over Time plots.

            Retrieve the preview for the Accuracy over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
                forecast_distance (int): Forecast distance to retrieve the data for. If not specified, the first forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. [optional]
            Returns:
                DatetimeTrendPlotsPreviewResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/accuracyOverTimePlots/preview/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeTrendPlotsPreviewResponse(**server_data)

        @classmethod
        def projects_datetime_models_anomaly_over_time_plots_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the data for the Anomaly over Time plots.

            Retrieve the data for the Anomaly over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
                resolution (str): Specifying at which resolution the data should be binned. If not specified, optimal resolution will be used to build chart data with number of bins <= `maxBinSize`. [optional]
                max_bin_size (int): Specifies the maximum number of bins for the retrieval.. [optional] if omitted the server will use the default value of 500
                start_date (datetime): The start of the date range to return. If not specified, start date for requested plots will be used.. [optional]
                end_date (datetime): The end of the date range to return. If not specified, end date for requested plots will be used.. [optional]
            Returns:
                AnomalyOverTimePlotsDataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyOverTimePlotsDataResponse(**server_data)

        @classmethod
        def projects_datetime_models_anomaly_over_time_plots_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the metadata for the Anomaly over Time plots.

            Retrieve the metadata for the Anomaly over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                AnomalyOverTimePlotsMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyOverTimePlotsMetadataResponse(**server_data)

        @classmethod
        def projects_datetime_models_anomaly_over_time_plots_preview_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the preview for the Anomaly over Time plots.

            Retrieve the preview for the Anomaly over Time plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
                prediction_threshold (float): Only bins with predictions exceeding this threshold will be returned in the response.. [optional] if omitted the server will use the default value of 0.5
            Returns:
                AnomalyOverTimePlotsPreviewResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/anomalyOverTimePlots/preview/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyOverTimePlotsPreviewResponse(**server_data)

        @classmethod
        def projects_datetime_models_backtest_stability_plot_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a plot displaying the stability of the datetime model across different backtests.

            Retrieve a plot displaying the stability of the datetime model across different backtests.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                metric_name (str): The name of the metric to retrieve the scores for. If omitted, the default project metric will be used. [optional]
                forecast_distance (int): The forecast distance to retrieve the plot for. If not specified, the scores for each partition are aggregated across all forecast distances. This parameter is only available for time series models.. [optional]
            Returns:
                BacktestStabilityPlotResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/backtestStabilityPlot/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BacktestStabilityPlotResponse(**server_data)

        @classmethod
        def projects_datetime_models_backtests_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Score all the available backtests of a datetime model.

            Score all the available backtests of a datetime model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/backtests/'.format(**path_args)
            cls._client.post(path)

        @classmethod
        def projects_datetime_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Train a new datetime model.

            Train a new datetime model.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.
            Args:
                project_id (str): The project ID

            Keyword Args:
                train_datetime_model (TrainDatetimeModel): [optional]
            Returns:
                DatetimeModelSubmissionResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/datetimeModels/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeModelSubmissionResponse(**server_data)

        @classmethod
        def projects_datetime_models_datetime_trend_plots_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Computes Datetime Trend plots for time series and OTV projects.

            Computes Datetime Trend plots for time series and OTV projects: * For OTV projects, computes Accuracy over Time plots. * For time series supervised projects, computes both Accuracy over Time plots and Forecast vs Actual plots. .. minversion:: v2.25    * For unsupervised time series and OTV models, computes Anomaly Over Time plots. .. note::    For the multiseries time series projects only first 1000 series in alphabetical order    and an average plot for them will be computed. .. note::    Maximum 100 forecast distances can be requested for calculation in time series supervised projects.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                datetime_trend_plots_create (DatetimeTrendPlotsCreate): [optional]
            Returns:
                DatetimeTrendPlotsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/datetimeTrendPlots/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeTrendPlotsResponse(**server_data)

        @classmethod
        def projects_datetime_models_forecast_distance_stability_plot_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a plot displaying the stability of the time series model across different forecast distances.

            Retrieve a plot displaying the stability of the time series model across different forecast distances. .. note::    All durations and datetimes are specified in accordance with the   :ref:`timestamp and duration formatting rules <time_format>`. 
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                metric_name (str): The name of the metric to retrieve the scores for. If omitted, the default project metric will be used.. [optional]
            Returns:
                ForecastDistanceStabilityPlotResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastDistanceStabilityPlot/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ForecastDistanceStabilityPlotResponse(**server_data)

        @classmethod
        def projects_datetime_models_forecast_vs_actual_plots_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the data for the Forecast vs Actual plots.

            Retrieve the data for the Forecast vs Actual plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
                resolution (str): Specifying at which resolution the data should be binned. If not specified, optimal resolution will be used to build chart data with number of bins <= `maxBinSize`. [optional]
                forecast_distance_start (int): The start of forecast distance range (forecast window) to retrieve. If not specified, the first forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. [optional]
                forecast_distance_end (int): The end of forecast distance range (forecast window) to retrieve. If not specified, the last forecast distance for this project will be used. Forecast distance specifies the number of time steps between the predicted point and the origin point. Only available for time series supervised projects.. [optional]
                max_bin_size (int): Specifies the maximum number of bins for the retrieval.. [optional] if omitted the server will use the default value of 500
                start_date (datetime): The start of the date range to return. If not specified, start date for requested plots will be used.. [optional]
                end_date (datetime): The end of the date range to return. If not specified, end date for requested plots will be used.. [optional]
            Returns:
                ForecastVsActualPlotsDataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ForecastVsActualPlotsDataResponse(**server_data)

        @classmethod
        def projects_datetime_models_forecast_vs_actual_plots_metadata_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the metadata for the Forecast vs Actual plots.

            Retrieve the metadata for the Forecast vs Actual plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ForecastVsActualPlotsMetadataResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ForecastVsActualPlotsMetadataResponse(**server_data)

        @classmethod
        def projects_datetime_models_forecast_vs_actual_plots_preview_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the preview for the Forecast vs Actual plots.

            Retrieve the preview for the Forecast vs Actual plots.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_id (str): The name of the series to retrieve. Only available for time series multiseries projects. If not provided an average plot for the first 1000 series will be retrieved.. [optional]
                backtest (bool, date, datetime, dict, float, int, list, str, none_type): Retrieve plots for a specific backtest (use the backtest index starting from zero) or `holdout`. If not specified the first backtest (backtest index 0) will be used.. [optional]
                source (str): The source of the data for the backtest/holdout.. [optional] if omitted the server will use the default value of "validation"
            Returns:
                DatetimeTrendPlotsPreviewResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/forecastVsActualPlots/preview/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeTrendPlotsPreviewResponse(**server_data)

        @classmethod
        def projects_datetime_models_from_model_create(
            cls,
            project_id,
            **kwargs
        ):
            """Retrain an existing datetime model with specified parameters.

            Retrain an existing datetime model using a new training period for the model training set (with optional time window sampling) or different feature list.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.  Note that only one of `trainingDuration` or `trainingRowCount` or `trainingStartDate` and `trainingEndDate` should be specified. If `trainingStartDate` and `trainingEndDate` are specified, the source model must be frozen.
            Args:
                project_id (str): The project ID

            Keyword Args:
                retrain_datetime_model (RetrainDatetimeModel): [optional]
            Returns:
                DatetimeModelSubmissionResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/datetimeModels/fromModel/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeModelSubmissionResponse(**server_data)

        @classmethod
        def projects_datetime_models_list(
            cls,
            project_id,
            **kwargs
        ):
            """List datetime partitioned project models

            List all the models from a datetime partitioned project.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
                bulk_operation_id (str): the ID of the bulk model operation. If specified, only models submitted in scope of this operation will be shown.. [optional]
            Returns:
                DatetimeModelsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/datetimeModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeModelsResponse(**server_data)

        @classmethod
        def projects_datetime_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Get datetime model

            Look up a particular datetime model All durations and datetimes are specified in accordance with :ref:`timestamp and duration formatting rules <time_format>`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                DatetimeModelDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeModelDetailsResponse(**server_data)

        @classmethod
        def projects_deployment_ready_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Prepare a model for deployment

            Prepare a specific model for deployment. This model will go through the recommendation stages.
            Args:
                project_id (str): The project ID

            Keyword Args:
                prepare_for_deployment (PrepareForDeployment): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/deploymentReadyModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_frozen_datetime_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Train a frozen datetime model.

            Train a frozen datetime model. If no training data is specified, the frozen datetime model will be trained on the most recent data using an amount of data that is equivalent to the original model. However, if the equivalent duration does not provide enough rows for training, then the duration will be extended until the minimum is met. Note that this will require the holdout of the project to be unlocked.  All durations and datetimes should be specified in accordance with the :ref:`timestamp and duration formatting rules<time_format>`.  Note that only one of `trainingDuration`, `trainingRowCount`, `trainingStartDate` and `trainingEndDate`, or `useProjectSettings` may be specified.
            Args:
                project_id (str): The project ID

            Keyword Args:
                train_datetime_frozen_model (TrainDatetimeFrozenModel): [optional]
            Returns:
                DatetimeModelSubmissionResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/frozenDatetimeModels/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return DatetimeModelSubmissionResponse(**server_data)

        @classmethod
        def projects_frozen_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Train a new frozen model with parameters from an existing model.

            Train a new frozen model with parameters from an existing model. Frozen models use tuning parameters from another model on the leaderboard, allowing them to be retrained on a larger amount of the training data more efficiently.   To specify the amount of data to use to train the model, use either `samplePct` to express a percentage of the rows of the dataset to use or `trainingRowCount` to express the number of rows to use.   If neither `samplePct` or `trainingRowCount` is specified, the model will be trained on the maximum available training data that can be used to train an in-memory model.   For projects using smart sampling, `samplePct` and `trainingRowCount` will be interpreted as a percent or number of rows of the minority class.
            Args:
                project_id (str): The project ID

            Keyword Args:
                frozen_model_create (FrozenModelCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/frozenModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_frozen_models_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List all frozen models from a project.

            List all frozen models from a project.
            Args:
                project_id (str): The project ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
                with_metric (str): If specified, the returned models will only have scores for this metric.  If not, all metrics will be included.. [optional]
            Returns:
                FrozenModelListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/frozenModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FrozenModelListResponse(**server_data)

        @classmethod
        def projects_frozen_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Look up a particular frozen model.

            Look up a particular frozen model. If model with given ID exists but it's not frozen, returns 404 Not Found.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                FrozenModelRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/frozenModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return FrozenModelRetrieveResponse(**server_data)

        @classmethod
        def projects_model_jobs_delete(
            cls,
            project_id,
            job_id,
            **kwargs
        ):
            """Cancel a modeling job.

            Cancel a modeling job
            Args:
                project_id (str): The project ID.
                job_id (str): The job ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/projects/{projectId}/modelJobs/{jobId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_model_jobs_list(
            cls,
            project_id,
            **kwargs
        ):
            """List modeling jobs

            List modeling jobs.
            Args:
                project_id (str): The project ID.

            Keyword Args:
                status (str): If provided, only jobs with the same status will be included in the results; otherwise, queued and inprogress jobs (but not errored jobs) will be returned.. [optional]
            Returns:
                ModelingJobListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/modelJobs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelingJobListResponse(**server_data)

        @classmethod
        def projects_model_jobs_retrieve(
            cls,
            project_id,
            job_id,
            **kwargs
        ):
            """Look up a specific modeling job

            Look up a particular modeling job
            Args:
                project_id (str): The project ID.
                job_id (str): The job ID

            Keyword Args:
            Returns:
                ModelJobResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/projects/{projectId}/modelJobs/{jobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelJobResponse(**server_data)

        @classmethod
        def projects_models_advanced_tuning_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Submit a job to make a new version of the model with different advanced tuning parameters.

            Submit a job to make a new version of the model with different advanced tuning parameters. Note: This route currently supports all models other than: OSS, blenders, prime, scaleout, baseline and user-created. Currently, only single-stage models (most simple models) are supported. Blueprints that run multiple steps, for example one step to predict zero vs nonzero and a second step to determine the value of nonzero predictions, are not supported. (:ref:`Advanced Tuning documentation <grid_search>`). Parameters may be omitted from this endpoint. If a parameter is omitted, its `currentValue` will be used. To see the possible parameter IDs and constraints on possible values, see :http:get:`/api/v2/projects/(projectId)/models/(modelId)/advancedTuning/parameters/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                model_advanced_tuning (ModelAdvancedTuning): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/advancedTuning/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_advanced_tuning_parameters_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve information about all advanced tuning parameters available for the specified model.

            Retrieve information about all advanced tuning parameters available for the specified model. Note: This route currently supports all models other than: OSS, blenders, prime, scaleout, baseline and user-created
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                AdvancedTuningArgumentsRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/advancedTuning/parameters/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AdvancedTuningArgumentsRetrieveResponse(**server_data)

        @classmethod
        def projects_models_anomaly_insights_file_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a CSV file of the raw data displayed with the anomaly score from the model.

                      Retrieve a CSV file of the raw data displayed with the anomaly score from the         specific model. The number of rows included will be set by the         expected outlier fraction but up to a maximum of 1000 rows.         Only models built from anomaly detection blueprints have those insights.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                filename (str): name of the file to generate and return. [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/anomalyInsightsFile/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_models_anomaly_insights_table_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a table of the raw data displayed with the anomaly score from the specific model.

            Retrieve a table of the raw data displayed with the anomaly score from the         specific model. The number of rows displayed is limited to 100 rows by         the ANOMALY_INSIGHT_SAMPLE_ROW_COUNT configuration setting. Additionally,         feature column count and the size of data in text fields is also limited.         Only models built from anomaly detection blueprints have those insights.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                anomaly_score_rounding (int): number of decimals each element anomalyScore column will be rounded to.. [optional]
            Returns:
                AnomalyInsightTableRetrieve
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/anomalyInsightsTable/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AnomalyInsightTableRetrieve(**server_data)

        @classmethod
        def projects_models_confusion_charts_class_details_list(
            cls,
            class_name,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Calculates and sends frequency of class in distributed among other classes for actual and predicted data.

                     Calculates and sends frequency of class in distributed among other         classes for actual and predicted data. A confusion chart class details for given class gives         stats of misclassification done by model for given class for actual and predicted data.         .. note:: Available for multiclass projects only.         
            Args:
                class_name (str): Name of a class for which distribution frequency is requested.
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data

            Keyword Args:
            Returns:
                ModelConfusionChartClassDetailsRetrieveReponseController
            """
            path_args = {}
            kwargs['class_name'] = class_name
            path_args['className'] = class_name
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/classDetails/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelConfusionChartClassDetailsRetrieveReponseController(**server_data)

        @classmethod
        def projects_models_confusion_charts_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve all available confusion charts for model.

                     Retrieve all available confusion charts for model. The response will         include a json array of all available confusion charts, in the same format as the response         from :http:get:`/api/v2/projects/(projectId)/models/(modelId)/confusionCharts/(source)/`.         .. note:: Available for multiclass projects only.         
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelConfusionChartListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelConfusionChartListResponse(**server_data)

        @classmethod
        def projects_models_confusion_charts_metadata_list(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve metadata for the confusion chart of a model.

                     Retrieve metadata for the confusion chart of a model.         .. note:: Available for multiclass projects only.         
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data

            Keyword Args:
                order_by (str): Ordering the chart data by following attributes.Prefix the attribute name with a dash to sort in descending order, e.g. orderBy='-predictedCount'. [optional] if omitted the server will use the default value of "className"
                orientation (str): Determines whether the values in the rows of the confusion matrix should correspond to the same actual class ('actual') or predicted class ('predicted').. [optional] if omitted the server will use the default value of "actual"
                thumbnail_cell_size (int): Number of classes in a single 'thumbnail' cell.. [optional] if omitted the server will use the default value of 10
            Returns:
                ModelConfusionChartMetadataRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/metadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelConfusionChartMetadataRetrieveResponse(**server_data)

        @classmethod
        def projects_models_confusion_charts_retrieve(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve the confusion chart data from a single source.

                     Retrieve the confusion chart data from a single source. A confusion chart consists of the confusion matrix for all classes, classes frequencies and `oneVsAll` metrics for all classes. The confusion matrix can be requested in a particular sort order and orientated by rows or columns. A subset of the confusion matrix can also be requested in part by specifying slicing indices. Throughout the following specification, `C` refers to the total number of classes in the dataset. The full confusion matrix refers to the confusion matrix with `C` classes.          .. note:: Available for multiclass projects only.          An example on the meaning of wasActualPercentages and wasPredictedPercentages:         Let's say we have the following data:         .. code-block:: js                         classMetrics.classA.wasActualPercentages[0].percentage = 0.56            classMetrics.classA.wasPredictedPercentages[0].percentage = 0.62            classA.wasActualPercentages[0].otherClassName = \"classB\"            classA.wasPredictedPercentages[0].otherClassName = \"classB\"               That means:          1) \"Given that it was actually classA, it predicted classB 56% of the time\".         2) \"Given that classA was predicted, it was actually classB 62% of the time\".         
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data

            Keyword Args:
                order_by (str): Ordering the chart data by following attributes.Prefix the attribute name with a dash to sort in descending order, e.g. orderBy='-predictedCount'. [optional] if omitted the server will use the default value of "className"
                orientation (str): Determines whether the values in the rows of the confusion matrix should correspond to the same actual class ('actual') or predicted class ('predicted').. [optional] if omitted the server will use the default value of "actual"
                row_start (int): start index of row for slicing the confusion matrix.. [optional]
                row_end (int): end index of row for slicing the confusion matrix.. [optional]
                col_start (int): start index of column for slicing the confusion matrix.. [optional]
                col_end (int): end index of column for slicing the confusion matrix.. [optional]
            Returns:
                ModelConfusionChartRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/confusionCharts/{source}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelConfusionChartRetrieveResponse(**server_data)

        @classmethod
        def projects_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Train a new model

            Train a new model. To specify the amount of data to use to train the model, use either `samplePct` to express a percentage of the rows of the dataset to use or `trainingRowCount` to express the number of rows to use. If neither `samplePct` or `trainingRowCount` is specified, the model will be trained on the maximum available training data that can be used to train an in-memory model. For projects using smart sampling, samplePct and trainingRowCount will be interpreted as a percent or number of rows of the minority class.
            Args:
                project_id (str): The project ID.

            Keyword Args:
                train_model (TrainModel): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/models/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_cross_validation_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Run Cross Validation on a model.

            Run Cross Validation on a model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossValidation/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_cross_validation_scores_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Get Cross Validation scores for each partition in a model.

                     Get Cross Validation scores for each partition in a model.         .. note:: Individual partition scores are only available for newer models; older models that                   have cross validation score calculated will need to be retrained.         
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                metric (str): Set to the name of a metric to only return results for that metric.. [optional]
                partition (float): Set to a value such as 1.0, 2.0 to only return results for the specified partition.. [optional]
            Returns:
                CrossValidationRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/crossValidationScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CrossValidationRetrieveResponse(**server_data)

        @classmethod
        def projects_models_delete(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Delete a model from the leaderboard.

            Delete a model from the leaderboard
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_models_export_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Download exported model

            Download exported model
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/export/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_models_features_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """List the features used in a model.

            List the features used in a model
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelFeatureListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/features/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelFeatureListResponse(**server_data)

        @classmethod
        def projects_models_from_model_create(
            cls,
            project_id,
            **kwargs
        ):
            """Retrain a model

            Retrain an existing model using a new sample size and/or feature list. Note that only one of `samplePct` or `trainingRowCount` should be specified.
            Args:
                project_id (str): The project ID

            Keyword Args:
                retrain_model (RetrainModel): [optional]
            Returns:
                ModelRetrainResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/models/fromModel/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelRetrainResponse(**server_data)

        @classmethod
        def projects_models_lift_chart_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve all available lift charts for model.

            Retrieve all available lift charts for model. The response will include a json list of all available lift charts, in the same format as the response from :http:get:`/api/v2/projects/(projectId)/models/(modelId)/liftChart/(source)/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelLiftChartListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/liftChart/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelLiftChartListResponse(**server_data)

        @classmethod
        def projects_models_lift_chart_retrieve(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve the lift chart data from a single source.

            Retrieve the lift chart data from a single source.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data

            Keyword Args:
            Returns:
                ModelLiftChartResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/liftChart/{source}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelLiftChartResponse(**server_data)

        @classmethod
        def projects_models_list(
            cls,
            project_id,
            **kwargs
        ):
            """List project models

            Lists all the models from a project.
            Args:
                project_id (str): The project ID.

            Keyword Args:
                bulk_operation_id (str): The ID of the bulk model operation. If specified, only models submitted in scope of this operation will be shown.. [optional]
                order_by (str): A comma-separated list of metrics to sort by. If metric is prefixed with a '-', models will be sorted by this metric in descending order, otherwise in ascending order. Valid sorting metrics are `metric` and `samplePct`. `metric` will sort models by metric value selected for this project using validation score. This accounts for the direction of the metric, so `-metric` will sort in order of decreasing 'goodness', which may be opposite to the natural numerical order. If not specified, `-metric` will be used.. [optional]
                name (str): If specified, will filter for models with model type matching `name`. [optional]
                sample_pct (float): If specified, will filter for models with matching sample percentage. [optional]
                with_metric (str): If specified, the returned models will only have scores for this metric. If not, all metrics will be included.. [optional]
                is_starred (str): If specified, will filter for models marked as starred.. [optional]
            Returns:
                ModelDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/models/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelDetailsResponse(**server_data)

        @classmethod
        def projects_models_missing_report_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve a summary of how the model's subtasks handle missing values.

            Retrieve a summary of how the model's subtasks handle missing values         Only models built after the missing value report feature was added will have reports,          and only models with at least one imputation or encoding task, e.g. ordinal encoding,          missing value imputation. Blenders and scaleout models do not support Missing Value reports.          The report will describe how each feature's missing values were treated, and report how many         missing values were present in the training data. Features which were not processed by a         given blueprint task will not mention it: for instance, a categorical feature with many          unique values may not be considered eligible for processing by a One-Hot Encoding          Report is collected for those features which are considered eligible by given          blueprint task. For instance, categorical feature with a lot of unique values may not be          considered as eligible in One-Hot Encoding task.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                MissingReportRetrieve
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/missingReport/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return MissingReportRetrieve(**server_data)

        @classmethod
        def projects_models_multiclass_lift_chart_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve all available lift charts for multiclass model.

            Retrieve all available lift charts for multiclass model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                AllMulticlassModelLiftChartsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/multiclassLiftChart/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AllMulticlassModelLiftChartsResponse(**server_data)

        @classmethod
        def projects_models_multiclass_lift_chart_retrieve(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve the multiclass lift chart data from a single source.

            Retrieve the multiclass lift chart data from a single source.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data.

            Keyword Args:
            Returns:
                MulticlassModelLiftChartResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/multiclassLiftChart/{source}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return MulticlassModelLiftChartResponse(**server_data)

        @classmethod
        def projects_models_num_iterations_trained_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Get number of iterations trained

            Retrieve the actual number of iterations or estimators trained by a tree-based early stopping model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                NumIterationsTrainedResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/numIterationsTrained/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NumIterationsTrainedResponse(**server_data)

        @classmethod
        def projects_models_parameters_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve model parameters.

            Retrieve model parameters. These are the parameters that appear in the webapp on the `Coefficients` tab. Note that they are only available for some models.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelParametersRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/parameters/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelParametersRetrieveResponse(**server_data)

        @classmethod
        def projects_models_patch(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Updates a model's attribute(s).

            Updates a model's attribute(s)
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                model_update (ModelUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def projects_models_prediction_intervals_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Calculate prediction intervals for the specified percentiles for this model.

            Submit a job to calculate prediction intervals for the specified percentiles for this model.  Note that the project this model belongs to must be a time series project.
            Args:
                project_id (str): The project to calculate prediction intervals for. Must be a time series project.
                model_id (str): The model to calculate prediction intervals for.

            Keyword Args:
                prediction_intervals_create (PredictionIntervalsCreate): [optional]
            Returns:
                PredictionIntervalsCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionIntervals/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntervalsCreateResponse(**server_data)

        @classmethod
        def projects_models_prediction_intervals_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve prediction intervals that are already calculated for this model.

            Retrieve prediction intervals (in descending order) that are already calculated for this model. Note that the project this model belongs to must be a time series project.
            Args:
                project_id (str): The project to retrieve prediction intervals for. Must be a time series project.
                model_id (str): The model to retrieve prediction intervals for.

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            Returns:
                PredictionIntervalsListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionIntervals/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntervalsListResponse(**server_data)

        @classmethod
        def projects_models_residuals_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve all residuals charts for a model.

            Retrieve all residuals charts for a model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelResidualsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/residuals/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelResidualsList(**server_data)

        @classmethod
        def projects_models_residuals_retrieve(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve the residuals chart data from a single source.

            Retrieve the residuals chart data from a single source.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data.

            Keyword Args:
            Returns:
                ModelResidualsList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/residuals/{source}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelResidualsList(**server_data)

        @classmethod
        def projects_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Get model

            Look up a particular model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelDetailsResponse(**server_data)

        @classmethod
        def projects_models_roc_curve_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve all available ROC curves for model.

            Retrieve all available ROC curves for model. The response will include a json list of all available ROC curves, in the same format as the response from :http:get:`/api/v2/projects/(projectId)/models/(modelId)/rocCurve/(source)/`.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelRocCurveListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/rocCurve/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelRocCurveListResponse(**server_data)

        @classmethod
        def projects_models_roc_curve_retrieve(
            cls,
            project_id,
            model_id,
            source,
            **kwargs
        ):
            """Retrieve the ROC curve data from a single source.

            Retrieve the ROC curve data from a single source. The response includes an array of pointsshowing the performance of the model at different thresholds for classification, and arrays of sample predictions for both the positive and negative classes.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                source (str): Source of the data

            Keyword Args:
            Returns:
                ModelRocCurveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            kwargs['source'] = source
            path_args['source'] = source
            path = '/api/v2/projects/{projectId}/models/{modelId}/rocCurve/{source}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelRocCurveResponse(**server_data)

        @classmethod
        def projects_models_scoring_code_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Scoring Code

            Retrieve Scoring Code for making new predictions from an existing model offline. You need the \"Scoring Code\" feature enabled to use this route.  By default, returns a compiled executable JAR that can be executed locally to calculate model predictions, or it can be used as a library for a Java application. Execute it with the '--help` parameters to learn how to use it as a command-line utility. See model API documentation (https://javadoc.io/doc/com.datarobot/datarobot-prediction/latest/index.html) to be able to use it inside an existing Java application.  With the sourceCode query parameter set to 'true', returns a source code archive that can be used to review internal calculations of the model. This JAR is NOT executable.  See \"https://app.datarobot.com/docs/predictions/scoring-code/scorecode.html\" in DataRobot application for more information.
            Args:
                project_id (str): the project that created the model
                model_id (str): the model to use

            Keyword Args:
                source_code (str): If set to \"true\", the downloaded JAR file will contain only the source code and will not be executable.. [optional] if omitted the server will use the default value of "false"
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/scoringCode/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_models_supported_capabilities_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Get supported capabilities for a model.

            Get supported capabilities for a model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                ModelCapabilitiesRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/supportedCapabilities/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ModelCapabilitiesRetrieveResponse(**server_data)

        @classmethod
        def projects_models_word_cloud_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve word cloud data for a model.

            Retrieve word cloud data for a model. Not all models will have word cloud data available, even when they use text features.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                exclude_stop_words (str): Set to true if you want stopwords excluded from the response.. [optional]
            Returns:
                WordCloudRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/wordCloud/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return WordCloudRetrieveResponse(**server_data)

        @classmethod
        def projects_recommended_models_list(
            cls,
            project_id,
            **kwargs
        ):
            """List recommended models for the project

            Retrieves all of the current recommended models for the project
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                RecommendedModelResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/recommendedModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RecommendedModelResponse(**server_data)

        @classmethod
        def projects_recommended_models_recommended_model_list(
            cls,
            project_id,
            **kwargs
        ):
            """Get recommended model

            This route returns the simplest recommended model available. To see all the available recommended models, use :http:get:`/api/v2/projects/(projectId)/recommendedModels/`
            Args:
                project_id (str): The project ID

            Keyword Args:
            Returns:
                RecommendedModelResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/recommendedModels/recommendedModel/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RecommendedModelResponse(**server_data)

        @classmethod
        def projects_shap_matrices_create(
            cls,
            project_id,
            **kwargs
        ):
            """Calculate a matrix with SHAP based prediction explanations scores.

            Submit a request to calculate a matrix with SHAP based prediction explanations scores.
            Args:
                project_id (str): The project ID

            Keyword Args:
                create_shap_matrix_payload (CreateShapMatrixPayload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/shapMatrices/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_shap_matrices_list(
            cls,
            project_id,
            **kwargs
        ):
            """List SHAP matrix records.

            Get a list of available SHAP matrix records.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): Number of results to skip.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned. The default may change without notice.. [optional] if omitted the server will use the default value of 100
            Returns:
                ShapMatrixListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/shapMatrices/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ShapMatrixListResponse(**server_data)

        @classmethod
        def projects_shap_matrices_retrieve(
            cls,
            project_id,
            shap_matrix_id,
            **kwargs
        ):
            """Get matrix with SHAP prediction explanations scores.

            Get matrix with SHAP prediction explanations scores.
            Args:
                project_id (str): The project ID.
                shap_matrix_id (str): The SHAP matrix ID.

            Keyword Args:
            Returns:
                ShapMatrixRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['shap_matrix_id'] = shap_matrix_id
            path_args['shapMatrixId'] = shap_matrix_id
            path = '/api/v2/projects/{projectId}/shapMatrices/{shapMatrixId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ShapMatrixRetrieveResponse(**server_data)

