#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.notification_event_list_response import NotificationEventListResponse
from datarobot.models.full_api.generated.model.notification_log_list_response import NotificationLogListResponse
from datarobot.models.full_api.generated.model.notification_policy_mute_create import NotificationPolicyMuteCreate
from datarobot.models.full_api.generated.model.notification_policy_mute_list_response import NotificationPolicyMuteListResponse
from datarobot.models.full_api.generated.model.notification_policy_mute_response import NotificationPolicyMuteResponse
from datarobot.models.full_api.generated.model.notification_resend import NotificationResend


class NotificationsApi(APIObject):

        @classmethod
        def notification_events_list(
            cls,
            **kwargs
        ):
            """List event types and groups the user can include in notification policies.

            List event types and groups the user can include in notification policies. Events and groups are filtered by user permissions and event properties. It is not a complete list of all defined events; instead, it is a list of the events available to the user.

            Keyword Args:
            Returns:
                NotificationEventListResponse
            """
            path_args = {}
            path = '/api/v2/notificationEvents/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationEventListResponse(**server_data)

        @classmethod
        def notification_logs_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List the notification logs

            List the notification logs that correspond to provided conditions. Default ordering is desc by notification log timestamp
            Args:
                offset (int): The number of records to skip over. Default 0. defaults to 0, must be one of [0]
                limit (int): The number of records to return. Default to 100, minimum to 1, maximum to 1000. defaults to 100, must be one of [100]

            Keyword Args:
                policy_id (str): The id of the policy to filter notification logs. [optional]
                channel_id (str): The id of the channel to filter notification logs. [optional]
            Returns:
                NotificationLogListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/notificationLogs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationLogListResponse(**server_data)

        @classmethod
        def notification_policy_mutes_create(
            cls,
            **kwargs
        ):
            """Create a new ignored notification

            Create a new ignored notification

            Keyword Args:
                notification_policy_mute_create (NotificationPolicyMuteCreate): [optional]
            Returns:
                NotificationPolicyMuteResponse
            """
            path_args = {}
            path = '/api/v2/notificationPolicyMutes/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationPolicyMuteResponse(**server_data)

        @classmethod
        def notification_policy_mutes_delete(
            cls,
            mute_id,
            **kwargs
        ):
            """Delete the existing notification policy mute

            Delete the existing notification policy mute
            Args:
                mute_id (str): The id of the notification policy mute to delete

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['mute_id'] = mute_id
            path_args['muteId'] = mute_id
            path = '/api/v2/notificationPolicyMutes/{muteId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def notification_policy_mutes_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List the ignored notifications filtered by orgId if provided

            List the ignored notifications filtered by orgId if provided
            Args:
                offset (int): The number of records to skip over. Default 0. defaults to 0, must be one of [0]
                limit (int): The number of records to return. Default to 100, minimum to 1, maximum to 1000. defaults to 100, must be one of [100]

            Keyword Args:
                entity_id (str): The id of the entity to filter. [optional]
                org_id (str): The id of the organization that ignored notifications relate to. [optional]
            Returns:
                NotificationPolicyMuteListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/notificationPolicyMutes/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationPolicyMuteListResponse(**server_data)

        @classmethod
        def notifications_create(
            cls,
            **kwargs
        ):
            """Resends the notification

            Resends the notification

            Keyword Args:
                notification_resend (NotificationResend): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/notifications/'.format(**path_args)
            cls._client.post(path, data=kwargs)

