#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.organization_job_list_response import OrganizationJobListResponse
from datarobot.models.full_api.generated.model.organization_list_response import OrganizationListResponse
from datarobot.models.full_api.generated.model.organization_retrieve import OrganizationRetrieve


class OrganizationsApi(APIObject):

        @classmethod
        def organizations_jobs_list(
            cls,
            organization_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List organization jobs

            List currently running jobs belonging to this organization.
            Args:
                organization_id (str): Organization ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                OrganizationJobListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            path = '/api/v2/organizations/{organizationId}/jobs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationJobListResponse(**server_data)

        @classmethod
        def organizations_list(
            cls,
            limit=100,
            **kwargs
        ):
            """List organizations

            List organizations available in the system.
            Args:
                limit (int): At most this many results are returned.. defaults to 100, must be one of [100]

            Keyword Args:
                offset (int): The number of records to skip over. Default 0.. [optional] if omitted the server will use the default value of 0
                name_part (str): Only return the organizations whose names contain the given substring.. [optional] if omitted the server will use the default value of ""
            Returns:
                OrganizationListResponse
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/organizations/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationListResponse(**server_data)

        @classmethod
        def organizations_retrieve(
            cls,
            organization_id,
            **kwargs
        ):
            """Retrieve organization

            Retrieve the organization details.
            Args:
                organization_id (str): Organization ID

            Keyword Args:
            Returns:
                OrganizationRetrieve
            """
            path_args = {}
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            path = '/api/v2/organizations/{organizationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationRetrieve(**server_data)

