#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.batch_prediction_job_create import BatchPredictionJobCreate
from datarobot.models.full_api.generated.model.batch_prediction_job_definition_id import BatchPredictionJobDefinitionId
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_create import BatchPredictionJobDefinitionsCreate
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_list_response import BatchPredictionJobDefinitionsListResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_response import BatchPredictionJobDefinitionsResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_definitions_update import BatchPredictionJobDefinitionsUpdate
from datarobot.models.full_api.generated.model.batch_prediction_job_id import BatchPredictionJobId
from datarobot.models.full_api.generated.model.batch_prediction_job_list_response import BatchPredictionJobListResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_response import BatchPredictionJobResponse
from datarobot.models.full_api.generated.model.batch_prediction_job_update import BatchPredictionJobUpdate
from datarobot.models.full_api.generated.model.create_prediction_dataset_response import CreatePredictionDatasetResponse
from datarobot.models.full_api.generated.model.create_prediction_from_dataset import CreatePredictionFromDataset
from datarobot.models.full_api.generated.model.create_training_prediction import CreateTrainingPrediction
from datarobot.models.full_api.generated.model.imorted_model_update_payload import ImortedModelUpdatePayload
from datarobot.models.full_api.generated.model.imported_model_list_response import ImportedModelListResponse
from datarobot.models.full_api.generated.model.imported_model_retrieve_response import ImportedModelRetrieveResponse
from datarobot.models.full_api.generated.model.predict_job_details_response import PredictJobDetailsResponse
from datarobot.models.full_api.generated.model.prediction_data_source import PredictionDataSource
from datarobot.models.full_api.generated.model.prediction_dataset_list_controller_response import PredictionDatasetListControllerResponse
from datarobot.models.full_api.generated.model.prediction_dataset_retrieve_response import PredictionDatasetRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_explanations_create import PredictionExplanationsCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_create import PredictionExplanationsInitializationCreate
from datarobot.models.full_api.generated.model.prediction_explanations_initialization_retrieve import PredictionExplanationsInitializationRetrieve
from datarobot.models.full_api.generated.model.prediction_explanations_record import PredictionExplanationsRecord
from datarobot.models.full_api.generated.model.prediction_explanations_record_list import PredictionExplanationsRecordList
from datarobot.models.full_api.generated.model.prediction_explanations_retrieve import PredictionExplanationsRetrieve
from datarobot.models.full_api.generated.model.prediction_file_upload import PredictionFileUpload
from datarobot.models.full_api.generated.model.prediction_from_catalog_dataset import PredictionFromCatalogDataset
from datarobot.models.full_api.generated.model.prediction_integration_job_create_payload import PredictionIntegrationJobCreatePayload
from datarobot.models.full_api.generated.model.prediction_integration_job_logs_retrieve_response import PredictionIntegrationJobLogsRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_response import PredictionIntegrationJobResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_run_history_response import PredictionIntegrationJobRunHistoryResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_runs_history_response import PredictionIntegrationJobRunsHistoryResponse
from datarobot.models.full_api.generated.model.prediction_integration_job_update import PredictionIntegrationJobUpdate
from datarobot.models.full_api.generated.model.prediction_retrieve_response import PredictionRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_url_upload import PredictionURLUpload
from datarobot.models.full_api.generated.model.retrieve_list_prediction_metadata_objects_response import RetrieveListPredictionMetadataObjectsResponse
from datarobot.models.full_api.generated.model.retrieve_prediction_metadata_object import RetrievePredictionMetadataObject
from datarobot.models.full_api.generated.model.scheduled_job_response import ScheduledJobResponse
from datarobot.models.full_api.generated.model.scheduled_job_run_stop import ScheduledJobRunStop
from datarobot.models.full_api.generated.model.scheduled_jobs_list_response import ScheduledJobsListResponse
from datarobot.models.full_api.generated.model.single_model_file_payload import SingleModelFilePayload
from datarobot.models.full_api.generated.model.training_predictions_list_response import TrainingPredictionsListResponse
from datarobot.models.full_api.generated.model.training_predictions_retrieve_response import TrainingPredictionsRetrieveResponse


class PredictionsApi(APIObject):

        @classmethod
        def batch_prediction_job_definitions_create(
            cls,
            **kwargs
        ):
            """Creates a new Batch Prediction job definition

            Create a Batch Prediction Job definition. A configuration for a Batch Prediction job which can either be executed manually upon request or on scheduled intervals, if enabled. The API payload is the same as for `/batchPredictions` along with optional ``enabled`` and ``schedule`` items.

            Keyword Args:
                batch_prediction_job_definitions_create (BatchPredictionJobDefinitionsCreate): [optional]
            Returns:
                BatchPredictionJobDefinitionsResponse
            """
            path_args = {}
            path = '/api/v2/batchPredictionJobDefinitions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobDefinitionsResponse(**server_data)

        @classmethod
        def batch_prediction_job_definitions_delete(
            cls,
            job_definition_id,
            **kwargs
        ):
            """Delete Batch Prediction job definition

            Delete a Batch Prediction job definition
            Args:
                job_definition_id (str): ID of the Batch Prediction job definition

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['job_definition_id'] = job_definition_id
            path_args['jobDefinitionId'] = job_definition_id
            path = '/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def batch_prediction_job_definitions_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List Batch Prediction job definitions

            List all Batch Prediction jobs definitions available
            Args:
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 100, must be one of [100]

            Keyword Args:
                deployment_id (str): Includes only definitions for this particular deployment. [optional]
            Returns:
                BatchPredictionJobDefinitionsListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/batchPredictionJobDefinitions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobDefinitionsListResponse(**server_data)

        @classmethod
        def batch_prediction_job_definitions_patch(
            cls,
            job_definition_id,
            **kwargs
        ):
            """Update Batch Prediction job definition

            Update a Batch Prediction job definition
            Args:
                job_definition_id (str): ID of the Batch Prediction job definition

            Keyword Args:
                batch_prediction_job_definitions_update (BatchPredictionJobDefinitionsUpdate): [optional]
            Returns:
                BatchPredictionJobDefinitionsResponse
            """
            path_args = {}
            kwargs['job_definition_id'] = job_definition_id
            path_args['jobDefinitionId'] = job_definition_id
            path = '/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobDefinitionsResponse(**server_data)

        @classmethod
        def batch_prediction_job_definitions_portable_list(
            cls,
            job_definition_id,
            **kwargs
        ):
            """Retrieve job definition snippet for PBP

            Retrieve a Batch Prediction job definition for Portable Batch Predictions
            Args:
                job_definition_id (str): ID of the Batch Prediction job definition

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['job_definition_id'] = job_definition_id
            path_args['jobDefinitionId'] = job_definition_id
            path = '/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/portable/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def batch_prediction_job_definitions_retrieve(
            cls,
            job_definition_id,
            **kwargs
        ):
            """Retrieve Batch Prediction job definition

            Retrieve a Batch Prediction job definition
            Args:
                job_definition_id (str): ID of the Batch Prediction job definition

            Keyword Args:
            Returns:
                BatchPredictionJobDefinitionsResponse
            """
            path_args = {}
            kwargs['job_definition_id'] = job_definition_id
            path_args['jobDefinitionId'] = job_definition_id
            path = '/api/v2/batchPredictionJobDefinitions/{jobDefinitionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobDefinitionsResponse(**server_data)

        @classmethod
        def batch_predictions_create(
            cls,
            **kwargs
        ):
            """Creates a new Batch Prediction job

            Submit the configuration for the job and it will be submitted to the queue

            Keyword Args:
                batch_prediction_job_create (BatchPredictionJobCreate): [optional]
            Returns:
                BatchPredictionJobResponse
            """
            path_args = {}
            path = '/api/v2/batchPredictions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobResponse(**server_data)

        @classmethod
        def batch_predictions_csv_upload_put_many(
            cls,
            prediction_job_id,
            **kwargs
        ):
            """Creates a new_model_id Batch Prediction job

            Stream CSV data to the prediction job. Only available for jobs thatuses the localFile intake option.
            Args:
                prediction_job_id (str): ID of the Batch Prediction job

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['prediction_job_id'] = prediction_job_id
            path_args['predictionJobId'] = prediction_job_id
            path = '/api/v2/batchPredictions/{predictionJobId}/csvUpload/'.format(**path_args)
            cls._client.put(path)

        @classmethod
        def batch_predictions_delete(
            cls,
            prediction_job_id,
            **kwargs
        ):
            """Cancel a Batch Prediction job

            If the job is running, it will be aborted. Then it will be removed, meaning all underlying data will be deleted and the job is removed from the list of jobs.
            Args:
                prediction_job_id (str): ID of the Batch Prediction job

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['prediction_job_id'] = prediction_job_id
            path_args['predictionJobId'] = prediction_job_id
            path = '/api/v2/batchPredictions/{predictionJobId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def batch_predictions_download_list(
            cls,
            prediction_job_id,
            **kwargs
        ):
            """Download the scored data set of a batch prediction job

            This is only valid for jobs scored using the \"localFile\" output option
            Args:
                prediction_job_id (str): ID of the Batch Prediction job

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['prediction_job_id'] = prediction_job_id
            path_args['predictionJobId'] = prediction_job_id
            path = '/api/v2/batchPredictions/{predictionJobId}/download/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def batch_predictions_from_existing_create(
            cls,
            **kwargs
        ):
            """Create a new a Batch Prediction job based on an existing Batch Prediction job.

            Copies an existing job and submits it to the queue.

            Keyword Args:
                batch_prediction_job_id (BatchPredictionJobId): [optional]
            Returns:
                BatchPredictionJobResponse
            """
            path_args = {}
            path = '/api/v2/batchPredictions/fromExisting/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobResponse(**server_data)

        @classmethod
        def batch_predictions_from_job_definition_create(
            cls,
            **kwargs
        ):
            """Launch a Batch Prediction job for scoring

            Launches a one-time batch prediction job based off of the previously supplied definition referring to the job definition ID and puts it on the queue.

            Keyword Args:
                batch_prediction_job_definition_id (BatchPredictionJobDefinitionId): [optional]
            Returns:
                BatchPredictionJobResponse
            """
            path_args = {}
            path = '/api/v2/batchPredictions/fromJobDefinition/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobResponse(**server_data)

        @classmethod
        def batch_predictions_list(
            cls,
            offset=0,
            limit=100,
            all_jobs=False,
            **kwargs
        ):
            """List batch prediction jobs

            Get a collection of batch prediction jobs by statuses
            Args:
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 100, must be one of [100]
                all_jobs (bool): (For organization admins) Include jobs for all users in the organization.. defaults to False, must be one of [False]

            Keyword Args:
                status (bool, date, datetime, dict, float, int, list, str, none_type): Includes only jobs that have the status value that matches this flag. Repeat the parameter for filtering on multiple statuses.. [optional]
                source (bool, date, datetime, dict, float, int, list, str, none_type): Includes only jobs that have the source value that matches this flag. Repeat the parameter for filtering on multiple statuses.. [optional]
                deployment_id (str): Includes only jobs for this particular deployment. [optional]
                order_by (str): Sort order which will be applied to batch prediction list. Prefix the attribute name with a dash to sort in descending order, e.g. \"-created\".. [optional]
                cutoff_hours (int): Only list jobs created at most this amount of hours ago.. [optional]
                start_date_time (datetime): ISO-formatted datetime of the earliest time the job was added (inclusive). For example \"2008-08-24T12:00:00Z\". Will ignore cutoffHours if set.. [optional]
                end_date_time (datetime): ISO-formatted datetime of the latest time the job was added (inclusive). For example \"2008-08-24T12:00:00Z\".. [optional]
                batch_prediction_job_definition_id (str): Includes only jobs for this particular definition. [optional]
                hostname (bool, date, datetime, dict, float, int, list, str, none_type): Includes only jobs for this particular prediction instance hostname. [optional]
                intake_type (str): Includes only jobs for this particular intake type. [optional]
                output_type (str): Includes only jobs for this particular output type. [optional]
            Returns:
                BatchPredictionJobListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['all_jobs'] = all_jobs
            path_args['allJobs'] = all_jobs
            path = '/api/v2/batchPredictions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobListResponse(**server_data)

        @classmethod
        def batch_predictions_patch(
            cls,
            prediction_job_id,
            **kwargs
        ):
            """Update a Batch Prediction job

            If a job has finished execution regardless of the result, it can have parameters changed to ensure better filtering in the job list upon retrieval. Anotehr case: updating job scoring status extrenally.
            Args:
                prediction_job_id (str): ID of the Batch Prediction job

            Keyword Args:
                batch_prediction_job_update (BatchPredictionJobUpdate): [optional]
            Returns:
                BatchPredictionJobResponse
            """
            path_args = {}
            kwargs['prediction_job_id'] = prediction_job_id
            path_args['predictionJobId'] = prediction_job_id
            path = '/api/v2/batchPredictions/{predictionJobId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobResponse(**server_data)

        @classmethod
        def batch_predictions_retrieve(
            cls,
            prediction_job_id,
            **kwargs
        ):
            """Retrieve Batch Prediction job

            Retrieve a Batch Prediction job.
            Args:
                prediction_job_id (str): ID of the Batch Prediction job

            Keyword Args:
            Returns:
                BatchPredictionJobResponse
            """
            path_args = {}
            kwargs['prediction_job_id'] = prediction_job_id
            path_args['predictionJobId'] = prediction_job_id
            path = '/api/v2/batchPredictions/{predictionJobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return BatchPredictionJobResponse(**server_data)

        @classmethod
        def imported_models_create(
            cls,
            **kwargs
        ):
            """Import a previously exported DRX model to be served by SSE

            This route can be used on-prem to put a given DRX model into file storage so that it can be served by a Standalone Scoring Engine (SSE). Please note however that for this to work SSE needs to be configured to use the same file storage as the main Datarbot application (namely, Public API).

            Keyword Args:
                single_model_file_payload (SingleModelFilePayload): [optional]
            Returns:
                dict
            """
            path_args = {}
            path = '/api/v2/importedModels/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def imported_models_delete(
            cls,
            import_id,
            **kwargs
        ):
            """Delete imported by from storage along with all its metadata

            Delete previously imported DRX models from storage along with all its metadata. This deletion is permanent and cannot be reverted, but the one can export the original model and import it again.
            Args:
                import_id (str): Unique identifier of the imported model

            Keyword Args:
            Returns:
                dict
            """
            path_args = {}
            kwargs['import_id'] = import_id
            path_args['importId'] = import_id
            path = '/api/v2/importedModels/{importId}/'.format(**path_args)
            server_data = (cls._client.delete(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return server_data

        @classmethod
        def imported_models_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """Lists imported models optionally filtering them by a string query

            Lists imported models optionally filtering them by a string query.
            Args:
                offset (int): The number of records to skip over. Non-negative, defaults to 0. defaults to 0, must be one of [0]
                limit (int): The number of records to return. Positive, defaults to 100. defaults to 100, must be one of [100]

            Keyword Args:
                query (str, none_type): A case-insensitive search term to filter returned models. The searchable fields are: `model_id`, `model_name`, `display_name`, `dataset_name`, `project_id`, `project_name`, `target`, `note`, `featurelist_name`, `created_by_id`, `created_by_username`. Search also looks at the first and last name of the user who imported the model. The partially matched models are counted, so for example the search term `train` would find models with name `TuesdayTrainingData`. [optional]
            Returns:
                ImportedModelListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/importedModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImportedModelListResponse(**server_data)

        @classmethod
        def imported_models_patch(
            cls,
            import_id,
            **kwargs
        ):
            """Allows updating some of the imported DRX model metadata fields

            Update some of the imported DRX model metadata fields.
            Args:
                import_id (str): Unique identifier of the imported model

            Keyword Args:
                imorted_model_update_payload (ImortedModelUpdatePayload): [optional]
            Returns:
                dict
            """
            path_args = {}
            kwargs['import_id'] = import_id
            path_args['importId'] = import_id
            path = '/api/v2/importedModels/{importId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def imported_models_put(
            cls,
            import_id,
            **kwargs
        ):
            """Replace an already imported DRX model with a new one

            Replace an already imported model. The model specified by `importId` will be replaced with the model binary provided and the old model will no longer be available at this location.
            Args:
                import_id (str): Unique identifier of the imported model

            Keyword Args:
                single_model_file_payload (SingleModelFilePayload): [optional]
            Returns:
                dict
            """
            path_args = {}
            kwargs['import_id'] = import_id
            path_args['importId'] = import_id
            path = '/api/v2/importedModels/{importId}/'.format(**path_args)
            server_data = (cls._client.put(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def imported_models_retrieve(
            cls,
            import_id,
            **kwargs
        ):
            """Get imported DRX model details

            Retrieve imported model metadata.
            Args:
                import_id (str): Unique identifier of the imported model

            Keyword Args:
            Returns:
                ImportedModelRetrieveResponse
            """
            path_args = {}
            kwargs['import_id'] = import_id
            path_args['importId'] = import_id
            path = '/api/v2/importedModels/{importId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ImportedModelRetrieveResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_create(
            cls,
            **kwargs
        ):
            """Create configuration for a scheduled prediction integration job

            Create configuration for scheduled prediction integration job.

            Keyword Args:
                prediction_integration_job_create_payload (PredictionIntegrationJobCreatePayload): [optional]
            Returns:
                PredictionIntegrationJobResponse
            """
            path_args = {}
            path = '/api/v2/predictionIntegrationJobs/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_job_runs_history_list(
            cls,
            prediction_integration_job_id,
            **kwargs
        ):
            """Get a list of a job runs with their details

            Get a list of a job runs with their details
            Args:
                prediction_integration_job_id (str): Id of the prediction integration job

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
                order_by (str): The order to sort the scheduled jobs. Defaults to order by created timestamp in descending order.. [optional] if omitted the server will use the default value of "-created"
            Returns:
                PredictionIntegrationJobRunsHistoryResponse
            """
            path_args = {}
            kwargs['prediction_integration_job_id'] = prediction_integration_job_id
            path_args['predictionIntegrationJobId'] = prediction_integration_job_id
            path = '/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobRunsHistoryResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_job_runs_history_logs_list(
            cls,
            prediction_integration_job_id,
            job_run_id,
            **kwargs
        ):
            """Get a list of a specific job run's logs

            Get a list of a specific job run's logs
            Args:
                prediction_integration_job_id (str): Id of the prediction integration job
                job_run_id (str): ID of a specific run of a job

            Keyword Args:
            Returns:
                PredictionIntegrationJobLogsRetrieveResponse
            """
            path_args = {}
            kwargs['prediction_integration_job_id'] = prediction_integration_job_id
            path_args['predictionIntegrationJobId'] = prediction_integration_job_id
            kwargs['job_run_id'] = job_run_id
            path_args['jobRunId'] = job_run_id
            path = '/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/{jobRunId}/logs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobLogsRetrieveResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_job_runs_history_retrieve(
            cls,
            prediction_integration_job_id,
            job_run_id,
            **kwargs
        ):
            """Get a single job run details

            Get a single job run details
            Args:
                prediction_integration_job_id (str): Id of the prediction integration job
                job_run_id (str): ID of a specific run of a job

            Keyword Args:
            Returns:
                PredictionIntegrationJobRunHistoryResponse
            """
            path_args = {}
            kwargs['prediction_integration_job_id'] = prediction_integration_job_id
            path_args['predictionIntegrationJobId'] = prediction_integration_job_id
            kwargs['job_run_id'] = job_run_id
            path_args['jobRunId'] = job_run_id
            path = '/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/jobRunsHistory/{jobRunId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobRunHistoryResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_patch(
            cls,
            prediction_integration_job_id,
            **kwargs
        ):
            """Update configuration for a scheduled prediction integration job

            Update configuration for a scheduled prediction integration job
            Args:
                prediction_integration_job_id (str): Id of the prediction integration job

            Keyword Args:
                prediction_integration_job_update (PredictionIntegrationJobUpdate): [optional]
            Returns:
                PredictionIntegrationJobResponse
            """
            path_args = {}
            kwargs['prediction_integration_job_id'] = prediction_integration_job_id
            path_args['predictionIntegrationJobId'] = prediction_integration_job_id
            path = '/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobResponse(**server_data)

        @classmethod
        def prediction_integration_jobs_retrieve(
            cls,
            prediction_integration_job_id,
            **kwargs
        ):
            """Retrieves configuration of a scheduled prediction integration integration job

            Retrieves configuration of a scheduled prediction integration integration job
            Args:
                prediction_integration_job_id (str): Id of the prediction integration job

            Keyword Args:
            Returns:
                PredictionIntegrationJobResponse
            """
            path_args = {}
            kwargs['prediction_integration_job_id'] = prediction_integration_job_id
            path_args['predictionIntegrationJobId'] = prediction_integration_job_id
            path = '/api/v2/predictionIntegrationJobs/{predictionIntegrationJobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionIntegrationJobResponse(**server_data)

        @classmethod
        def projects_models_prediction_explanations_initialization_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Create a new prediction explanations initialization.

            Create a new prediction explanations initialization. This is a necessary prerequisite for generating prediction explanations.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                prediction_explanations_initialization_create (PredictionExplanationsInitializationCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_models_prediction_explanations_initialization_delete_many(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Delete an existing PredictionExplanationsInitialization.

            Delete an existing PredictionExplanationsInitialization.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_models_prediction_explanations_initialization_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the current PredictionExplanationsInitialization.

            Retrieve the current PredictionExplanationsInitialization. A PredictionExplanationsInitialization is a pre-requisite for successfully computing prediction explanations using a particular model, and can be used to preview the prediction explanations that would be generated for a complete dataset.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                exclude_adjusted_predictions (str): Whether to include adjusted prediction in the PredictionExplanationsSample response.. [optional] if omitted the server will use the default value of "true"
                prediction_explanations_initialization_retrieve (PredictionExplanationsInitializationRetrieve): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/models/{modelId}/predictionExplanationsInitialization/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_predict_jobs_delete(
            cls,
            project_id,
            job_id,
            **kwargs
        ):
            """Cancel a queued prediction job

            Cancel a queued prediction job
            Args:
                project_id (str): The project ID.
                job_id (str): The job ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/projects/{projectId}/predictJobs/{jobId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_predict_jobs_list(
            cls,
            project_id,
            **kwargs
        ):
            """List all prediction jobs for a project

            List all prediction jobs for a project
            Args:
                project_id (str): The project ID.

            Keyword Args:
                status (str): If provided, only jobs with the same status will be included in the results; otherwise, queued and inprogress jobs (but not errored jobs) will be returned.. [optional]
            Returns:
                PredictJobDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictJobs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictJobDetailsResponse(**server_data)

        @classmethod
        def projects_predict_jobs_retrieve(
            cls,
            project_id,
            job_id,
            **kwargs
        ):
            """Look up a particular prediction job

            Look up a particular prediction job
            Args:
                project_id (str): The project ID.
                job_id (str): The job ID

            Keyword Args:
            Returns:
                PredictJobDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/projects/{projectId}/predictJobs/{jobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictJobDetailsResponse(**server_data)

        @classmethod
        def projects_prediction_datasets_data_source_uploads_create(
            cls,
            project_id,
            **kwargs
        ):
            """Upload a dataset for predictions from a ``DataSource``.

            Upload a dataset for predictions from a ``DataSource``.
            Args:
                project_id (str): The project ID to which the data source will be uploaded to.

            Keyword Args:
                prediction_data_source (PredictionDataSource): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/dataSourceUploads/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prediction_datasets_dataset_uploads_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create prediction dataset

            Create a prediction dataset from a Dataset Item in the catalog.
            Args:
                project_id (str): The project ID.

            Keyword Args:
                prediction_from_catalog_dataset (PredictionFromCatalogDataset): [optional]
            Returns:
                CreatePredictionDatasetResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/datasetUploads/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreatePredictionDatasetResponse(**server_data)

        @classmethod
        def projects_prediction_datasets_delete(
            cls,
            project_id,
            dataset_id,
            **kwargs
        ):
            """Delete a dataset that was uploaded for prediction.

            Delete a dataset that was uploaded for prediction.
            Args:
                project_id (str): The project ID that owns the data.
                dataset_id (str): The dataset ID to delete.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/{datasetId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_prediction_datasets_file_uploads_create(
            cls,
            project_id,
            **kwargs
        ):
            """Upload a file for predictions from an attached file.

            Upload a file for predictions from an attached file.
            Args:
                project_id (str): The project ID to which the data will be uploaded for prediction.

            Keyword Args:
                prediction_file_upload (PredictionFileUpload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/fileUploads/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prediction_datasets_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List predictions datasets uploaded to a project.

            List predictions datasets uploaded to a project.
            Args:
                project_id (str): The project ID to query.
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                PredictionDatasetListControllerResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionDatasetListControllerResponse(**server_data)

        @classmethod
        def projects_prediction_datasets_retrieve(
            cls,
            project_id,
            dataset_id,
            **kwargs
        ):
            """Get the metadata of a specific dataset. This only works for datasets uploaded to an existing project for prediction.

            Get the metadata of a specific dataset. This only works for datasets uploaded to an existing project for prediction.
            Args:
                project_id (str): The project ID that owns the data.
                dataset_id (str): The dataset ID to query for.

            Keyword Args:
            Returns:
                PredictionDatasetRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['dataset_id'] = dataset_id
            path_args['datasetId'] = dataset_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/{datasetId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionDatasetRetrieveResponse(**server_data)

        @classmethod
        def projects_prediction_datasets_url_uploads_create(
            cls,
            project_id,
            **kwargs
        ):
            """Upload a file for predictions from a URL.

            Upload a file for predictions from a URL.
            Args:
                project_id (str): The project ID to which the data will be uploaded for prediction.

            Keyword Args:
                prediction_url_upload (PredictionURLUpload): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionDatasets/urlUploads/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prediction_explanations_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create a new PredictionExplanations object (and its accompanying PredictionExplanationsRecord).

            Create a new PredictionExplanations object (and its accompanying PredictionExplanationsRecord). In order to successfully create PredictionExplanations for a particular model and dataset, you must first - Compute feature impact for the model via :http:post:`/api/v2/projects/(projectId)/models/(modelId)/featureImpact/` - Compute a PredictionExplanationsInitialization for the model via :http:post:`/api/v2/projects/(projectId)/models/(modelId)/predictionExplanationsInitialization/` - Compute predictions for the model and dataset via :http:post:`/api/v2/projects/(projectId)/predictions/` `thresholdHigh` and `thresholdLow` are optional filters applied to speed up computation. When at least one is specified, only the selected outlier rows will have prediction explanations computed. Rows are considered to be outliers if their predicted value (in case of regression projects) or probability of being the positive class (in case of classification projects) isless than `thresholdLow` or greater than `thresholdHigh`. If neither is specified, prediction explanations will be computed for all rows.
            Args:
                project_id (str): The project ID

            Keyword Args:
                prediction_explanations_create (PredictionExplanationsCreate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionExplanations/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_prediction_explanations_records_delete(
            cls,
            project_id,
            prediction_explanations_id,
            **kwargs
        ):
            """Delete saved Prediction Explanations.

            Delete saved Prediction Explanations. Deletes both the actual prediction explanations and the corresponding PredictionExplanationsRecord.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def projects_prediction_explanations_records_list(
            cls,
            project_id,
            **kwargs
        ):
            """List PredictionExplanationsRecord objects for a project.

            List PredictionExplanationsRecord objects for a project. These contain metadata about the computed prediction explanations and the location at which the PredictionExplanations can be retrieved.
            Args:
                project_id (str): The project ID

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
                model_id (str): If specified, only prediction explanations records computed for this model will be returned.. [optional]
            Returns:
                PredictionExplanationsRecordList
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionExplanationsRecordList(**server_data)

        @classmethod
        def projects_prediction_explanations_records_retrieve(
            cls,
            project_id,
            prediction_explanations_id,
            **kwargs
        ):
            """Retrieve a PredictionExplanationsRecord object.

            Retrieve a PredictionExplanationsRecord object. A PredictionExplanationsRecord contains metadata about the computed prediction explanations and the location at which the PredictionExplanations can be retrieved.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.

            Keyword Args:
                prediction_explanations_record (PredictionExplanationsRecord): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanationsRecords/{predictionExplanationsId}/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_prediction_explanations_retrieve(
            cls,
            project_id,
            prediction_explanations_id,
            limit=300000,
            **kwargs
        ):
            """Retrieve stored Prediction Explanations.

            Retrieve stored Prediction Explanations. Each PredictionExplanationsRow retrieved corresponds to a row of the prediction dataset, although some rows may not have had prediction explanations computed depending on the thresholds selected.
            Args:
                project_id (str): The project ID
                prediction_explanations_id (str): The ID of the PredictionExplanationsRecord to retrieve.
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. defaults to 300000, must be one of [300000]

            Keyword Args:
                offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
                exclude_adjusted_predictions (str): Whether to include adjusted prediction in PredictionExplanationsRow response.. [optional] if omitted the server will use the default value of "true"
                prediction_explanations_retrieve (PredictionExplanationsRetrieve): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_explanations_id'] = prediction_explanations_id
            path_args['predictionExplanationsId'] = prediction_explanations_id
            path = '/api/v2/projects/{projectId}/predictionExplanations/{predictionExplanationsId}/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_predictions_create(
            cls,
            project_id,
            content_type,
            **kwargs
        ):
            """Make new predictions.

            There are two ways of making predictions.  The recommended way is to first upload your dataset to the project, and then using the corresponding datasetId, predict against that dataset. To follow that pattern, send the json request body.  Note that requesting prediction intervals will automatically trigger backtesting if backtests were not already completed for this model.  The legacy method which is deprecated is to send the file directly with the predictions request.  If you need to predict against a file 10MB in size or larger, you will be required to use the above workflow for uploaded datasets. However, the following multipart/form-data can be used with small files:  :form file: a dataset to make predictions on :form modelId: the model to use to make predictions  .. note:: If using the legacy method of uploading data to this endpoint, a new dataset    will be created behind the scenes. For performance reasons, it would be much better    to utilize the workflow of creating the dataset first and using the supported method    of making predictions of this endpoint. However, to preserve the functionality of    existing workflows, the legacy method still exists. 
            Args:
                project_id (str): The project to make predictions within.
                content_type (str): Content types available for making request. `multipart/form-data` is the legacy deprecated method to send the small file with the prediction request.

            Keyword Args:
                create_prediction_from_dataset (CreatePredictionFromDataset): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['content_type'] = content_type
            path_args['contentType'] = content_type
            path = '/api/v2/projects/{projectId}/predictions/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_predictions_list(
            cls,
            project_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """Get a list of prediction records.

            Get a list of prediction records.  .. deprecated:: v2.21     Use :http:get:`/api/v2/projects/(projectId)/predictionsMetadata/` instead. The only     difference is that parameter `datasetId` is renamed to `predictionDatasetId`     both in request and response. 
            Args:
                project_id (str): The project of the predictions.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. defaults to 1000, must be one of [1000]

            Keyword Args:
                dataset_id (str): Dataset id used to create the predictions. [optional]
                model_id (str): Model id. [optional]
            Returns:
                RetrieveListPredictionMetadataObjectsResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RetrieveListPredictionMetadataObjectsResponse(**server_data)

        @classmethod
        def projects_predictions_metadata_list(
            cls,
            project_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """Get a list of prediction metadata records.

            Use the ID of a metadata object to get the complete set of predictions.
            Args:
                project_id (str): The project of the predictions.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. defaults to 1000, must be one of [1000]

            Keyword Args:
                prediction_dataset_id (str): Dataset id used to create the predictions. [optional]
                model_id (str): Model id. [optional]
            Returns:
                RetrieveListPredictionMetadataObjectsResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionsMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RetrieveListPredictionMetadataObjectsResponse(**server_data)

        @classmethod
        def projects_predictions_metadata_retrieve(
            cls,
            prediction_id,
            project_id,
            **kwargs
        ):
            """Retrieve metadata for a set of predictions.

            Use the ID of a metadata object to get the complete set of predictions.
            Args:
                prediction_id (str): The id of the prediction record to retrieve. If you have the jobId, you can retrieve the predictionId using :http:get:`/api/v2/projects/(projectId)/predictJobs/(jobId)/`.
                project_id (str): The id of the project the prediction belongs to.

            Keyword Args:
            Returns:
                RetrievePredictionMetadataObject
            """
            path_args = {}
            kwargs['prediction_id'] = prediction_id
            path_args['predictionId'] = prediction_id
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionsMetadata/{predictionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RetrievePredictionMetadataObject(**server_data)

        @classmethod
        def projects_predictions_retrieve(
            cls,
            prediction_id,
            project_id,
            **kwargs
        ):
            """Get a completed set of predictions.

            Retrieve predictions that have previously been computed. Training predictions encoded either as JSON or CSV. If CSV output was requested, the returned CSV data will contain the following columns:  * For regression projects: `row_id` and `prediction`. * For binary classification projects: `row_id`, `prediction`,   `class_<positive_class_label>` and `class_<negative_class_label>`. * For multi classification projects: `row_id`, `prediction` and a   `class_<class_label>` for each class. * For time-series, these additional columns will be added: `forecast_point`,   `forecast_distance`, `timestamp`, and `series_id`.  .. minversion:: v2.21      * If `explanationAlgorithm` = 'shap', these additional columns will be added:       triplets of (`Explanation_<i>_feature_name`,       `Explanation_<i>_feature_value`, and `Explanation_<i>_strength`) for `i` ranging       from 1 to `maxExplanations`, `shap_remaining_total` and `shap_base_value`. Binary       classification projects will also have `explained_class`, the class for which       positive SHAP values imply an increased probability. 
            Args:
                prediction_id (str): The id of the prediction record to retrieve. If you have the jobId, you can retrieve the predictionId using :http:get:`/api/v2/projects/(projectId)/predictJobs/(jobId)/`.
                project_id (str): The id of the project the prediction belongs to.

            Keyword Args:
                shap_multiclass_level (str): Required in multiclass projects with SHAP prediction explanations. This parameter specifies which of the target classes (levels) you would like to retrieve explanations for. This will NOT affect a non-multiclass project.. [optional]
                accept (str): Requested MIME type for the returned data. [optional]
            Returns:
                PredictionRetrieveResponse
            """
            path_args = {}
            kwargs['prediction_id'] = prediction_id
            path_args['predictionId'] = prediction_id
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictions/{predictionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionRetrieveResponse(**server_data)

        @classmethod
        def projects_training_predictions_create(
            cls,
            project_id,
            **kwargs
        ):
            """Submits a job to compute predictions for training data

            Create training data predictions
            Args:
                project_id (str): Project ID to compute training predictions for

            Keyword Args:
                create_training_prediction (CreateTrainingPrediction): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/trainingPredictions/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_training_predictions_list(
            cls,
            project_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List training prediction jobs

            Get a list of training prediction records
            Args:
                project_id (str): Project ID to retrieve training predictions for
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                TrainingPredictionsListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/trainingPredictions/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return TrainingPredictionsListResponse(**server_data)

        @classmethod
        def projects_training_predictions_retrieve(
            cls,
            project_id,
            prediction_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """Retrieve training predictions

            Retrieve training predictions that have previously been computed
            Args:
                project_id (str): Project ID to retrieve training predictions for
                prediction_id (str): Prediction ID to retrieve training predictions for
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 0, must be one of [0]

            Keyword Args:
                accept (str): Requested MIME type for the returned data. [optional]
            Returns:
                TrainingPredictionsRetrieveResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['prediction_id'] = prediction_id
            path_args['predictionId'] = prediction_id
            path = '/api/v2/projects/{projectId}/trainingPredictions/{predictionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return TrainingPredictionsRetrieveResponse(**server_data)

        @classmethod
        def scheduled_jobs_delete(
            cls,
            job_id,
            **kwargs
        ):
            """Delete scheduled job

            Delete scheduled job
            Args:
                job_id (str): The ID of the job being requested.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/scheduledJobs/{jobId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def scheduled_jobs_list(
            cls,
            offset=0,
            limit=20,
            **kwargs
        ):
            """List scheduled deployment batch prediction jobs a user can view

            Get a list of scheduled batch prediction jobs a user can view
            Args:
                offset (int): The number of scheduled jobs to skip. Defaults to 0.. defaults to 0, must be one of [0]
                limit (int): The number of scheduled jobs (max 100) to return. Defaults to 20. defaults to 20, must be one of [20]

            Keyword Args:
                order_by (str): The order to sort the scheduled jobs. Defaults to order by last successful run timestamp in descending order.. [optional] if omitted the server will use the default value of "name"
                search (str): Case insensitive search against scheduled jobs name or type name.. [optional] if omitted the server will use the default value of ""
                deployment_id (str): Filter by the prediction integration deployment ID. Ignored for non prediction integration type ID.. [optional]
                type_id (str): filter by scheduled job type ID.. [optional] if omitted the server will use the default value of "predictionIntegration"
                integration_type_name (str): filter by integration type name.. [optional]
                query_by_user (str): Which user field to filter with.. [optional] if omitted the server will use the default value of "createdBy"
                filter_enabled (str): Filter jobs using the enabled field. If `true`, only enabled jobs are returned, otherwise if `false`, only disabled jobs are returned. The default returns both enabled and disabled jobs.. [optional]
            Returns:
                ScheduledJobsListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/scheduledJobs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ScheduledJobsListResponse(**server_data)

        @classmethod
        def scheduled_jobs_patch(
            cls,
            job_id,
            **kwargs
        ):
            """Run or stop a previously created scheduled integration job

            Run or stop a previously created scheduled integration job
            Args:
                job_id (str): The ID of the job being requested.

            Keyword Args:
                scheduled_job_run_stop (ScheduledJobRunStop): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/scheduledJobs/{jobId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def scheduled_jobs_retrieve(
            cls,
            job_id,
            **kwargs
        ):
            """List a single deployment batch prediction job

            Get a scheduled batch prediction job
            Args:
                job_id (str): The ID of the job being requested.

            Keyword Args:
            Returns:
                ScheduledJobResponse
            """
            path_args = {}
            kwargs['job_id'] = job_id
            path_args['jobId'] = job_id
            path = '/api/v2/scheduledJobs/{jobId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ScheduledJobResponse(**server_data)

