#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.retrieve_list_prediction_metadata_objects_response import RetrieveListPredictionMetadataObjectsResponse
from datarobot.models.full_api.generated.model.retrieve_prediction_metadata_object import RetrievePredictionMetadataObject


class PredictionsMetadataApi(APIObject):

        @classmethod
        def projects_predictions_metadata_list(
            cls,
            project_id,
            offset=0,
            limit=1000,
            **kwargs
        ):
            """Get a list of prediction metadata records.

            Use the ID of a metadata object to get the complete set of predictions.
            Args:
                project_id (str): The project of the predictions.
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. defaults to 1000, must be one of [1000]

            Keyword Args:
                prediction_dataset_id (str): Dataset id used to create the predictions. [optional]
                model_id (str): Model id. [optional]
            Returns:
                RetrieveListPredictionMetadataObjectsResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionsMetadata/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RetrieveListPredictionMetadataObjectsResponse(**server_data)

        @classmethod
        def projects_predictions_metadata_retrieve(
            cls,
            prediction_id,
            project_id,
            **kwargs
        ):
            """Retrieve metadata for a set of predictions.

            Use the ID of a metadata object to get the complete set of predictions.
            Args:
                prediction_id (str): The id of the prediction record to retrieve. If you have the jobId, you can retrieve the predictionId using :http:get:`/api/v2/projects/(projectId)/predictJobs/(jobId)/`.
                project_id (str): The id of the project the prediction belongs to.

            Keyword Args:
            Returns:
                RetrievePredictionMetadataObject
            """
            path_args = {}
            kwargs['prediction_id'] = prediction_id
            path_args['predictionId'] = prediction_id
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/predictionsMetadata/{predictionId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RetrievePredictionMetadataObject(**server_data)

