#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.aim import Aim
from datarobot.models.full_api.generated.model.autopilot import Autopilot
from datarobot.models.full_api.generated.model.autopilot_start import AutopilotStart
from datarobot.models.full_api.generated.model.cross_series_group_by_column_retrieve_response import (
    CrossSeriesGroupByColumnRetrieveResponse,
)
from datarobot.models.full_api.generated.model.cross_series_group_by_column_validate_payload import (
    CrossSeriesGroupByColumnValidatePayload,
)
from datarobot.models.full_api.generated.model.cross_series_group_by_column_validate_response import (
    CrossSeriesGroupByColumnValidateResponse,
)
from datarobot.models.full_api.generated.model.deleted_project_count_response import (
    DeletedProjectCountResponse,
)
from datarobot.models.full_api.generated.model.deleted_project_list_response import (
    DeletedProjectListResponse,
)
from datarobot.models.full_api.generated.model.external_ts_baseline_payload import (
    ExternalTSBaselinePayload,
)
from datarobot.models.full_api.generated.model.external_ts_baseline_response import (
    ExternalTSBaselineResponse,
)
from datarobot.models.full_api.generated.model.hdfs_project_create import HdfsProjectCreate
from datarobot.models.full_api.generated.model.job_details_response import JobDetailsResponse
from datarobot.models.full_api.generated.model.job_list_response import JobListResponse
from datarobot.models.full_api.generated.model.multiseries_payload import MultiseriesPayload
from datarobot.models.full_api.generated.model.multiseries_retrieve_response import (
    MultiseriesRetrieveResponse,
)
from datarobot.models.full_api.generated.model.project_clone import ProjectClone
from datarobot.models.full_api.generated.model.project_create import ProjectCreate
from datarobot.models.full_api.generated.model.project_create_response import ProjectCreateResponse
from datarobot.models.full_api.generated.model.project_details_response import (
    ProjectDetailsResponse,
)
from datarobot.models.full_api.generated.model.project_nuke import ProjectNuke
from datarobot.models.full_api.generated.model.project_nuke_job_list_status import (
    ProjectNukeJobListStatus,
)
from datarobot.models.full_api.generated.model.project_nuke_job_status import ProjectNukeJobStatus
from datarobot.models.full_api.generated.model.project_nuke_job_status_summary import (
    ProjectNukeJobStatusSummary,
)
from datarobot.models.full_api.generated.model.project_recover import ProjectRecover
from datarobot.models.full_api.generated.model.project_recover_response import (
    ProjectRecoverResponse,
)
from datarobot.models.full_api.generated.model.project_retrieve_response import (
    ProjectRetrieveResponse,
)
from datarobot.models.full_api.generated.model.project_secondary_dataset_config_response import (
    ProjectSecondaryDatasetConfigResponse,
)
from datarobot.models.full_api.generated.model.project_status_response import ProjectStatusResponse
from datarobot.models.full_api.generated.model.project_update import ProjectUpdate
from datarobot.models.full_api.generated.model.relationships_config_response import (
    RelationshipsConfigResponse,
)
from datarobot.models.full_api.generated.model.secondary_dataset_config_list_response import (
    SecondaryDatasetConfigListResponse,
)
from datarobot.models.full_api.generated.model.secondary_dataset_create import (
    SecondaryDatasetCreate,
)
from datarobot.models.full_api.generated.model.sharing_list_response import SharingListResponse
from datarobot.models.full_api.generated.model.sharing_update_or_remove import SharingUpdateOrRemove


class ProjectsApi(APIObject):
    @classmethod
    def deleted_projects_count_list(cls, **kwargs):
        """Count soft-deleted projects.

        Get current number of deleted projects matching search criteria. Value is limited by DELETED_PROJECTS_BATCH_LIMIT system setting. That means that the actual amount of deleted projects can be greater than the limit, but counting will stop when reaching it.

        Keyword Args:
            search_for (str): Project or dataset name to filter by. [optional]
            creator (str): Creator ID to filter projects by. [optional]
            organization (str): ID of organization that projects should belong to. Given project belongs to the organization the user who created the project is part of that organization.If there are no users in organization, then no projects will match the query.. [optional]
            deleted_before (datetime): ISO-8601 formatted date projects were deleted before. [optional]
            deleted_after (datetime): ISO-8601 formatted date projects were deleted after. [optional]
            project_id (str): Project ID to search. [optional]
            limit (int): Count deleted projects until specified value reached.. [optional]
        Returns:
            DeletedProjectCountResponse
        """
        path_args = {}
        path = "/api/v2/deletedProjectsCount/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return DeletedProjectCountResponse(**server_data)

    @classmethod
    def deleted_projects_list(cls, **kwargs):
        """Retrieve a list of soft-deleted projects

        Retrieve a list of soft-deleted projects matching search criteria

        Keyword Args:
            search_for (str): Project or dataset name to filter by. [optional]
            creator (str): Creator ID to filter projects by. [optional]
            organization (str): ID of organization that projects should belong to. Given project belongs to the organization the user who created the project is part of that organization.If there are no users in organization, then no projects will match the query.. [optional]
            deleted_before (datetime): ISO-8601 formatted date projects were deleted before. [optional]
            deleted_after (datetime): ISO-8601 formatted date projects were deleted after. [optional]
            project_id (str): Project ID to search. [optional]
            limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 20
            offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
            order_by (str): Order deleted projects by. [optional] if omitted the server will use the default value of "deletedOn"
        Returns:
            DeletedProjectListResponse
        """
        path_args = {}
        path = "/api/v2/deletedProjects/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return DeletedProjectListResponse(**server_data)

    @classmethod
    def deleted_projects_patch(cls, project_id, **kwargs):
        """Recover soft-deleted project

        Recover (undelete) soft-deleted project
        Args:
            project_id (str): The project ID.

        Keyword Args:
            project_recover (ProjectRecover): [optional]
        Returns:
            ProjectRecoverResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/deletedProjects/{projectId}/".format(**path_args)
        server_data = (cls._client.patch(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectRecoverResponse(**server_data)

    @classmethod
    def hdfs_projects_create(cls, **kwargs):
        """Create a project from an HDFS file source.

        Create a project from an HDFS file via WebHDFS API. Represent the file using URL, optionally, port, and optionally, user/password credentials. For example, `{\"url\": \"hdfs://<ip>/path/to/file.csv\", \"port\": \"50070\"}`.

        Keyword Args:
            hdfs_project_create (HdfsProjectCreate): [optional]
        Returns:
            ProjectCreateResponse
        """
        path_args = {}
        path = "/api/v2/hdfsProjects/".format(**path_args)
        server_data = (cls._client.post(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectCreateResponse(**server_data)

    @classmethod
    def project_cleanup_jobs_create(cls, **kwargs):
        """Schedule Project Permadelete Job

        Add list of projects to permadelete and returns async status

        Keyword Args:
            project_nuke (ProjectNuke): [optional]
        Returns:
            None
        """
        path_args = {}
        path = "/api/v2/projectCleanupJobs/".format(**path_args)
        cls._client.post(path, data=kwargs)

    @classmethod
    def project_cleanup_jobs_delete(cls, status_id, **kwargs):
        """Cancel Scheduled Project Permadelete Job

        Stop permadelete job, if possible
        Args:
            status_id (str): The ID of the status object.

        Keyword Args:
        Returns:
            None
        """
        path_args = {}
        kwargs["status_id"] = status_id
        path_args["statusId"] = status_id
        path = "/api/v2/projectCleanupJobs/{statusId}/".format(**path_args)
        cls._client.delete(path)

    @classmethod
    def project_cleanup_jobs_download_list(cls, status_id, **kwargs):
        """Download a projects permadeletion report.

        Get a file containing a per-project report of permanent deletion.
        Args:
            status_id (str): The ID of the status object.

        Keyword Args:
        Returns:
            ProjectNukeJobStatus
        """
        path_args = {}
        kwargs["status_id"] = status_id
        path_args["statusId"] = status_id
        path = "/api/v2/projectCleanupJobs/{statusId}/download/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectNukeJobStatus(**server_data)

    @classmethod
    def project_cleanup_jobs_list(cls, **kwargs):
        """Retrieve Project Permadelete job status

        Get async status of the project permadelete job

        Keyword Args:
        Returns:
            ProjectNukeJobListStatus
        """
        path_args = {}
        path = "/api/v2/projectCleanupJobs/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectNukeJobListStatus(**server_data)

    @classmethod
    def project_cleanup_jobs_retrieve(cls, status_id, **kwargs):
        """Retrieve Project Permadelete job status

        Get async status of the project permadelete job
        Args:
            status_id (str): The ID of the status object.

        Keyword Args:
        Returns:
            ProjectNukeJobStatus
        """
        path_args = {}
        kwargs["status_id"] = status_id
        path_args["statusId"] = status_id
        path = "/api/v2/projectCleanupJobs/{statusId}/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectNukeJobStatus(**server_data)

    @classmethod
    def project_cleanup_jobs_summary_list(cls, status_id, **kwargs):
        """Get a projects cleanup jobs summary.

        Get number of projects whose deletion finished in particular state
        Args:
            status_id (str): The ID of the status object.

        Keyword Args:
        Returns:
            ProjectNukeJobStatusSummary
        """
        path_args = {}
        kwargs["status_id"] = status_id
        path_args["statusId"] = status_id
        path = "/api/v2/projectCleanupJobs/{statusId}/summary/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectNukeJobStatusSummary(**server_data)

    @classmethod
    def project_clones_create(cls, **kwargs):
        """Clone a project

             Create a clone of an existing project.      The resultant project will begin the initial exploratory     data analysis and will be ready to set the target of the new project shortly.

        Keyword Args:
            project_clone (ProjectClone): [optional]
        Returns:
            ProjectCreateResponse
        """
        path_args = {}
        path = "/api/v2/projectClones/".format(**path_args)
        server_data = (cls._client.post(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectCreateResponse(**server_data)

    @classmethod
    def projects_access_control_list(cls, project_id, offset=0, limit=0, **kwargs):
        """Get project's access control list

        Get a list of users who have access to this project and their roles on the project.
        Args:
            project_id (str): The project ID
            offset (int): This many results will be skipped. defaults to 0, must be one of [0]
            limit (int): At most this many results are returned. defaults to 0, must be one of [0]

        Keyword Args:
            username (str): Optional, only return the access control information for a user with this username.. [optional]
            user_id (str): Optional, only return the access control information for a user with this user ID.. [optional]
        Returns:
            SharingListResponse
        """
        path_args = {}
        kwargs["offset"] = offset
        path_args["offset"] = offset
        kwargs["limit"] = limit
        path_args["limit"] = limit
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/accessControl/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return SharingListResponse(**server_data)

    @classmethod
    def projects_access_control_patch_many(cls, project_id, **kwargs):
        """Update project's access controls

        Set roles for users on this project.
        Args:
            project_id (str): The project ID

        Keyword Args:
            sharing_update_or_remove (SharingUpdateOrRemove): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/accessControl/".format(**path_args)
        cls._client.patch(path, data=kwargs)

    @classmethod
    def projects_aim_patch_many(cls, project_id, **kwargs):
        """Start modeling

        Start the data modeling process.
        Args:
            project_id (str): The project ID.

        Keyword Args:
            aim (Aim): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/aim/".format(**path_args)
        cls._client.patch(path, data=kwargs)

    @classmethod
    def projects_autopilot_create(cls, project_id, **kwargs):
        """Pause or unpause Autopilot

        Pause or unpause the autopilot for a project.
        Args:
            project_id (str): The project ID.

        Keyword Args:
            autopilot (Autopilot): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/autopilot/".format(**path_args)
        cls._client.post(path, data=kwargs)

    @classmethod
    def projects_autopilots_create(cls, project_id, **kwargs):
        """Start autopilot

        Start autopilot on provided featurelist.
        Args:
            project_id (str): The project ID.

        Keyword Args:
            autopilot_start (AutopilotStart): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/autopilots/".format(**path_args)
        cls._client.post(path, data=kwargs)

    @classmethod
    def projects_create(cls, **kwargs):
        """Create project.

        Create a new project.

        Keyword Args:
            project_create (ProjectCreate): [optional]
        Returns:
            ProjectCreateResponse
        """
        path_args = {}
        path = "/api/v2/projects/".format(**path_args)
        server_data = (cls._client.post(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectCreateResponse(**server_data)

    @classmethod
    def projects_cross_series_properties_create(cls, project_id, **kwargs):
        """Validate columns for potential use as the group-by column for cross-series functionality.

        Validate columns for potential use as the group-by column for cross-series functionality.  The group-by column is an optional setting that indicates how to further splitseries into related groups. For example, if each series represents sales of an individual product, the group-by column could be the product category, e.g., \"clothing\" or \"sports equipment\".
        Args:
            project_id (str): The project ID

        Keyword Args:
            cross_series_group_by_column_validate_payload (CrossSeriesGroupByColumnValidatePayload): [optional]
        Returns:
            CrossSeriesGroupByColumnValidateResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/crossSeriesProperties/".format(**path_args)
        server_data = (cls._client.post(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return CrossSeriesGroupByColumnValidateResponse(**server_data)

    @classmethod
    def projects_delete(cls, project_id, **kwargs):
        """Delete a project

        Delete a project
        Args:
            project_id (str): The project ID.

        Keyword Args:
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/".format(**path_args)
        cls._client.delete(path)

    @classmethod
    def projects_external_time_series_baseline_data_validation_jobs_create(
        cls, project_id, **kwargs
    ):
        """Validate baseline data

        This route validates if a provided catalog version id can be used as baseline for calculating metrics. This functionality is available only for time series projects.For a baseline dataset to be valid, the number of unique date amd multiseries_id columnrows must match the unique number of date and multiseries_id column rows in the uploadedtraining dataset. This functionality is limited to one forecast distance. Additionally, the catalog must be a snapshot.
        Args:
            project_id (str): The project ID

        Keyword Args:
            external_ts_baseline_payload (ExternalTSBaselinePayload): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/externalTimeSeriesBaselineDataValidationJobs/".format(
            **path_args
        )
        cls._client.post(path, data=kwargs)

    @classmethod
    def projects_external_time_series_baseline_data_validation_jobs_retrieve(
        cls, project_id, baseline_validation_job_id, **kwargs
    ):
        """Retrieve Baseline Validation Job

        Retrieve information to confirm if the validation job triggered via /api/v2/projects/(projectId)/externalTimeSeriesBaselineDataValidationJobs/ is valid.
        Args:
            project_id (str): The project to retrieve the validation job information from.
            baseline_validation_job_id (str): The id for the validation job

        Keyword Args:
        Returns:
            ExternalTSBaselineResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["baseline_validation_job_id"] = baseline_validation_job_id
        path_args["baselineValidationJobId"] = baseline_validation_job_id
        path = "/api/v2/projects/{projectId}/externalTimeSeriesBaselineDataValidationJobs/{baselineValidationJobId}/".format(
            **path_args
        )
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ExternalTSBaselineResponse(**server_data)

    @classmethod
    def projects_features_multiseries_properties_list(cls, project_id, feature_name, **kwargs):
        """Retrieve potential multiseries ID columns to use with a particular datetime partition column.

        Time series projects require that each timestamp have at most one row corresponding to it. However, multiple series of data can be handled within a single project by designating a multiseries ID column that assigns each row to a particular series. See the :ref:`multiseries <multiseries>` docs on time series projects for more information.  Note that detection will have to be triggered via :http:post:`/api/v2/projects/(projectId)/multiseriesProperties/` in order for multiseries id columns to appear here. The route will return successfully with an empty array of detected columns if detection hasn't run yet, or hasn't found any valid columns.
        Args:
            project_id (str): The project ID to retrieve multiseries properties from.
            feature_name (str): The feature to be used to the datetime partition column.

        Keyword Args:
        Returns:
            MultiseriesRetrieveResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["feature_name"] = feature_name
        path_args["featureName"] = feature_name
        path = "/api/v2/projects/{projectId}/features/{featureName}/multiseriesProperties/".format(
            **path_args
        )
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return MultiseriesRetrieveResponse(**server_data)

    @classmethod
    def projects_jobs_delete(cls, project_id, job_id, **kwargs):
        """Cancel Job

        Cancel a pending job.
        Args:
            project_id (str): The project ID.
            job_id (str): The job ID

        Keyword Args:
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["job_id"] = job_id
        path_args["jobId"] = job_id
        path = "/api/v2/projects/{projectId}/jobs/{jobId}/".format(**path_args)
        cls._client.delete(path)

    @classmethod
    def projects_jobs_list(cls, project_id, **kwargs):
        """List project jobs

        List the project's jobs.
        Args:
            project_id (str): The project ID.

        Keyword Args:
            status (str): If provided, only jobs with the same status will be included in the results; otherwise, queued and inprogress jobs (but not errored jobs) will be returned.. [optional]
        Returns:
            JobListResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/jobs/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return JobListResponse(**server_data)

    @classmethod
    def projects_jobs_retrieve(cls, project_id, job_id, **kwargs):
        """Get job

        Retrieve details for a job that has been started but has not yet completed.
        Args:
            project_id (str): The project ID.
            job_id (str): The job ID

        Keyword Args:
        Returns:
            JobDetailsResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["job_id"] = job_id
        path_args["jobId"] = job_id
        path = "/api/v2/projects/{projectId}/jobs/{jobId}/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return JobDetailsResponse(**server_data)

    @classmethod
    def projects_list(cls, **kwargs):
        """List projects

        List all available projects.

        Keyword Args:
            project_name (str): if provided will filter returned projects for projects with matching names. [optional]
            project_id (bool, date, datetime, dict, float, int, list, str, none_type): if provided will filter returned projects with matching project IDs. [optional]
            order_by (str): if provided will order the results by this field. [optional]
            feature_discovery (str): Return only feature discovery projects. [optional]
        Returns:
            ProjectDetailsResponse
        """
        path_args = {}
        path = "projects/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()[0]
        import pdb

        pdb.set_trace()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectDetailsResponse(**server_data)

    @classmethod
    def projects_multiseries_ids_cross_series_properties_list(
        cls, project_id, multiseries_id, **kwargs
    ):
        """Retrieve eligible cross-series group-by columns.

        Retrieve eligible cross-series group-by columns.  Note that validation will have to have been triggered via :http:post:`/api/v2/projects/(projectId)/crossSeriesProperties/` in order for results to appear here.
        Args:
            project_id (str): The project to retrieve cross-series group-by columns for.
            multiseries_id (str): The name of the column to be used as the multiseries ID column.

        Keyword Args:
            cross_series_group_by_columns (bool, date, datetime, dict, float, int, list, str, none_type): The names of the columns to retrieve the validation status for. If not specified, all eligible columns will be returned.. [optional]
        Returns:
            CrossSeriesGroupByColumnRetrieveResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["multiseries_id"] = multiseries_id
        path_args["multiseriesId"] = multiseries_id
        path = "/api/v2/projects/{projectId}/multiseriesIds/{multiseriesId}/crossSeriesProperties/".format(
            **path_args
        )
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return CrossSeriesGroupByColumnRetrieveResponse(**server_data)

    @classmethod
    def projects_multiseries_properties_create(cls, project_id, **kwargs):
        """Detect multiseries properties

        Analyze relationships between potential partition and multiseries ID columns. Time series projects require that each timestamp have at most one row corresponding to it. However, multiple series of data can be handled within a single project by designating a multiseries ID column that assigns each row to a particular series.  See the :ref:`multiseries <multiseries>` docs on time series projects for more information. A detection job analyzing the relationship between the multiseries ID column and the datetime partition column must be ran before it can be used.  If the desired multiseries ID column(s) are known, it can be specified to limit the analysis to only those columns.
        Args:
            project_id (str): The project ID

        Keyword Args:
            multiseries_payload (MultiseriesPayload): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/multiseriesProperties/".format(**path_args)
        cls._client.post(path, data=kwargs)

    @classmethod
    def projects_patch(cls, project_id, **kwargs):
        """Update project

        Change project name, worker count, or unlock the holdout.     If any of the optional json arguments are not provided,     that aspect of the project will not be altered.
        Args:
            project_id (str): The project ID.

        Keyword Args:
            project_update (ProjectUpdate): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/".format(**path_args)
        cls._client.patch(path, data=kwargs)

    @classmethod
    def projects_relationships_configuration_list(cls, project_id, **kwargs):
        """Retrieve relationships configuration for a project

        Retrieve relationships configuration for a project
        Args:
            project_id (str): The project ID

        Keyword Args:
            config_id (str): Id of Secondary Dataset Configuration. [optional]
        Returns:
            RelationshipsConfigResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/relationshipsConfiguration/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return RelationshipsConfigResponse(**server_data)

    @classmethod
    def projects_retrieve(cls, project_id, **kwargs):
        """Get project.

        Look up a particular project
        Args:
            project_id (str): The project ID.

        Keyword Args:
        Returns:
            ProjectRetrieveResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectRetrieveResponse(**server_data)

    @classmethod
    def projects_secondary_datasets_configurations_create(cls, project_id, **kwargs):
        """Create secondary dataset configurations for a project.

        Create secondary dataset configurations for a project.
        Args:
            project_id (str): The project ID

        Keyword Args:
            secondary_dataset_create (SecondaryDatasetCreate): [optional]
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/secondaryDatasetsConfigurations/".format(**path_args)
        cls._client.post(path, data=kwargs)

    @classmethod
    def projects_secondary_datasets_configurations_delete(
        cls, project_id, secondary_dataset_config_id, **kwargs
    ):
        """Soft deletes a secondary dataset configuration.

        Soft deletes a secondary dataset configuration.
        Args:
            project_id (str): The project ID.
            secondary_dataset_config_id (str): Secondary dataset configuration ID

        Keyword Args:
        Returns:
            None
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["secondary_dataset_config_id"] = secondary_dataset_config_id
        path_args["secondaryDatasetConfigId"] = secondary_dataset_config_id
        path = "/api/v2/projects/{projectId}/secondaryDatasetsConfigurations/{secondaryDatasetConfigId}/".format(
            **path_args
        )
        cls._client.delete(path)

    @classmethod
    def projects_secondary_datasets_configurations_list(cls, project_id, **kwargs):
        """List all secondary dataset configurations for a project

        List all secondary dataset configurations for a project, optionally filtered by feature list id.
        Args:
            project_id (str): The project ID

        Keyword Args:
            featurelist_id (str): feature list ID of the model. [optional]
            model_id (str): ID of the model. [optional]
            offset (int): This many results will be skipped.. [optional] if omitted the server will use the default value of 0
            limit (int): At most this many results are returned.. [optional] if omitted the server will use the default value of 100
            include_deleted (str): Include deleted records.. [optional] if omitted the server will use the default value of "true"
        Returns:
            SecondaryDatasetConfigListResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/secondaryDatasetsConfigurations/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return SecondaryDatasetConfigListResponse(**server_data)

    @classmethod
    def projects_secondary_datasets_configurations_retrieve(
        cls, project_id, secondary_dataset_config_id, **kwargs
    ):
        """Retrieve secondary dataset configuration by ID.

        Retrieve secondary dataset configuration by ID.
        Args:
            project_id (str): The project ID.
            secondary_dataset_config_id (str): Secondary dataset configuration ID

        Keyword Args:
        Returns:
            ProjectSecondaryDatasetConfigResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        kwargs["secondary_dataset_config_id"] = secondary_dataset_config_id
        path_args["secondaryDatasetConfigId"] = secondary_dataset_config_id
        path = "/api/v2/projects/{projectId}/secondaryDatasetsConfigurations/{secondaryDatasetConfigId}/".format(
            **path_args
        )
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectSecondaryDatasetConfigResponse(**server_data)

    @classmethod
    def projects_status_list(cls, project_id, **kwargs):
        """Check project status

        Check the status of a project
        Args:
            project_id (str): The project ID.

        Keyword Args:
        Returns:
            ProjectStatusResponse
        """
        path_args = {}
        kwargs["project_id"] = project_id
        path_args["projectId"] = project_id
        path = "/api/v2/projects/{projectId}/status/".format(**path_args)
        server_data = (cls._client.get(path, data=kwargs)).json()
        server_data = {underscorize(key): val for key, val in server_data.items()}
        return ProjectStatusResponse(**server_data)
