#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_rating_table_model import CreateRatingTableModel
from datarobot.models.full_api.generated.model.rating_table_create_response import RatingTableCreateResponse
from datarobot.models.full_api.generated.model.rating_table_list_response import RatingTableListResponse
from datarobot.models.full_api.generated.model.rating_table_model_details_response import RatingTableModelDetailsResponse
from datarobot.models.full_api.generated.model.rating_table_retrieve_response import RatingTableRetrieveResponse
from datarobot.models.full_api.generated.model.rating_table_update import RatingTableUpdate


class RatingTablesApi(APIObject):

        @classmethod
        def projects_rating_table_models_create(
            cls,
            project_id,
            **kwargs
        ):
            """Create New Models From A Rating Table

            Create a new rating table model from a validated rating table record
            Args:
                project_id (str): the project that owns this data

            Keyword Args:
                create_rating_table_model (CreateRatingTableModel): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/ratingTableModels/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_rating_table_models_list(
            cls,
            project_id,
            **kwargs
        ):
            """List Rating Table Models

            Lists all the models from a project that have rating tables
            Args:
                project_id (str): the project to list models from

            Keyword Args:
                bulk_operation_id (str): The ID of the bulk model operation. If specified, only models submitted in scope of this operation will be shown.. [optional]
                order_by (str): A comma-separated list of metrics to sort by. If metric is prefixed with a '-', models will be sorted by this metric in descending order, otherwise in ascending order. Valid sorting metrics are `metric` and `samplePct`. `metric` will sort models by metric value selected for this project using validation score. This accounts for the direction of the metric, so `-metric` will sort in order of decreasing 'goodness', which may be opposite to the natural numerical order. If not specified, `-metric` will be used.. [optional]
                name (str): If specified, will filter for models with model type matching `name`. [optional]
                sample_pct (float): If specified, will filter for models with matching sample percentage. [optional]
                with_metric (str): If specified, the returned models will only have scores for this metric. If not, all metrics will be included.. [optional]
                is_starred (str): If specified, will filter for models marked as starred.. [optional]
            Returns:
                RatingTableModelDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/ratingTableModels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableModelDetailsResponse(**server_data)

        @classmethod
        def projects_rating_table_models_retrieve(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve Rating Table Model

            Look up a particular rating table model
            Args:
                project_id (str): the project to retrieve the model from
                model_id (str): the model to retrieve

            Keyword Args:
            Returns:
                RatingTableModelDetailsResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/ratingTableModels/{modelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableModelDetailsResponse(**server_data)

        @classmethod
        def projects_rating_tables_create(
            cls,
            project_id,
            parent_model_id,
            rating_table_file,
            rating_table_name,
            **kwargs
        ):
            """Upload Modified Rating Table File

            Create a new rating table from a rating table file This will create a new rating table, regardless of whether the validation succeeds. The rating table object will have a validationError which will be left blank in the case of successful validation.
            Args:
                project_id (str): the project that owns this data
                parent_model_id (str): the parent model this rating table file was derived from
                rating_table_file (file_type): rating table file to use for the new rating table. Accepts `Content-Type:multipart/form-data`
                rating_table_name (str): the name of the new rating table to create

            Keyword Args:
            Returns:
                RatingTableCreateResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['parent_model_id'] = parent_model_id
            path_args['parentModelId'] = parent_model_id
            kwargs['rating_table_file'] = rating_table_file
            path_args['ratingTableFile'] = rating_table_file
            kwargs['rating_table_name'] = rating_table_name
            path_args['ratingTableName'] = rating_table_name
            path = '/api/v2/projects/{projectId}/ratingTables/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableCreateResponse(**server_data)

        @classmethod
        def projects_rating_tables_file_list(
            cls,
            project_id,
            rating_table_id,
            **kwargs
        ):
            """Retrieve Rating Table File

            Retrieve the CSV file for the rating table
            Args:
                project_id (str): the project that owns this data
                rating_table_id (str): the rating table ID to retrieve the source file from

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['rating_table_id'] = rating_table_id
            path_args['ratingTableId'] = rating_table_id
            path = '/api/v2/projects/{projectId}/ratingTables/{ratingTableId}/file/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def projects_rating_tables_list(
            cls,
            project_id,
            **kwargs
        ):
            """List Rating Tables For The Project

            List RatingTable objects for a project.     These contain metadata about the rating table and the location at which the corresponding rating      table file can be retrieved.
            Args:
                project_id (str): The project ID

            Keyword Args:
                parent_model_id (str): optional. If specified, only rating tables with this parentModelId will be returned. [optional]
                model_id (str): optional. If specified, only rating tables with this modelId will be returned. [optional]
                offset (int): optional (default: 0), this many results will be skipped. [optional] if omitted the server will use the default value of 0
                limit (int): optional (default: no limit), at most this many results are returned. To specify no limit, use 0. The default may change and a maximum limit may be imposed without notice.. [optional] if omitted the server will use the default value of 0
            Returns:
                RatingTableListResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            path = '/api/v2/projects/{projectId}/ratingTables/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableListResponse(**server_data)

        @classmethod
        def projects_rating_tables_patch(
            cls,
            project_id,
            rating_table_id,
            **kwargs
        ):
            """Update an uploaded rating table

            Rating tables may only be updated if they have not yet been used to create a model.
            Args:
                project_id (str): the project that owns this data
                rating_table_id (str): the rating table ID to retrieve the source file from

            Keyword Args:
                rating_table_update (RatingTableUpdate): [optional]
            Returns:
                RatingTableRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['rating_table_id'] = rating_table_id
            path_args['ratingTableId'] = rating_table_id
            path = '/api/v2/projects/{projectId}/ratingTables/{ratingTableId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableRetrieveResponse(**server_data)

        @classmethod
        def projects_rating_tables_retrieve(
            cls,
            project_id,
            rating_table_id,
            **kwargs
        ):
            """Retrieve Rating Table Information

            Retrieves a rating table
            Args:
                project_id (str): the project that owns this data
                rating_table_id (str): the rating table ID to retrieve the source file from

            Keyword Args:
            Returns:
                RatingTableRetrieveResponse
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['rating_table_id'] = rating_table_id
            path_args['ratingTableId'] = rating_table_id
            path = '/api/v2/projects/{projectId}/ratingTables/{ratingTableId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return RatingTableRetrieveResponse(**server_data)

