#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.resource_usage_response import ResourceUsageResponse


class ResourceUsageApi(APIObject):

        @classmethod
        def users_rate_limit_usage_delete(
            cls,
            user_id,
            resource_name,
            **kwargs
        ):
            """Reset resource usage for the resource

            Reset rate limit resource usage for a user of a specified resource to zero. This will happen automatically when windows roll over. This route can be used to reset a user's rate limits sooner.
            Args:
                user_id (str): The id of the user to reset usage for.
                resource_name (str): The resource name to reset usage for.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            kwargs['resource_name'] = resource_name
            path_args['resourceName'] = resource_name
            path = '/api/v2/users/{userId}/rateLimitUsage/{resourceName}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def users_rate_limit_usage_delete_many(
            cls,
            user_id,
            **kwargs
        ):
            """Reset resource usage for all resources

            Reset specified user's rate limit resource usage to zero for all resources. When windows roll over, all limits are automatically reset. Use this route to reset usage sooner.
            Args:
                user_id (str): The user identifier.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/users/{userId}/rateLimitUsage/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def users_rate_limit_usage_list(
            cls,
            user_id,
            **kwargs
        ):
            """List resource usage for a user

            List the rate limit resource usage for a user. The usage array returned will have one object corresponding to each rate limit applied to the user.
            Args:
                user_id (str): The user identifier.

            Keyword Args:
            Returns:
                ResourceUsageResponse
            """
            path_args = {}
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/users/{userId}/rateLimitUsage/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ResourceUsageResponse(**server_data)

