#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.multiseries_histograms_retrieve_response import MultiseriesHistogramsRetrieveResponse
from datarobot.models.full_api.generated.model.series_accuracy_compute import SeriesAccuracyCompute
from datarobot.models.full_api.generated.model.series_accuracy_retrieve_response import SeriesAccuracyRetrieveResponse


class SeriesInsightsApi(APIObject):

        @classmethod
        def projects_datetime_models_multiseries_histograms_list(
            cls,
            project_id,
            model_id,
            attribute="rowCount",
            bins="10",
            **kwargs
        ):
            """Retrieve the histograms for series insights.

            Retrieve the histograms for series insights.  Histogram is computed only for first 1000 series (ordered by name).
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                attribute (str): The series attribute to build a histogram for.. defaults to "rowCount", must be one of ["rowCount"]
                bins (str): The number of bins in a histogram. Can be 10, 20 or 50. The default is 10.. defaults to "10", must be one of ["10"]

            Keyword Args:
                metric (str): The name of the metric to retrieve the histogram for attributes \"validationScore\", \"backtestingScore\", and\"holdoutScore\". If omitted, the default project metric will be used.. [optional]
            Returns:
                MultiseriesHistogramsRetrieveResponse
            """
            path_args = {}
            kwargs['attribute'] = attribute
            path_args['attribute'] = attribute
            kwargs['bins'] = bins
            path_args['bins'] = bins
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/multiseriesHistograms/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return MultiseriesHistogramsRetrieveResponse(**server_data)

        @classmethod
        def projects_datetime_models_multiseries_scores_create(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Request the computation of per-series scores for a multiseries model.

            Request the computation of per-series scores for a multiseries model. .. note::    Computation uses available partitions only. This endpoint will not compute backtesting   scores if no backtesting scores exist prior to this request. 
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                series_accuracy_compute (SeriesAccuracyCompute): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def projects_datetime_models_multiseries_scores_file_list(
            cls,
            project_id,
            model_id,
            **kwargs
        ):
            """Retrieve the CSV file for the series accuracy.

            Retrieve the CSV file for the series accuracy.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID

            Keyword Args:
                multiseries_value (str): If specified, only the series containing the given value in one of the series ID columns will be returned.. [optional]
                metric (str): The name of the metric to retrieve the scores for. If omitted, the default project metric will be used.. [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/file/'.format(**path_args)
            cls._client.get(path, data=kwargs)

        @classmethod
        def projects_datetime_models_multiseries_scores_list(
            cls,
            project_id,
            model_id,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List the scores per individual series for the specified multiseries model.

            List the scores per individual series for the specified multiseries model.
            Args:
                project_id (str): The project ID
                model_id (str): The model ID
                offset (int): The number of results to skip. Defaults to 0 if not specified.. defaults to 0, must be one of [0]
                limit (int): The maximum number of results to return. Defaults to 100 if not specified.. defaults to 100, must be one of [100]

            Keyword Args:
                multiseries_value (str): Only the series containing the given value in one of the series ID columns will be returned if specified.. [optional]
                metric (str): The name of the metric to retrieve the scores for.If omitted, the default project metric will be used.. [optional]
                order_by (str): Used for sorting the series. Supported attributes for ordering include: \"multiseriesValue\", \"rowCount\", \"validationScore\", \"holdoutScore\"  and \"backtestingScore\", \"startDate\", \"endDate\", and \"targetAverage\".Prefix the attribute name with a dash to sort in descending order,e.g. `orderBy=-rowCount`. If multiple series with equal values of the ordering attributeexist, ties will be broken arbitrarily.. [optional]
                filter_by (str): Used to specify on which attribute values to filter the series.Supported attributes for filtering include: \"rowCount\", \"startDate\", \"endDate\", \"targetAverage\", \"validationScore\", \"holdoutScore\", and \"backtestingScore\".`filterByBins` and `numberOfBins` are required if this parameter is used.. [optional]
                number_of_bins (str): Used to specify the number of bins in the histogram on which to filter the series.Can be 10, 20 or 50.`filterBy` and `filterByBins` are required if this parameter is used.. [optional]
                filter_by_bins (str): Used to specify the multiseries histogram bins on which to filter the series.`filterBy` and `numberOfBins` are required if this parameter is used.. [optional]
            Returns:
                SeriesAccuracyRetrieveResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['project_id'] = project_id
            path_args['projectId'] = project_id
            kwargs['model_id'] = model_id
            path_args['modelId'] = model_id
            path = '/api/v2/projects/{projectId}/datetimeModels/{modelId}/multiseriesScores/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SeriesAccuracyRetrieveResponse(**server_data)

