#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_sso_configuration import CreateSsoConfiguration
from datarobot.models.full_api.generated.model.list_sso_configuration_response import ListSsoConfigurationResponse
from datarobot.models.full_api.generated.model.sso_configuration_response import SsoConfigurationResponse
from datarobot.models.full_api.generated.model.update_sso_configuration import UpdateSsoConfiguration


class SsoConfigurationApi(APIObject):

        @classmethod
        def sso_configurations_create(
            cls,
            **kwargs
        ):
            """Create an SSO configuration for a specific organization

            Create an SSO configuration for a specific organization

            Keyword Args:
                create_sso_configuration (CreateSsoConfiguration): [optional]
            Returns:
                SsoConfigurationResponse
            """
            path_args = {}
            path = '/api/v2/ssoConfigurations/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SsoConfigurationResponse(**server_data)

        @classmethod
        def sso_configurations_list(
            cls,
            **kwargs
        ):
            """List sso configurations.

            List the sso configurations that correspond to provided conditions.

            Keyword Args:
                offset (int): The number of records to skip over.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of records to return.. [optional] if omitted the server will use the default value of 100
                org_id (str): The ID of the organization.. [optional]
            Returns:
                ListSsoConfigurationResponse
            """
            path_args = {}
            path = '/api/v2/ssoConfigurations/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return ListSsoConfigurationResponse(**server_data)

        @classmethod
        def sso_configurations_patch(
            cls,
            configuration_id,
            **kwargs
        ):
            """Update an SSO configuration for a specific organization.

            Update an SSO configuration for a specific organization.
            Args:
                configuration_id (str): The ID of the organization to retrieve SSO config for.

            Keyword Args:
                update_sso_configuration (UpdateSsoConfiguration): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['configuration_id'] = configuration_id
            path_args['configurationId'] = configuration_id
            path = '/api/v2/ssoConfigurations/{configurationId}/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

        @classmethod
        def sso_configurations_retrieve(
            cls,
            configuration_id,
            **kwargs
        ):
            """Retrieve SSO configuration of a specific organization.

            Retrieve SSO configuration of a specific organization.
            Args:
                configuration_id (str): The ID of the organization to retrieve SSO config for.

            Keyword Args:
            Returns:
                SsoConfigurationResponse
            """
            path_args = {}
            kwargs['configuration_id'] = configuration_id
            path_args['configurationId'] = configuration_id
            path = '/api/v2/ssoConfigurations/{configurationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return SsoConfigurationResponse(**server_data)

