#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.status_list_response import StatusListResponse
from datarobot.models.full_api.generated.model.status_retrieve_response import StatusRetrieveResponse


class StatusApi(APIObject):

        @classmethod
        def status_delete(
            cls,
            status_id,
            **kwargs
        ):
            """Delete a task

            Destroy an async status object
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/status/{statusId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def status_list(
            cls,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List tasks

            List the async tasks that are currently running for your account
            Args:
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                StatusListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/status/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return StatusListResponse(**server_data)

        @classmethod
        def status_retrieve(
            cls,
            status_id,
            **kwargs
        ):
            """Get task status

            Check the status of an asynchronous task such as project creation
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                StatusRetrieveResponse
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/status/{statusId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return StatusRetrieveResponse(**server_data)

