#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_use_case_attachment import CreateUseCaseAttachment
from datarobot.models.full_api.generated.model.use_case import UseCase
from datarobot.models.full_api.generated.model.use_case_activity_list_response import UseCaseActivityListResponse
from datarobot.models.full_api.generated.model.use_case_attachment import UseCaseAttachment
from datarobot.models.full_api.generated.model.use_case_attachment_list_response import UseCaseAttachmentListResponse
from datarobot.models.full_api.generated.model.use_case_attachment_response import UseCaseAttachmentResponse
from datarobot.models.full_api.generated.model.use_case_create_response import UseCaseCreateResponse
from datarobot.models.full_api.generated.model.use_case_list_response import UseCaseListResponse
from datarobot.models.full_api.generated.model.use_case_realized_values_over_time_response import UseCaseRealizedValuesOverTimeResponse
from datarobot.models.full_api.generated.model.use_case_response import UseCaseResponse
from datarobot.models.full_api.generated.model.use_case_sharing_list_response import UseCaseSharingListResponse
from datarobot.models.full_api.generated.model.use_case_sharing_update import UseCaseSharingUpdate
from datarobot.models.full_api.generated.model.use_case_update import UseCaseUpdate
from datarobot.models.full_api.generated.model.use_case_value_template_calculate_response import UseCaseValueTemplateCalculateResponse
from datarobot.models.full_api.generated.model.use_case_value_template_response import UseCaseValueTemplateResponse


class UseCaseApi(APIObject):

        @classmethod
        def use_case_value_templates_calculation_list(
            cls,
            accuracy_improvement,
            decisions_count,
            template_type,
            **kwargs
        ):
            """Calculate value of template with given template parameters.

            Calculate value of template with given template parameters.
            Args:
                accuracy_improvement (float): Accuracy improvement
                decisions_count (int): Estimated number of decisions per year
                template_type (str): The name of the use case value template to be retrieved

            Keyword Args:
                incorrect_decisions_count (int): Estimated number of incorrect decisions per year. Required for templateType CLASSIFICATION. [optional]
                incorrect_decision_cost (float): Estimated cost of an individual incorrect decision. Required for templateType CLASSIFICATION. [optional]
                target_value (float): Target value. Required for templateType REGRESSION. [optional]
            Returns:
                UseCaseValueTemplateCalculateResponse
            """
            path_args = {}
            kwargs['accuracy_improvement'] = accuracy_improvement
            path_args['accuracyImprovement'] = accuracy_improvement
            kwargs['decisions_count'] = decisions_count
            path_args['decisionsCount'] = decisions_count
            kwargs['template_type'] = template_type
            path_args['templateType'] = template_type
            path = '/api/v2/useCaseValueTemplates/{templateType}/calculation/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseValueTemplateCalculateResponse(**server_data)

        @classmethod
        def use_case_value_templates_list(
            cls,
            **kwargs
        ):
            """List available use cases templates.

            List available use cases templates.

            Keyword Args:
            Returns:
                UseCaseValueTemplateResponse
            """
            path_args = {}
            path = '/api/v2/useCaseValueTemplates/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseValueTemplateResponse(**server_data)

        @classmethod
        def use_case_value_templates_retrieve(
            cls,
            template_type,
            **kwargs
        ):
            """Get an individual use case value template by its name.

            Get an individual use case value template by its name.
            Args:
                template_type (str): The name of the use case value template to be retrieved

            Keyword Args:
            Returns:
                UseCaseValueTemplateResponse
            """
            path_args = {}
            kwargs['template_type'] = template_type
            path_args['templateType'] = template_type
            path = '/api/v2/useCaseValueTemplates/{templateType}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseValueTemplateResponse(**server_data)

        @classmethod
        def use_cases_activities_list(
            cls,
            use_case_id,
            **kwargs
        ):
            """Retrieve the activities of a use case.

            Retrieve the activities of a use case.
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
                offset (int): The number of records to skip over. Default 0.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of records to return in the range from 1 to 100. Default 100.. [optional] if omitted the server will use the default value of 100
            Returns:
                UseCaseActivityListResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/activities/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseActivityListResponse(**server_data)

        @classmethod
        def use_cases_attachments_create(
            cls,
            use_case_id,
            **kwargs
        ):
            """Attach a list of resources to this use case.

            Attach a list of resources to this use case.
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
                create_use_case_attachment (CreateUseCaseAttachment): [optional]
            Returns:
                UseCaseAttachment
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/attachments/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseAttachment(**server_data)

        @classmethod
        def use_cases_attachments_delete(
            cls,
            use_case_id,
            attachment_id,
            **kwargs
        ):
            """Removes a resource from a use case.

            Removes a resource from a use case.
            Args:
                use_case_id (str): The id of the use case
                attachment_id (str): The id of the attachment

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            kwargs['attachment_id'] = attachment_id
            path_args['attachmentId'] = attachment_id
            path = '/api/v2/useCases/{useCaseId}/attachments/{attachmentId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def use_cases_attachments_list(
            cls,
            use_case_id,
            **kwargs
        ):
            """Get a list of resources attached to this use case.

            Get a list of resources attached to this use case.
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
                offset (int): This many results will be skipped. [optional] if omitted the server will use the default value of 0
                limit (int): This many results are returned. [optional] if omitted the server will use the default value of 100
                type (str): Use case attachment type. [optional]
            Returns:
                UseCaseAttachmentListResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/attachments/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseAttachmentListResponse(**server_data)

        @classmethod
        def use_cases_attachments_retrieve(
            cls,
            use_case_id,
            attachment_id,
            **kwargs
        ):
            """Get a resource that is attached to a use case.

            Get a resource that is attached to a use case.
            Args:
                use_case_id (str): The id of the use case
                attachment_id (str): The id of the attachment

            Keyword Args:
            Returns:
                UseCaseAttachmentResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            kwargs['attachment_id'] = attachment_id
            path_args['attachmentId'] = attachment_id
            path = '/api/v2/useCases/{useCaseId}/attachments/{attachmentId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseAttachmentResponse(**server_data)

        @classmethod
        def use_cases_create(
            cls,
            **kwargs
        ):
            """Create a new use case.

            Create a new use case.

            Keyword Args:
                use_case (UseCase): [optional]
            Returns:
                UseCaseCreateResponse
            """
            path_args = {}
            path = '/api/v2/useCases/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseCreateResponse(**server_data)

        @classmethod
        def use_cases_delete(
            cls,
            use_case_id,
            **kwargs
        ):
            """Delete a use case

            Delete a use case
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def use_cases_list(
            cls,
            **kwargs
        ):
            """List use cases the requesting user has access to.

            List use cases the requesting user has access to.

            Keyword Args:
                offset (int): The number of records to skip over. Default 0.. [optional] if omitted the server will use the default value of 0
                limit (int): The number of records to return in the range from 1 to 100. Default 100.. [optional] if omitted the server will use the default value of 100
                order_by (str): Sort the use cases by a field of the use case.. [optional]
                name_part (str): Only return use cases with names that match the given string.. [optional]
                stage (str): Filter results by the current stage of the use cases.. [optional]
            Returns:
                UseCaseListResponse
            """
            path_args = {}
            path = '/api/v2/useCases/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseListResponse(**server_data)

        @classmethod
        def use_cases_patch(
            cls,
            use_case_id,
            **kwargs
        ):
            """Update a use case.

            Update a use case.
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
                use_case_update (UseCaseUpdate): [optional]
            Returns:
                UseCaseResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseResponse(**server_data)

        @classmethod
        def use_cases_realized_value_over_time_list(
            cls,
            use_case_id,
            **kwargs
        ):
            """Retrieve realized value information for a given use case over a period of time

            Retrieve realized value information for a given use case over a period of time
            Args:
                use_case_id (str): The ID of the use case

            Keyword Args:
                start (datetime, none_type): RFC3339 datetime. Start of time period to retrieve the features drift for. If not set, defaults to 1 week from the end of the period.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                end (datetime, none_type): RFC3339 datetime. End of time period to retrieve the features drift for. If not set, defaults to the next top of the hour from now.Note: this field only accepts top of the hour RFC3339 datetime strings For example: ``2019-08-01T00:00:00Z``.. [optional]
                bucket_size (str): The time duration of a bucket. Needs to be multiple of one hour. Can not be longer than the total length of the period. If not set, a default value will be calculated based on the start and end time.. [optional]
            Returns:
                UseCaseRealizedValuesOverTimeResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/realizedValueOverTime/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseRealizedValuesOverTimeResponse(**server_data)

        @classmethod
        def use_cases_retrieve(
            cls,
            use_case_id,
            **kwargs
        ):
            """Retrieve a use case.

            Retrieve a use case.
            Args:
                use_case_id (str): The id of the use case

            Keyword Args:
            Returns:
                UseCaseResponse
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseResponse(**server_data)

        @classmethod
        def use_cases_shared_roles_list(
            cls,
            use_case_id,
            offset=0,
            limit=10,
            **kwargs
        ):
            """Get a list of users, groups and organizations that have an access to this use case

            Get a list of users, groups and organizations that have an access to this use case
            Args:
                use_case_id (str): The ID of the use case
                offset (int): This many results will be skipped. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. defaults to 10, must be one of [10]

            Keyword Args:
                id (str): Only return roles for a user, group or organization with this identifier.. [optional]
                name (str): Only return roles for a user, group or organization with this name.. [optional]
                share_recipient_type (str): List access controls for recipients with this type.. [optional]
            Returns:
                UseCaseSharingListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/sharedRoles/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UseCaseSharingListResponse(**server_data)

        @classmethod
        def use_cases_shared_roles_patch_many(
            cls,
            use_case_id,
            **kwargs
        ):
            """Share a use case with a user, group or organization.

            Share a use case with a user, group or organization.
            Args:
                use_case_id (str): The ID of the use case

            Keyword Args:
                use_case_sharing_update (UseCaseSharingUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['use_case_id'] = use_case_id
            path_args['useCaseId'] = use_case_id
            path = '/api/v2/useCases/{useCaseId}/sharedRoles/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

