#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.audit_logs_event_list_response import AuditLogsEventListResponse
from datarobot.models.full_api.generated.model.audit_logs_retrieve_one_response import AuditLogsRetrieveOneResponse
from datarobot.models.full_api.generated.model.audit_logs_retrieve_response import AuditLogsRetrieveResponse
from datarobot.models.full_api.generated.model.prediction_usage_retrieve_response import PredictionUsageRetrieveResponse
from datarobot.models.full_api.generated.model.usage_data_events_list_response import UsageDataEventsListResponse
from datarobot.models.full_api.generated.model.usage_data_export import UsageDataExport
from datarobot.models.full_api.generated.model.usage_data_retrieve_response import UsageDataRetrieveResponse


class UserActivityApi(APIObject):

        @classmethod
        def event_logs_events_list(
            cls,
            **kwargs
        ):
            """Retrieve all the available events. DEPRECATED API.

            Retrieve all the available events. DEPRECATED API.

            Keyword Args:
            Returns:
                AuditLogsEventListResponse
            """
            path_args = {}
            path = '/api/v2/eventLogs/events/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AuditLogsEventListResponse(**server_data)

        @classmethod
        def event_logs_list(
            cls,
            **kwargs
        ):
            """Retrieve one page of audit log records.

            Retrieve one page of audit log records.

            Keyword Args:
                project_id (str): The project to select log records for.. [optional]
                user_id (str): The user to select log records for.. [optional]
                org_id (str): The organization to select log records for.. [optional]
                event (str): The event type of records.. [optional]
                min_timestamp (datetime): The lower bound for timestamps. E.g. '2016-12-13T11:12:13.141516Z'.. [optional]
                max_timestamp (datetime): The upper bound for timestamps. E.g. '2016-12-13T11:12:13.141516Z'.. [optional]
                offset (int): This many results will be skipped. Defaults to 0.. [optional] if omitted the server will use the default value of 0
                order (str): The order of the results. Defaults to descending.. [optional] if omitted the server will use the default value of "desc"
                include_identifying_fields (str): Indicates if identifying information like user names, project names, etc. should be included or not. Defaults to True.. [optional] if omitted the server will use the default value of "true"
                audit_report_type (str): Indicates which type of event to return - must be one of ``APP_USAGE`` for application related events (i.e. Project Created, Dataset Uploaded, etc.) or ``ADMIN_USAGE`` for admin related events (i.e. Reset API Token for User, Organization Created, etc.). If not provided, all events will be returned by default.. [optional]
            Returns:
                AuditLogsRetrieveResponse
            """
            path_args = {}
            path = '/api/v2/eventLogs/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AuditLogsRetrieveResponse(**server_data)

        @classmethod
        def event_logs_prediction_usage_list(
            cls,
            min_timestamp,
            max_timestamp,
            **kwargs
        ):
            """Retrieve prediction usage data.

            Retrieve prediction usage data. ``CAN_ACCESS_USER_ACTIVITY`` permission is required.
            Args:
                min_timestamp (datetime): The lower bound for timestamps. E.g. '2016-12-13T11:12:13.141516Z'.
                max_timestamp (datetime): The upper bound for timestamps. Time range should not exceed 24 hours. E.g. '2016-12-13T11:12:13.141516Z'.

            Keyword Args:
                project_id (str): The project to retrieve prediction usage for.. [optional]
                user_id (str): The user to retrieve prediction usage for.. [optional]
                order (str): The order of prediction usage rows sorted by ``timestamp``. Defaults to descending.. [optional] if omitted the server will use the default value of "desc"
                offset (int): This many results will be skipped. Defaults to 0.. [optional] if omitted the server will use the default value of 0
                include_identifying_fields (str): Indicates if identifying information like user names, project names, etc should be included or not. Defaults to True.. [optional] if omitted the server will use the default value of "true"
            Returns:
                PredictionUsageRetrieveResponse
            """
            path_args = {}
            kwargs['min_timestamp'] = min_timestamp
            path_args['minTimestamp'] = min_timestamp
            kwargs['max_timestamp'] = max_timestamp
            path_args['maxTimestamp'] = max_timestamp
            path = '/api/v2/eventLogs/predictionUsage/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return PredictionUsageRetrieveResponse(**server_data)

        @classmethod
        def event_logs_retrieve(
            cls,
            record_id,
            **kwargs
        ):
            """Get audit record by ID.

            Get audit record by ID.
            Args:
                record_id (str): The id of the audit log.

            Keyword Args:
                include_identifying_fields (str): Indicates if identifying information like user names, project names, etc should be included or not. Defaults to True.. [optional] if omitted the server will use the default value of "true"
            Returns:
                AuditLogsRetrieveOneResponse
            """
            path_args = {}
            kwargs['record_id'] = record_id
            path_args['recordId'] = record_id
            path = '/api/v2/eventLogs/{recordId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return AuditLogsRetrieveOneResponse(**server_data)

        @classmethod
        def usage_data_exports_create(
            cls,
            **kwargs
        ):
            """Create a customer usage data artifact request. Requires \"CAN_ACCESS_USER_ACTIVITY\" permission.

            Create a customer usage data artifact request. Requires \"CAN_ACCESS_USER_ACTIVITY\" permission. Returns async task status URL as a \"Location\" header. Async task status should be polled in order to retrieve artifact id.

            Keyword Args:
                usage_data_export (UsageDataExport): [optional]
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/usageDataExports/'.format(**path_args)
            cls._client.post(path, data=kwargs)

        @classmethod
        def usage_data_exports_retrieve(
            cls,
            artifact_id,
            **kwargs
        ):
            """Retrieve a prepared customer usage data artifact.

            Retrieve a prepared customer usage data artifact. Requires \"CAN_ACCESS_USER_ACTIVITY\" permission.
            Args:
                artifact_id (str): The ID of the generated artifact to retrieve.

            Keyword Args:
            Returns:
                UsageDataRetrieveResponse
            """
            path_args = {}
            kwargs['artifact_id'] = artifact_id
            path_args['artifactId'] = artifact_id
            path = '/api/v2/usageDataExports/{artifactId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsageDataRetrieveResponse(**server_data)

        @classmethod
        def usage_data_exports_supported_events_list(
            cls,
            **kwargs
        ):
            """Describe supported available audit events with which to filter result data.

            Describe supported available audit events with which to filter result data.

            Keyword Args:
            Returns:
                UsageDataEventsListResponse
            """
            path_args = {}
            path = '/api/v2/usageDataExports/supportedEvents/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsageDataEventsListResponse(**server_data)

