#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.organization_user import OrganizationUser
from datarobot.models.full_api.generated.model.organization_user_created_response import OrganizationUserCreatedResponse
from datarobot.models.full_api.generated.model.organization_user_list_response import OrganizationUserListResponse
from datarobot.models.full_api.generated.model.organization_user_patch import OrganizationUserPatch
from datarobot.models.full_api.generated.model.organization_user_response import OrganizationUserResponse
from datarobot.models.full_api.generated.model.user_create import UserCreate
from datarobot.models.full_api.generated.model.user_create_response import UserCreateResponse
from datarobot.models.full_api.generated.model.user_limits_patch_body import UserLimitsPatchBody
from datarobot.models.full_api.generated.model.user_limits_response import UserLimitsResponse


class UserManagementApi(APIObject):

        @classmethod
        def organizations_users_create(
            cls,
            organization_id,
            **kwargs
        ):
            """Add user to an existing organization.

            Add user to an existing organization. A user can only be part of one organization at a time
            Args:
                organization_id (str): Organization ID

            Keyword Args:
                organization_user (OrganizationUser): [optional]
            Returns:
                OrganizationUserCreatedResponse
            """
            path_args = {}
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            path = '/api/v2/organizations/{organizationId}/users/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationUserCreatedResponse(**server_data)

        @classmethod
        def organizations_users_delete(
            cls,
            organization_id,
            user_id,
            **kwargs
        ):
            """Remove user from organization

            Remove the user from the organization.
            Args:
                organization_id (str): The organization the user is in
                user_id (str): The user ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/organizations/{organizationId}/users/{userId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def organizations_users_list(
            cls,
            organization_id,
            offset=0,
            limit=0,
            **kwargs
        ):
            """List organization users

            List memberships in this organization.
            Args:
                organization_id (str): Organization ID
                offset (int): This many results will be skipped.. defaults to 0, must be one of [0]
                limit (int): At most this many results are returned. If 0, all results.. defaults to 0, must be one of [0]

            Keyword Args:
            Returns:
                OrganizationUserListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            path = '/api/v2/organizations/{organizationId}/users/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationUserListResponse(**server_data)

        @classmethod
        def organizations_users_patch(
            cls,
            organization_id,
            user_id,
            **kwargs
        ):
            """Patch organization's user

            Patch organization's user. Only system or the organization admin can perform this operation.
            Args:
                organization_id (str): The organization the user is in
                user_id (str): The user ID

            Keyword Args:
                organization_user_patch (OrganizationUserPatch): [optional]
            Returns:
                dict
            """
            path_args = {}
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/organizations/{organizationId}/users/{userId}/'.format(**path_args)
            server_data = (cls._client.patch(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return dict(**server_data)

        @classmethod
        def organizations_users_retrieve(
            cls,
            organization_id,
            user_id,
            **kwargs
        ):
            """Retrieve user from organization

            Retrieve the user from this organization.
            Args:
                organization_id (str): The organization the user is in
                user_id (str): The user ID

            Keyword Args:
            Returns:
                OrganizationUserResponse
            """
            path_args = {}
            kwargs['organization_id'] = organization_id
            path_args['organizationId'] = organization_id
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/organizations/{organizationId}/users/{userId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return OrganizationUserResponse(**server_data)

        @classmethod
        def users_create(
            cls,
            **kwargs
        ):
            """Create a User and add them to an organisation.

            Create a User and add them to an organisation.

            Keyword Args:
                user_create (UserCreate): [optional]
            Returns:
                UserCreateResponse
            """
            path_args = {}
            path = '/api/v2/users/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserCreateResponse(**server_data)

        @classmethod
        def users_limits_list(
            cls,
            user_id,
            **kwargs
        ):
            """Get the rate limits and account limits for a user

            User limits are those limits on an account that can be updated per-user. Rate limits that can't be modified per-user are not returned here.
            Args:
                user_id (str): The id of the user to retrieve usage limits for

            Keyword Args:
            Returns:
                UserLimitsResponse
            """
            path_args = {}
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/users/{userId}/limits/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserLimitsResponse(**server_data)

        @classmethod
        def users_limits_patch_many(
            cls,
            user_id,
            **kwargs
        ):
            """Update the rate limits and account limits for a user

            User limits are those limits on an account that can be updated per-user.Rate limits that can't be modified per-user are not returned here.
            Args:
                user_id (str): The id of the user to update usage limits for

            Keyword Args:
                user_limits_patch_body (UserLimitsPatchBody): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['user_id'] = user_id
            path_args['userId'] = user_id
            path = '/api/v2/users/{userId}/limits/'.format(**path_args)
            cls._client.patch(path, data=kwargs)

