#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.create_remote_event_response import CreateRemoteEventResponse
from datarobot.models.full_api.generated.model.notification_channel_create import NotificationChannelCreate
from datarobot.models.full_api.generated.model.notification_channel_response import NotificationChannelResponse
from datarobot.models.full_api.generated.model.notification_channel_update import NotificationChannelUpdate
from datarobot.models.full_api.generated.model.notification_channels_list_response import NotificationChannelsListResponse
from datarobot.models.full_api.generated.model.notification_email_channel_verification import NotificationEmailChannelVerification
from datarobot.models.full_api.generated.model.notification_email_channel_verification_response import NotificationEmailChannelVerificationResponse
from datarobot.models.full_api.generated.model.notification_email_channel_verification_status import NotificationEmailChannelVerificationStatus
from datarobot.models.full_api.generated.model.notification_email_channel_verification_status_response import NotificationEmailChannelVerificationStatusResponse
from datarobot.models.full_api.generated.model.notification_policies_list_response import NotificationPoliciesListResponse
from datarobot.models.full_api.generated.model.notification_policy_create import NotificationPolicyCreate
from datarobot.models.full_api.generated.model.notification_policy_response import NotificationPolicyResponse
from datarobot.models.full_api.generated.model.notification_policy_update import NotificationPolicyUpdate
from datarobot.models.full_api.generated.model.notification_webhook_channel_status_response import NotificationWebhookChannelStatusResponse
from datarobot.models.full_api.generated.model.notification_webhook_channel_test_create import NotificationWebhookChannelTestCreate
from datarobot.models.full_api.generated.model.notification_webhook_channel_test_id import NotificationWebhookChannelTestId
from datarobot.models.full_api.generated.model.remote_event_create import RemoteEventCreate
from datarobot.models.full_api.generated.model.user_notification_list_response import UserNotificationListResponse


class UserNotificationsApi(APIObject):

        @classmethod
        def notification_channels_create(
            cls,
            **kwargs
        ):
            """Create notification channel

            Create a new notification channel.

            Keyword Args:
                notification_channel_create (NotificationChannelCreate): [optional]
            Returns:
                NotificationChannelResponse
            """
            path_args = {}
            path = '/api/v2/notificationChannels/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationChannelResponse(**server_data)

        @classmethod
        def notification_channels_delete(
            cls,
            channel_id,
            **kwargs
        ):
            """Delete notification channel

            Delete the notification channel.
            Args:
                channel_id (str): The id of the notification channel.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['channel_id'] = channel_id
            path_args['channelId'] = channel_id
            path = '/api/v2/notificationChannels/{channelId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def notification_channels_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List notification channels

            List the notification channels according to the query.
            Args:
                offset (int): How many notification channels to skip.. defaults to 0, must be one of [0]
                limit (int): At most this many notification channels to return.. defaults to 100, must be one of [100]

            Keyword Args:
                name_part (str): Only return the notification channels whose names contain the given substring.. [optional]
            Returns:
                NotificationChannelsListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/notificationChannels/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationChannelsListResponse(**server_data)

        @classmethod
        def notification_channels_put(
            cls,
            channel_id,
            **kwargs
        ):
            """Update notification channel

            Update the notification channel.
            Args:
                channel_id (str): The id of the notification channel.

            Keyword Args:
                notification_channel_update (NotificationChannelUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['channel_id'] = channel_id
            path_args['channelId'] = channel_id
            path = '/api/v2/notificationChannels/{channelId}/'.format(**path_args)
            cls._client.put(path, data=kwargs)

        @classmethod
        def notification_channels_retrieve(
            cls,
            channel_id,
            **kwargs
        ):
            """Retrieve notification channel

            Retrieve the notification channel.
            Args:
                channel_id (str): The id of the notification channel.

            Keyword Args:
            Returns:
                NotificationChannelResponse
            """
            path_args = {}
            kwargs['channel_id'] = channel_id
            path_args['channelId'] = channel_id
            path = '/api/v2/notificationChannels/{channelId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationChannelResponse(**server_data)

        @classmethod
        def notification_email_channel_verification_create(
            cls,
            **kwargs
        ):
            """Sending a 6 digit verification code to user's email

            Sending a 6 digit verification code to user's email

            Keyword Args:
                notification_email_channel_verification (NotificationEmailChannelVerification): [optional]
            Returns:
                NotificationEmailChannelVerificationResponse
            """
            path_args = {}
            path = '/api/v2/notificationEmailChannelVerification/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationEmailChannelVerificationResponse(**server_data)

        @classmethod
        def notification_email_channel_verification_status_create(
            cls,
            **kwargs
        ):
            """Retrieve the status of whether admin enter code correctly

            Retrieve the status of whether admin enter code correctly

            Keyword Args:
                notification_email_channel_verification_status (NotificationEmailChannelVerificationStatus): [optional]
            Returns:
                NotificationEmailChannelVerificationStatusResponse
            """
            path_args = {}
            path = '/api/v2/notificationEmailChannelVerificationStatus/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationEmailChannelVerificationStatusResponse(**server_data)

        @classmethod
        def notification_policies_create(
            cls,
            **kwargs
        ):
            """Create notification policy

            Create a new notification policy.

            Keyword Args:
                notification_policy_create (NotificationPolicyCreate): [optional]
            Returns:
                NotificationPolicyResponse
            """
            path_args = {}
            path = '/api/v2/notificationPolicies/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationPolicyResponse(**server_data)

        @classmethod
        def notification_policies_delete(
            cls,
            policy_id,
            **kwargs
        ):
            """Delete notification policy

            Delete the notification policy.
            Args:
                policy_id (str): The id of the notification policy

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['policy_id'] = policy_id
            path_args['policyId'] = policy_id
            path = '/api/v2/notificationPolicies/{policyId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def notification_policies_list(
            cls,
            offset=0,
            limit=100,
            **kwargs
        ):
            """List notification policies

            List the notification policies that satisfy the query condition.
            Args:
                offset (int): How many notification channels to skip.. defaults to 0, must be one of [0]
                limit (int): At most this many notification channels to return.. defaults to 100, must be one of [100]

            Keyword Args:
                channel_id (str): Return policies with this channel.. [optional]
                name_part (str): Only return the notification channels whose names contain the given substring.. [optional]
                event_group (str): Return policies with this event group.. [optional]
            Returns:
                NotificationPoliciesListResponse
            """
            path_args = {}
            kwargs['offset'] = offset
            path_args['offset'] = offset
            kwargs['limit'] = limit
            path_args['limit'] = limit
            path = '/api/v2/notificationPolicies/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationPoliciesListResponse(**server_data)

        @classmethod
        def notification_policies_put(
            cls,
            policy_id,
            **kwargs
        ):
            """Update notification policy

            Update the notification policy.
            Args:
                policy_id (str): The id of the notification policy

            Keyword Args:
                notification_policy_update (NotificationPolicyUpdate): [optional]
            Returns:
                None
            """
            path_args = {}
            kwargs['policy_id'] = policy_id
            path_args['policyId'] = policy_id
            path = '/api/v2/notificationPolicies/{policyId}/'.format(**path_args)
            cls._client.put(path, data=kwargs)

        @classmethod
        def notification_policies_retrieve(
            cls,
            policy_id,
            **kwargs
        ):
            """Retrieve notification policy

            Retrieve the notification policy.
            Args:
                policy_id (str): The id of the notification policy

            Keyword Args:
            Returns:
                NotificationPolicyResponse
            """
            path_args = {}
            kwargs['policy_id'] = policy_id
            path_args['policyId'] = policy_id
            path = '/api/v2/notificationPolicies/{policyId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationPolicyResponse(**server_data)

        @classmethod
        def notification_webhook_channel_tests_create(
            cls,
            **kwargs
        ):
            """Test webhook notification channel

            Test the webhook notification channel.

            Keyword Args:
                notification_webhook_channel_test_create (NotificationWebhookChannelTestCreate): [optional]
            Returns:
                NotificationWebhookChannelTestId
            """
            path_args = {}
            path = '/api/v2/notificationWebhookChannelTests/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationWebhookChannelTestId(**server_data)

        @classmethod
        def notification_webhook_channel_tests_retrieve(
            cls,
            notification_id,
            **kwargs
        ):
            """Retrieve status of notification channel test

            Retrieve the status of the notification channel test.
            Args:
                notification_id (str): The identifier of the notification.

            Keyword Args:
            Returns:
                NotificationWebhookChannelStatusResponse
            """
            path_args = {}
            kwargs['notification_id'] = notification_id
            path_args['notificationId'] = notification_id
            path = '/api/v2/notificationWebhookChannelTests/{notificationId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return NotificationWebhookChannelStatusResponse(**server_data)

        @classmethod
        def remote_events_create(
            cls,
            **kwargs
        ):
            """Post a remote deployment event

            Post an event from a remote deployment.

            Keyword Args:
                remote_event_create (RemoteEventCreate): [optional]
            Returns:
                CreateRemoteEventResponse
            """
            path_args = {}
            path = '/api/v2/remoteEvents/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return CreateRemoteEventResponse(**server_data)

        @classmethod
        def user_notifications_delete(
            cls,
            user_notification_id,
            **kwargs
        ):
            """Delete user notification

            Delete one notification associated with the user.
            Args:
                user_notification_id (str): Unique identifier of the notification.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['user_notification_id'] = user_notification_id
            path_args['userNotificationId'] = user_notification_id
            path = '/api/v2/userNotifications/{userNotificationId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_notifications_delete_many(
            cls,
            **kwargs
        ):
            """Delete all user notifications

            Delete all notifications associated with the user.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/userNotifications/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_notifications_list(
            cls,
            **kwargs
        ):
            """List user notifications

            Returns list of user's notifications from latest to oldest.

            Keyword Args:
                offset (int): The number of records to skip over. [optional] if omitted the server will use the default value of 0
                limit (int): The number of records to return. [optional] if omitted the server will use the default value of 100
                is_read (bool): When provided, returns only read or unread notifications. [optional]
            Returns:
                UserNotificationListResponse
            """
            path_args = {}
            path = '/api/v2/userNotifications/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UserNotificationListResponse(**server_data)

        @classmethod
        def user_notifications_patch(
            cls,
            user_notification_id,
            **kwargs
        ):
            """Mark as read

            Mark one associated notification with the user as read.
            Args:
                user_notification_id (str): Unique identifier of the notification.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['user_notification_id'] = user_notification_id
            path_args['userNotificationId'] = user_notification_id
            path = '/api/v2/userNotifications/{userNotificationId}/'.format(**path_args)
            cls._client.patch(path)

        @classmethod
        def user_notifications_patch_many(
            cls,
            **kwargs
        ):
            """Mark all as read

            Mark all associated notifications with the user as read.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            path = '/api/v2/userNotifications/'.format(**path_args)
            cls._client.patch(path)

