#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.users_permadelete import UsersPermadelete
from datarobot.models.full_api.generated.model.users_permadelete_delete_report_params_response import UsersPermadeleteDeleteReportParamsResponse
from datarobot.models.full_api.generated.model.users_permadelete_job_response import UsersPermadeleteJobResponse
from datarobot.models.full_api.generated.model.users_permadelete_job_status_response import UsersPermadeleteJobStatusResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_job_response import UsersPermadeletePreviewJobResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_job_status_response import UsersPermadeletePreviewJobStatusResponse
from datarobot.models.full_api.generated.model.users_permadelete_preview_statistics_response import UsersPermadeletePreviewStatisticsResponse
from datarobot.models.full_api.generated.model.users_permadelete_summary_report_statistics_response import UsersPermadeleteSummaryReportStatisticsResponse


class UsersPermadeleteApi(APIObject):

        @classmethod
        def user_cleanup_jobs_create(
            cls,
            **kwargs
        ):
            """Users permanent delete.

            Schedules a job which permanently delete the users represented by the provided users ids or organization id. Number of users to be deleted in one go is restricted by DELETED_USERS_BATCH_LIMIT system setting.

            Keyword Args:
                users_permadelete (UsersPermadelete): [optional]
            Returns:
                UsersPermadeleteJobResponse
            """
            path_args = {}
            path = '/api/v2/userCleanupJobs/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeleteJobResponse(**server_data)

        @classmethod
        def user_cleanup_jobs_delete(
            cls,
            status_id,
            **kwargs
        ):
            """Cancel users perma-deletion.

            Cancel permanent deletion of the selected users.
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/userCleanupJobs/{statusId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_cleanup_jobs_retrieve(
            cls,
            status_id,
            **kwargs
        ):
            """Retrieve users perma-delete job status.

            Get async status of the users perma-delete job.
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                UsersPermadeleteJobStatusResponse
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/userCleanupJobs/{statusId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeleteJobStatusResponse(**server_data)

        @classmethod
        def user_cleanup_preview_jobs_create(
            cls,
            **kwargs
        ):
            """Users permanent delete preview.

            Schedules a job for building preview for users selected for permanent deletion. Number of users to be deleted in one go is restricted by DELETED_USERS_BATCH_LIMIT system setting.

            Keyword Args:
                users_permadelete (UsersPermadelete): [optional]
            Returns:
                UsersPermadeletePreviewJobResponse
            """
            path_args = {}
            path = '/api/v2/userCleanupPreviewJobs/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeletePreviewJobResponse(**server_data)

        @classmethod
        def user_cleanup_preview_jobs_delete(
            cls,
            status_id,
            **kwargs
        ):
            """Cancel users perma-delete preview building.

            Cancel scheduled users permanent delete preview building.
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/userCleanupPreviewJobs/{statusId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_cleanup_preview_jobs_retrieve(
            cls,
            status_id,
            **kwargs
        ):
            """Retrieve users perma-delete preview job status.

            Get async status of the users perma-delete preview building job.
            Args:
                status_id (str): The ID of the status object.

            Keyword Args:
            Returns:
                UsersPermadeletePreviewJobStatusResponse
            """
            path_args = {}
            kwargs['status_id'] = status_id
            path_args['statusId'] = status_id
            path = '/api/v2/userCleanupPreviewJobs/{statusId}/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeletePreviewJobStatusResponse(**server_data)

        @classmethod
        def user_cleanup_previews_content_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete extended preview.

            Retrieve users permanent delete extended preview.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupPreviews/{reportId}/content/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def user_cleanup_previews_delete(
            cls,
            report_id,
            **kwargs
        ):
            """Delete users permanent delete report.

            Delete users permanent delete report.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupPreviews/{reportId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_cleanup_previews_delete_params_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete report parameters.

            Retrieve users permanent delete report parameters.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                UsersPermadeleteDeleteReportParamsResponse
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupPreviews/{reportId}/deleteParams/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeleteDeleteReportParamsResponse(**server_data)

        @classmethod
        def user_cleanup_previews_statistics_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete preview statistics.

            Retrieve users permanent delete preview statistics.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                UsersPermadeletePreviewStatisticsResponse
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupPreviews/{reportId}/statistics/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeletePreviewStatisticsResponse(**server_data)

        @classmethod
        def user_cleanup_summaries_content_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete extended summary.

            Retrieve users permanent delete extended summary.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupSummaries/{reportId}/content/'.format(**path_args)
            cls._client.get(path)

        @classmethod
        def user_cleanup_summaries_delete(
            cls,
            report_id,
            **kwargs
        ):
            """Delete users permanent delete report.

            Delete users permanent delete report.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                None
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupSummaries/{reportId}/'.format(**path_args)
            cls._client.delete(path)

        @classmethod
        def user_cleanup_summaries_delete_params_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete report parameters.

            Retrieve users permanent delete report parameters.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                UsersPermadeleteDeleteReportParamsResponse
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupSummaries/{reportId}/deleteParams/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeleteDeleteReportParamsResponse(**server_data)

        @classmethod
        def user_cleanup_summaries_statistics_list(
            cls,
            report_id,
            **kwargs
        ):
            """Users permanent delete summary statistics.

            Retrieve users permanent delete summary statistics.
            Args:
                report_id (str): Report ID

            Keyword Args:
            Returns:
                UsersPermadeleteSummaryReportStatisticsResponse
            """
            path_args = {}
            kwargs['report_id'] = report_id
            path_args['reportId'] = report_id
            path = '/api/v2/userCleanupSummaries/{reportId}/statistics/'.format(**path_args)
            server_data = (cls._client.get(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return UsersPermadeleteSummaryReportStatisticsResponse(**server_data)

