#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""


import json
import re
from datarobot.models.api_object import APIObject
from datarobot.utils import underscorize
from datarobot.utils import ALL_CAPITAL
from datarobot.utils import CASE_SWITCH
from datarobot.utils import UNDERSCORES
from datarobot.models.full_api.generated.model.string_encryption import StringEncryption
from datarobot.models.full_api.generated.model.string_encryption_response import StringEncryptionResponse


class UtilitiesApi(APIObject):

        @classmethod
        def string_encryptions_create(
            cls,
            **kwargs
        ):
            """Encrypt a string which DataRobot can decrypt.

            DataRobot does not store your credentials when accessing external data stores. Instead you first encrypt your sensitive information with DataRobot and then, when accessing those data stores, supply the encrypted credentials. DataRobot will decrypt your credentials and use them to establish a connection to your data store.

            Keyword Args:
                string_encryption (StringEncryption): [optional]
            Returns:
                StringEncryptionResponse
            """
            path_args = {}
            path = '/api/v2/stringEncryptions/'.format(**path_args)
            server_data = (cls._client.post(path, data=kwargs)).json()
            server_data = {underscorize(key): val for key, val in server_data.items()}
            return StringEncryptionResponse(**server_data)

