#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AccessControl(APIObject):
    """
    Attributes
    ----------
    can_share:bool
         Whether the recipient can share the role further.
    role:str
         The role of the user on this entity.
    user_id:str
         The identifier of the user that has access to this entity.
    username:str
         The username of the user that has access to the entity.
    """
    _converter = t.Dict(
        {
            t.Key("can_share"):  t.Bool(),
            t.Key("role"):  t.String(),
            t.Key("user_id"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_share,
        role,
        user_id,
        username,
    ):
        self.can_share = can_share
        self.role = role
        self.user_id = user_id
        self.username = username

    def __repr__(self):
        return (
            "AccessControl("
            "can_share={0.can_share}, "
            "role={0.role}, "
            "user_id={0.user_id}, "
            "username={0.username}, "
        ).format(self)
