#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AccessControlWithGrant(APIObject):
    """
    Attributes
    ----------
    can_share:bool
         Whether the recipient can share the role further.
    id:str
         The identifier of the recipient.
    name:str
         The name of the recipient.
    role:str
         The role of the recipient on this entity.
    share_recipient_type:str
         The type of the recipient.
    user_full_name:str [optional]
         Full name of the recipient user.. 
    """
    _converter = t.Dict(
        {
            t.Key("can_share"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("name"):  t.String(),
            t.Key("role"):  t.String(),
            t.Key("share_recipient_type"):  t.String(),
            t.Key("user_full_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_share,
        id,
        name,
        role,
        share_recipient_type,
        user_full_name=None,
    ):
        self.can_share = can_share
        self.id = id
        self.name = name
        self.role = role
        self.share_recipient_type = share_recipient_type
        self.user_full_name = user_full_name

    def __repr__(self):
        return (
            "AccessControlWithGrant("
            "can_share={0.can_share}, "
            "id={0.id}, "
            "name={0.name}, "
            "role={0.role}, "
            "share_recipient_type={0.share_recipient_type}, "
            "user_full_name={0.user_full_name}, "
        ).format(self)
