#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.time_range import TimeRange

class AccuracyOverTimeBucket(APIObject):
    """
    Attributes
    ----------
    period:TimeRange
        
    sample_size:int, none_type
         Number of predictions used to calculate the metric.
    value:float, none_type
         Value of the metric, null if no value.
    value_per_class:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}, none_type [optional]
         A dict keyed by class names with metric calculated for specific classes as values, if targetClasses is set.. 
    """
    _converter = t.Dict(
        {
            t.Key("period"):  t.Any(),
            t.Key("sample_size"):  t.Int(),
            t.Key("value"):  t.Float(),
            t.Key("value_per_class", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        period,
        sample_size,
        value,
        value_per_class=None,
    ):
        self.period = period
        self.sample_size = sample_size
        self.value = value
        self.value_per_class = value_per_class

    def __repr__(self):
        return (
            "AccuracyOverTimeBucket("
            "period={0.period}, "
            "sample_size={0.sample_size}, "
            "value={0.value}, "
            "value_per_class={0.value_per_class}, "
        ).format(self)
