#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AccuracyOverTimePlotsBins(APIObject):
    """
    Attributes
    ----------
    actual:float, none_type
         Average actual value of the target in the bin. `null` if there are no entries in the bin.
    end_date:datetime
         The datetime of the end of the bin (exclusive). 
    frequency:int, none_type
         Indicates number of values averaged in bin in case of a resolution change.
    predicted:float, none_type
         Average prediction of the model in the bin. `null` if there are no entries in the bin.
    start_date:datetime
         The datetime of the start of the bin (inclusive). 
    """
    _converter = t.Dict(
        {
            t.Key("actual"):  t.Float(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("frequency"):  t.Int(),
            t.Key("predicted"):  t.Float(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual,
        end_date,
        frequency,
        predicted,
        start_date,
    ):
        self.actual = actual
        self.end_date = end_date
        self.frequency = frequency
        self.predicted = predicted
        self.start_date = start_date

    def __repr__(self):
        return (
            "AccuracyOverTimePlotsBins("
            "actual={0.actual}, "
            "end_date={0.end_date}, "
            "frequency={0.frequency}, "
            "predicted={0.predicted}, "
            "start_date={0.start_date}, "
        ).format(self)
