#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.time_range import TimeRange

class AccuracyRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    metrics:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}
         Accuracy metrics of the deployment, keyed by metric names,                                  each value is a `metric` object with detail on a single metric.                                  For classification deployments:                                  - LogLoss                                  - AUC                                  - Kolmogorov - Smirnov                                  - Gini Norm                                  - Rate @ Top10 %                                  For regression deployments:                                  - RMSE                                  - MAE                                  - Gamma Deviance                                  - Tweedie Deviance                                  - R Squared
    period:TimeRange
        
    model_id:str [optional]
         The id of the model for which metrics are being retrieved.. 
    segment_attribute:str, none_type [optional]
         The name of the segment on which segment analysis is being performed.. 
    segment_value:str, none_type [optional]
         The value of the `segmentAttribute` to segment on..  if omitted the server will use the default value of ""
    target_classes:str, none_type [optional]
         Target classes provided in the request.. 
    """
    _converter = t.Dict(
        {
            t.Key("metrics"):  t.Any(),
            t.Key("period"):  t.Any(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("segment_attribute", optional=True):  t.String(),
            t.Key("segment_value", optional=True):  t.String(),
            t.Key("target_classes", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        metrics,
        period,
        model_id=None,
        segment_attribute=None,
        segment_value=None,
        target_classes=None,
    ):
        self.metrics = metrics
        self.period = period
        self.model_id = model_id
        self.segment_attribute = segment_attribute
        self.segment_value = segment_value
        self.target_classes = target_classes

    def __repr__(self):
        return (
            "AccuracyRetrieveResponse("
            "metrics={0.metrics}, "
            "period={0.period}, "
            "model_id={0.model_id}, "
            "segment_attribute={0.segment_attribute}, "
            "segment_value={0.segment_value}, "
            "target_classes={0.target_classes}, "
        ).format(self)
