#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.activation_map_links import ActivationMapLinks

class ActivationMap(APIObject):
    """
    Attributes
    ----------
    activation_values:[[int]]
         A 2D matrix of values (row-major) representing the activation strengths for particular image regions.
    actual_target_value:bool, date, datetime, dict, float, int, list, str, none_type
         Actual target value of the dataset row.
    feature_name:str
         The name of the column containing the image value the activation map is based upon.
    image_height:int
         The height of the original image (in pixels) this activation map has been computed for.
    image_id:str
         ID of the original image this activation map has been computed for.
    image_width:int
         The width of the original image (in pixels) this activation map has been computed for.
    links:ActivationMapLinks
        
    overlay_image_id:str
         ID of the image containing the original image overlaid by the activation heatmap.
    predicted_target_value:bool, date, datetime, dict, float, int, list, str, none_type
         predicted target value of the dataset row containing this image.
    """
    _converter = t.Dict(
        {
            t.Key("activation_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("actual_target_value"):  t.Any(),
            t.Key("feature_name"):  t.String(),
            t.Key("image_height"):  t.Int(),
            t.Key("image_id"):  t.String(),
            t.Key("image_width"):  t.Int(),
            t.Key("links"):  t.Any(),
            t.Key("overlay_image_id"):  t.String(),
            t.Key("predicted_target_value"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        activation_values,
        actual_target_value,
        feature_name,
        image_height,
        image_id,
        image_width,
        links,
        overlay_image_id,
        predicted_target_value,
    ):
        self.activation_values = activation_values
        self.actual_target_value = actual_target_value
        self.feature_name = feature_name
        self.image_height = image_height
        self.image_id = image_id
        self.image_width = image_width
        self.links = links
        self.overlay_image_id = overlay_image_id
        self.predicted_target_value = predicted_target_value

    def __repr__(self):
        return (
            "ActivationMap("
            "activation_values={0.activation_values}, "
            "actual_target_value={0.actual_target_value}, "
            "feature_name={0.feature_name}, "
            "image_height={0.image_height}, "
            "image_id={0.image_id}, "
            "image_width={0.image_width}, "
            "links={0.links}, "
            "overlay_image_id={0.overlay_image_id}, "
            "predicted_target_value={0.predicted_target_value}, "
        ).format(self)
