#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.activation_map import ActivationMap
from datarobot.models.full_api.generated.model.target_bin import TargetBin

class ActivationMapsRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    activation_map_height:int, none_type
         The height of each activation map (the number of rows in each activationValues matrix).
    activation_map_width:int, none_type
         The width of each activation map (the number of items in each row of each activationValues matrix).
    activation_maps:[ActivationMap]
         List of activation map objects
    target_bins:[TargetBin], none_type
         List of bin objects for regression or null
    target_values:[str], none_type
         List of target values for classification or null
    """
    _converter = t.Dict(
        {
            t.Key("activation_map_height"):  t.Int(),
            t.Key("activation_map_width"):  t.Int(),
            t.Key("activation_maps"):  t.List(t.Dict().allow_extra("*")),
            t.Key("target_bins"):  t.List(t.Dict().allow_extra("*")),
            t.Key("target_values"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        activation_map_height,
        activation_map_width,
        activation_maps,
        target_bins,
        target_values,
    ):
        self.activation_map_height = activation_map_height
        self.activation_map_width = activation_map_width
        self.activation_maps = activation_maps
        self.target_bins = target_bins
        self.target_values = target_values

    def __repr__(self):
        return (
            "ActivationMapsRetrieveResponse("
            "activation_map_height={0.activation_map_height}, "
            "activation_map_width={0.activation_map_width}, "
            "activation_maps={0.activation_maps}, "
            "target_bins={0.target_bins}, "
            "target_values={0.target_values}, "
        ).format(self)
