#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class Actual(APIObject):
    """
    Attributes
    ----------
    actual_value:bool, date, datetime, dict, float, int, list, str, none_type
         The actual value of a prediction. Will be numeric for regression models and a string label for classification models.
    association_id:str
         A unique identifier used with a predicted row.
    timestamp:datetime, none_type [optional]
         The datetime when actual values were obtained, formatted according to RFC3339.. 
    was_acted_on:bool, none_type [optional]
         Indicates if the prediction was acted on in a way that could have affected the actual outcome. For example, if a hospital patient is predicted to be readmitted in 30 days, extra procedures or new medication might be given to mitigate this problem, influencing the actual outcome of the prediction.. 
    """
    _converter = t.Dict(
        {
            t.Key("actual_value"):  t.Any(),
            t.Key("association_id"):  t.String(),
            t.Key("timestamp", optional=True):  t.DateTime(),
            t.Key("was_acted_on", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        actual_value,
        association_id,
        timestamp=None,
        was_acted_on=None,
    ):
        self.actual_value = actual_value
        self.association_id = association_id
        self.timestamp = timestamp
        self.was_acted_on = was_acted_on

    def __repr__(self):
        return (
            "Actual("
            "actual_value={0.actual_value}, "
            "association_id={0.association_id}, "
            "timestamp={0.timestamp}, "
            "was_acted_on={0.was_acted_on}, "
        ).format(self)
