#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AddDeploymentToApplication(APIObject):
    """
    Attributes
    ----------
    model_deployment_id:str
         The ID of the model deployment to link to the application.
    link_name:str [optional]
         Internal name of deployment to match in the application. 
    """
    _converter = t.Dict(
        {
            t.Key("model_deployment_id"):  t.String(),
            t.Key("link_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_deployment_id,
        link_name=None,
    ):
        self.model_deployment_id = model_deployment_id
        self.link_name = link_name

    def __repr__(self):
        return (
            "AddDeploymentToApplication("
            "model_deployment_id={0.model_deployment_id}, "
            "link_name={0.link_name}, "
        ).format(self)
