#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.tuning_parameters import TuningParameters

class AdvancedTuningArgumentsRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    tuning_description:str, none_type
         Human-readable description of the tuned model, if specified by the user. `null` if unspecified.
    tuning_parameters:[TuningParameters]
         An array of objects containing information about tuning parameters that are supported by the specified model.
    """
    _converter = t.Dict(
        {
            t.Key("tuning_description"):  t.String(),
            t.Key("tuning_parameters"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        tuning_description,
        tuning_parameters,
    ):
        self.tuning_description = tuning_description
        self.tuning_parameters = tuning_parameters

    def __repr__(self):
        return (
            "AdvancedTuningArgumentsRetrieveResponse("
            "tuning_description={0.tuning_description}, "
            "tuning_parameters={0.tuning_parameters}, "
        ).format(self)
