#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.backtest import Backtest
from datarobot.models.full_api.generated.model.class_mapping_aggregation_settings import ClassMappingAggregationSettings
from datarobot.models.full_api.generated.model.feature_setting import FeatureSetting
from datarobot.models.full_api.generated.model.periodicity import Periodicity

class Aim(APIObject):
    """
    Attributes
    ----------
    autopilot_data_selection_method:str
         The Data Selection method to be used by autopilot when creating models for datetime-partitioned datasets.. defaults to "duration", must be one of ["duration", "rowCount", ]
    only_include_monotonic_blueprints:bool
         When true, only blueprints that support enforcing montonic constraints will be available in the project or selected for autopilot.. defaults to False
    accuracy_optimized_mb:bool [optional]
         Include additional, longer-running models that will be run by the autopilot and available to run manually.. 
    aggregation_type:str [optional]
         For multiseries projects only. The aggregation type to apply when creating cross-series features.. 
    allow_partial_history_time_series_predictions:bool [optional]
         Specifies whether the time series predictions can use partial historical data.. 
    allowed_pairwise_interaction_groups:[[str]], none_type [optional]
         For GAM models - specify groups of columns for which pairwise interactions will be allowed. E.g. if set to [['A', 'B', 'C'], ['C', 'D']] then GAM models will allow interactions between columns AxB, BxC, AxC, CxD. All others (AxD, BxD) will not be considered. If not specified - all possible interactions will be considered by model.. 
    anomaly_detection_context_columns:[str] [optional]
         The context features to be used for anomaly detection.. 
    autopilot_cluster_list:[int], none_type [optional]
         A list of integers where each value will be used as the number of clusters in Autopilot model(s) for unsupervised clustering projects. Cannot be specified unless `unsupervisedMode` is true and `unsupervisedType` is set to `clustering`.. 
    autopilot_data_sampling_method:str [optional]
         Defines how autopilot will select subsample from training dataset in OTV/TS projects. Defaults to 'latest' for 'rowCount' dataSelectionMethod and to 'random' for 'duration'.. 
    autopilot_with_feature_discovery:bool [optional]
         If true, autopilot will run on a feature list that includes features found via search for interactions.. 
    backtests:[Backtest] [optional]
         An array specifying the format of the backtests.. 
    blend_best_models:bool [optional]
         Blend best models during Autopilot run. This option is not supported in SHAP-only mode or for multilabel projects.. 
    blueprint_threshold:int, none_type [optional]
         The runtime (in hours) which if exceeded will exclude a model from autopilot runs.. 
    calendar_id:str [optional]
         The ID of the calendar to be used in this project.. 
    class_mapping_aggregation_settings:ClassMappingAggregationSettings [optional]
         
    consider_blenders_in_recommendation:bool [optional]
         Include blenders when selecting a model to prepare for deployment in an Autopilot Run. This option is not supported in SHAP-only mode or for multilabel projects.. 
    credentials:[bool, date, datetime, dict, float, int, list, str, none_type] [optional]
         List of credentials for the secondary datasets used in feature discovery project.. 
    cross_series_group_by_columns:[str] [optional]
         For multiseries projects with cross-series features enabled only. List of columns (currently of length 1). Setting that indicates how to further split series into related groups. For example, if every series is sales of an individual product, the series group-by could be the product category with values like \"men's clothing\", \"sports equipment\", etc.. 
    cv_holdout_level:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The value of the partition column indicating a row is part of the holdout set. This level is optional - if not specified or if provided as ``null``, then no holdout will be used in the project. The rest of the levels indicate which cross validation fold each row should fall into.. 
    cv_method:str [optional]
         The partitioning method to be applied to the training data.. 
    date_removal:bool [optional]
         If true, enable creating additional feature lists without dates (does not apply to time-aware projects).. 
    datetime_partition_column:str [optional]
         The date column that will be used as a datetime partition column.. 
    default_to_a_priori:bool [optional]
         Renamed to `defaultToKnownInAdvance`.. 
    default_to_do_not_derive:bool [optional]
         For time series projects only. Sets whether all features default to being treated as do-not-derive features, excluding them from feature derivation. Individual features can be set to a value different than the default by using the `featureSettings` parameter.. 
    default_to_known_in_advance:bool [optional]
         For time series projects only. Sets whether all features default to being treated as known in advance features, which are features that are known into the future. Features marked as known in advance must be specified into the future when making predictions. The default is false, all features are not known in advance. Individual features can be set to a value different than the default using the `featureSettings` parameter. See the :ref:`Time Series Overview <time_series_overview>` for more context.. 
    differencing_method:str [optional]
         For time series projects only. Used to specify which differencing method to apply if the data is stationary. For classification problems `simple` and `seasonal` are not allowed. Parameter `periodicities` must be specified if `seasonal` is chosen. Defaults to `auto`.. 
    disable_holdout:bool [optional]
         Whether to suppress allocating a holdout fold. If `disableHoldout` is set to true, `holdoutStartDate` and `holdoutDuration` must not be set..  if omitted the server will use the default value of False
    events_count:str [optional]
         The name of a column specifying events count. The data in this column must be pure numeric and non negative without missing values. 
    exponentially_weighted_moving_alpha:float [optional]
         Discount factor (alpha) used for exponentially weighted moving features. 
    exposure:str [optional]
         The name of a column specifying row exposure.The data in this column must be pure numeric (e.g. not currency, date, length, etc.) and without missing values. 
    external_time_series_baseline_dataset_id:str [optional]
         Catalog version id for external prediction data that can be used as a baseline to calculate new metrics.. 
    external_time_series_baseline_dataset_name:str, none_type [optional]
         The name of the time series baseline dataset for the project.. 
    fairness_metrics_set:str [optional]
         Metric to use for calculating fairness. Can be one of ``proportionalParity``, ``equalParity``, ``predictionBalance``, ``trueFavorableAndUnfavorableRateParity`` or ``FavorableAndUnfavorablePredictiveValueParity``. Used and required only if *Bias & Fairness in AutoML* feature is enabled.. 
    fairness_threshold:float [optional]
         Threshold value of the fairness metric. Can be in a range of ``[0:1]``. If the actual metric value is below the threshold, the user will be notified . 
    feature_derivation_window_end:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should end.. 
    feature_derivation_window_start:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the past relative to the forecast point the feature derivation window should begin.. 
    feature_discovery_supervised_feature_reduction:bool [optional]
         Run supervised feature reduction for feature discovery projects.. 
    feature_engineering_prediction_point:str, none_type [optional]
         The date column to be used as prediction point for time-based feature engineering.. 
    feature_settings:[FeatureSetting] [optional]
         An array specifying per feature settings. Features can be left unspecified.. 
    featurelist_id:str [optional]
         The ID of a featurelist to use for autopilot.. 
    forecast_window_end:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should end.. 
    forecast_window_start:int [optional]
         For time series projects only. How many timeUnits of the datetimePartitionColumn into the future relative to the forecast point the forecast window should start.. 
    gap_duration:str [optional]
         The duration of the gap between holdout training and holdout scoring data. For time series projects, defaults to the duration of the gap between the end of the feature derivation window and the beginning of the forecast window. For OTV projects, defaults to a zero duration (P0Y0M0D).. 
    holdout_duration:str [optional]
         The duration of holdout scoring data. When specifying `holdoutDuration`, `holdoutStartDate` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    holdout_end_date:datetime [optional]
         The end date of holdout scoring data. When specifying `holdoutEndDate`, `holdoutStartDate` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    holdout_level:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The value of the partition column indicating a row is part of the holdout set. This level is optional - if not specified or if provided as ``null``, then no holdout will be used in the project. However, the column must have exactly 2 values in order for this option to be valid. 
    holdout_pct:float [optional]
         The percentage of the dataset to assign to the holdout set. 
    holdout_start_date:datetime [optional]
         The start date of holdout scoring data. When specifying `holdoutStartDate`, one of `holdoutEndDate` or `holdoutDuration` must also be specified. This attribute cannot be specified when `disableHoldout` is true.. 
    majority_downsampling_rate:float [optional]
         The percentage between 0 and 100 of the majority rows that should be kept. Must be specified only if using smart downsampling. If not specified, a default will be selected based on the dataset distribution. The chosen rate may not cause the majority class to become smaller than the minority class.. 
    metric:str [optional]
         The metric to use to select the best models. See `/api/v2/projects/(projectId)/features/metrics/` for the metrics that may be valid for a potential target.  Note that weighted metrics must be used with a weights column.. 
    min_secondary_validation_model_count:int [optional]
         Compute 'All backtest' scores (datetime models) or cross validation scores for the specified number of highest ranking models on the Leaderboard, if over the Autopilot default.. 
    mode:str [optional]
         The autopilot mode to use.  Either 'quick', 'auto', 'manual' or 'comprehensive'. 
    model_splits:int [optional]
         Sets the cap on the number of jobs per model used when building models to control number of jobs in the queue. Higher number of modelSplits will allow for less downsampling leading to the use of more post-processed data. .  if omitted the server will use the default value of 5
    monotonic_decreasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target.  If null, no such constraints are enforced. When specified, this will set a default for the project that can be overriden at model submission time if desired.. 
    monotonic_increasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If null, no such constraints are enforced. When specified, this will set a default for the project that can be overriden at model submission time if desired.. 
    multiseries_id_columns:[str] [optional]
         May be used only with time series projects. An array of the column names identifying  the series to which each row of the dataset belongs. Currently only one multiseries ID column is supported. See the :ref:`multiseries <multiseries>` section of the time series documentation for more context.. 
    number_of_backtests:int [optional]
         The number of backtests to use. If omitted, defaults to a positive value selected by the server based on the validation and gap durations.. 
    offset:[str] [optional]
         An array of strings with names of a columns specifying row offsets.The data in this column must be pure numeric (e.g. not currency, date, length, etc.) and without missing values. 
    partition_key_cols:[str] [optional]
         An array containing a single string - the name of the group partition column. 
    periodicities:[Periodicity] [optional]
         A list of periodicities for time series projects only. For classification problems periodicities are not allowed. If this is provided, parameter 'differencing_method' will default to 'seasonal' if not provided or 'auto'.. 
    positive_class:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         A value from the target column to use for the positive class. May only be specified for projects doing binary classification.If not specified, a positive class is selected automatically.. 
    preferable_target_value:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         A target value that should be treated as a positive outcome for the prediction. For example if we want to check gender discrimination for giving a loan and our target named ``is_bad``, then the positive outcome for the prediction would be ``No``, which means that the loan is good and that's what we treat as a preferable result for the loaner. Used and required only if *Bias & Fairness in AutoML* feature is enabled.. 
    prepare_model_for_deployment:bool [optional]
         Prepare model for deployment during Autopilot run. The preparation includes creating reduced feature list models, retraining best model on higher sample size, computing insights and assigning 'RECOMMENDED FOR DEPLOYMENT' label.. 
    primary_location_column:str, none_type [optional]
         Primary geospatial location column.. 
    protected_features:[str] [optional]
         A list of project feature to mark as protected for Bias metric calculation and Fairness correction. Used and required only if *Bias & Fairness in AutoML* feature is enabled.. 
    quantile_level:float [optional]
         The quantile level between 0.01 and 0.99 for specifying the Quantile metric.. 
    quickrun:bool [optional]
         (Deprecated): 'quick' should be used in the `mode` parameter instead of using this parameter. If set to `true`, will use a limited autopilot setting whose goal is to complete more quickly by trying a smaller number of models. Note: quickrun cannot be set to `true` when `mode` is set to 'comprehensive'.. 
    rate_top_pct_threshold:float [optional]
         The percentage threshold between 0.1 and 50 for specifying the Rate@Top% metric.. 
    relationships_configuration_id:str, none_type [optional]
         Relationships configuration id to be used for Feature Discovery projects.. 
    reps:int [optional]
         The number of cross validation folds to use.. 
    response_cap:float [optional]
         Used to cap the maximum response of a model. 
    run_leakage_removed_feature_list:bool [optional]
         Run Autopilot on Leakage Removed feature list (if exists).. 
    sample_step_pct:float [optional]
         A float between 0 and 100 indicating the desired percentage of data to sample when training models in comprehensive Autopilot. Note: this only supported for comprehensive Autopilot and the specified value may be lowered in order to be compatible with the project's dataset and partition settings.. 
    scaleout_modeling_mode:str [optional]
         Specifies the behavior of Scaleout models for the project. If `disabled`, no models will run during autopilot or show in the list of available blueprints. Scaleout models must be disabled for some partitioning settings including projects using datetime partitioning or projects using offset or exposure columns. If `repositoryOnly`, scaleout models will be in the list of available blueprints but not run during autopilot. If `autopilot`, scaleout models will run during autopilot and be in the list of available blueprints.. 
    scoring_code_only:bool [optional]
         Keep only models that can be converted to scorable java code during Autopilot run.. 
    seed:int [optional]
         A seed to use for randomization.. 
    segmentation_task_id:str, none_type [optional]
         Specifies the SegmentationTask that will be used for dividing the project up into multiple segmented projects.. 
    shap_only_mode:bool [optional]
         Keep only models that support SHAP values during Autopilot run. Use SHAP-based insights wherever possible.. 
    smart_downsampled:bool [optional]
         Whether to use smart downsampling to throw away excess rows of the majority class. Only applicable to classification and zero-boosted regression projects.. 
    stop_words:[str] [optional]
         A list of stop words to be used for text blueprints. Note: ``stop_words=True`` must be set in the blueprint preprocessing parameters for this list of stop words to actually be used during preprocessing.. 
    target:str [optional]
         The name of the target feature.. 
    target_type:str [optional]
         Used to specify the targetType to use for a project when it is ambiguous, i.e. a numeric target with a few unique values that could be used for either regression or multiclass.. 
    training_level:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The value of the partition column indicating a row is part of the training set.. 
    treat_as_exponential:str [optional]
         For time series projects only. Used to specify whether to treat data as exponential trend and apply transformations like log-transform. For classification problems `always` is not allowed..  if omitted the server will use the default value of "auto"
    unsupervised_mode:bool [optional]
         If True, unsupervised project (without target) will be created. ``target`` cannot be specified if ``unsupervisedMode`` is True..  if omitted the server will use the default value of False
    unsupervised_type:str, none_type [optional]
         The type of unsupervised project. Only valid when `unsupervisedMode` is true. If `unsupervisedMode`, defaults to `anomaly`.. 
    use_cross_series_features:bool [optional]
         Indicating if user wants to use cross-series features.. 
    use_project_settings:bool [optional]
         Specifies whether datetime-partitioned project should use project settings (i.e. backtests configuration has been modified by the user).. 
    use_supervised_feature_reduction:bool [optional]
         When true, during feature generation DataRobot runs a supervised algorithm feature lists using only qualifying features. Setting false can severely impact autopilot duration, especially for datasets with many features..  if omitted the server will use the default value of True
    use_time_series:bool [optional]
         A boolean value indicating whether a time series project should be created instead of a regular project which uses datetime partitioning..  if omitted the server will use the default value of False
    user_partition_col:str [optional]
         The name of the column containing the partition assignments.. 
    validation_duration:str [optional]
         The default validation duration for all backtests. If the primary date/time feature in a time series project is irregular, you cannot set a default validation length. Instead, set each duration individually.. 
    validation_level:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The value of the partition column indicating a row is part of the validation set.. 
    validation_pct:float [optional]
         The percentage of the dataset to assign to the validation set. 
    validation_type:str [optional]
         The validation method to be used.  CV for cross validation or TVH for train-validation-holdout split.. 
    weights:str [optional]
         The name of a column specifying row weights. The data in this column must be pure numeric (e.g. not currency, date, length, etc.) and without missing values. 
    windows_basis_unit:str [optional]
         For time series projects only. Indicates which unit is basis for feature derivation window and forecast window. Valid options are detected time unit or `ROW`. If omitted, the default value is detected time unit.. 
    """
    _converter = t.Dict(
        {
            t.Key("autopilot_data_selection_method"):  t.String(),
            t.Key("only_include_monotonic_blueprints"):  t.Bool(),
            t.Key("accuracy_optimized_mb", optional=True):  t.Bool(),
            t.Key("aggregation_type", optional=True):  t.String(),
            t.Key("allow_partial_history_time_series_predictions", optional=True):  t.Bool(),
            t.Key("allowed_pairwise_interaction_groups", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("anomaly_detection_context_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("autopilot_cluster_list", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("autopilot_data_sampling_method", optional=True):  t.String(),
            t.Key("autopilot_with_feature_discovery", optional=True):  t.Bool(),
            t.Key("backtests", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("blend_best_models", optional=True):  t.Bool(),
            t.Key("blueprint_threshold", optional=True):  t.Int(),
            t.Key("calendar_id", optional=True):  t.String(),
            t.Key("class_mapping_aggregation_settings", optional=True):  t.Any(),
            t.Key("consider_blenders_in_recommendation", optional=True):  t.Bool(),
            t.Key("credentials", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("cross_series_group_by_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("cv_holdout_level", optional=True):  t.Any(),
            t.Key("cv_method", optional=True):  t.String(),
            t.Key("date_removal", optional=True):  t.Bool(),
            t.Key("datetime_partition_column", optional=True):  t.String(),
            t.Key("default_to_a_priori", optional=True):  t.Bool(),
            t.Key("default_to_do_not_derive", optional=True):  t.Bool(),
            t.Key("default_to_known_in_advance", optional=True):  t.Bool(),
            t.Key("differencing_method", optional=True):  t.String(),
            t.Key("disable_holdout", optional=True):  t.Bool(),
            t.Key("events_count", optional=True):  t.String(),
            t.Key("exponentially_weighted_moving_alpha", optional=True):  t.Float(),
            t.Key("exposure", optional=True):  t.String(),
            t.Key("external_time_series_baseline_dataset_id", optional=True):  t.String(),
            t.Key("external_time_series_baseline_dataset_name", optional=True):  t.String(),
            t.Key("fairness_metrics_set", optional=True):  t.String(),
            t.Key("fairness_threshold", optional=True):  t.Float(),
            t.Key("feature_derivation_window_end", optional=True):  t.Int(),
            t.Key("feature_derivation_window_start", optional=True):  t.Int(),
            t.Key("feature_discovery_supervised_feature_reduction", optional=True):  t.Bool(),
            t.Key("feature_engineering_prediction_point", optional=True):  t.String(),
            t.Key("feature_settings", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("forecast_window_end", optional=True):  t.Int(),
            t.Key("forecast_window_start", optional=True):  t.Int(),
            t.Key("gap_duration", optional=True):  t.String(),
            t.Key("holdout_duration", optional=True):  t.String(),
            t.Key("holdout_end_date", optional=True):  t.DateTime(),
            t.Key("holdout_level", optional=True):  t.Any(),
            t.Key("holdout_pct", optional=True):  t.Float(),
            t.Key("holdout_start_date", optional=True):  t.DateTime(),
            t.Key("majority_downsampling_rate", optional=True):  t.Float(),
            t.Key("metric", optional=True):  t.String(),
            t.Key("min_secondary_validation_model_count", optional=True):  t.Int(),
            t.Key("mode", optional=True):  t.String(),
            t.Key("model_splits", optional=True):  t.Int(),
            t.Key("monotonic_decreasing_featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_increasing_featurelist_id", optional=True):  t.String(),
            t.Key("multiseries_id_columns", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("number_of_backtests", optional=True):  t.Int(),
            t.Key("offset", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("partition_key_cols", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("periodicities", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("positive_class", optional=True):  t.Any(),
            t.Key("preferable_target_value", optional=True):  t.Any(),
            t.Key("prepare_model_for_deployment", optional=True):  t.Bool(),
            t.Key("primary_location_column", optional=True):  t.String(),
            t.Key("protected_features", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("quantile_level", optional=True):  t.Float(),
            t.Key("quickrun", optional=True):  t.Bool(),
            t.Key("rate_top_pct_threshold", optional=True):  t.Float(),
            t.Key("relationships_configuration_id", optional=True):  t.String(),
            t.Key("reps", optional=True):  t.Int(),
            t.Key("response_cap", optional=True):  t.Float(),
            t.Key("run_leakage_removed_feature_list", optional=True):  t.Bool(),
            t.Key("sample_step_pct", optional=True):  t.Float(),
            t.Key("scaleout_modeling_mode", optional=True):  t.String(),
            t.Key("scoring_code_only", optional=True):  t.Bool(),
            t.Key("seed", optional=True):  t.Int(),
            t.Key("segmentation_task_id", optional=True):  t.String(),
            t.Key("shap_only_mode", optional=True):  t.Bool(),
            t.Key("smart_downsampled", optional=True):  t.Bool(),
            t.Key("stop_words", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("target", optional=True):  t.String(),
            t.Key("target_type", optional=True):  t.String(),
            t.Key("training_level", optional=True):  t.Any(),
            t.Key("treat_as_exponential", optional=True):  t.String(),
            t.Key("unsupervised_mode", optional=True):  t.Bool(),
            t.Key("unsupervised_type", optional=True):  t.String(),
            t.Key("use_cross_series_features", optional=True):  t.Bool(),
            t.Key("use_project_settings", optional=True):  t.Bool(),
            t.Key("use_supervised_feature_reduction", optional=True):  t.Bool(),
            t.Key("use_time_series", optional=True):  t.Bool(),
            t.Key("user_partition_col", optional=True):  t.String(),
            t.Key("validation_duration", optional=True):  t.String(),
            t.Key("validation_level", optional=True):  t.Any(),
            t.Key("validation_pct", optional=True):  t.Float(),
            t.Key("validation_type", optional=True):  t.String(),
            t.Key("weights", optional=True):  t.String(),
            t.Key("windows_basis_unit", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        autopilot_data_selection_method,
        only_include_monotonic_blueprints,
        accuracy_optimized_mb=None,
        aggregation_type=None,
        allow_partial_history_time_series_predictions=None,
        allowed_pairwise_interaction_groups=None,
        anomaly_detection_context_columns=None,
        autopilot_cluster_list=None,
        autopilot_data_sampling_method=None,
        autopilot_with_feature_discovery=None,
        backtests=None,
        blend_best_models=None,
        blueprint_threshold=None,
        calendar_id=None,
        class_mapping_aggregation_settings=None,
        consider_blenders_in_recommendation=None,
        credentials=None,
        cross_series_group_by_columns=None,
        cv_holdout_level=None,
        cv_method=None,
        date_removal=None,
        datetime_partition_column=None,
        default_to_a_priori=None,
        default_to_do_not_derive=None,
        default_to_known_in_advance=None,
        differencing_method=None,
        disable_holdout=None,
        events_count=None,
        exponentially_weighted_moving_alpha=None,
        exposure=None,
        external_time_series_baseline_dataset_id=None,
        external_time_series_baseline_dataset_name=None,
        fairness_metrics_set=None,
        fairness_threshold=None,
        feature_derivation_window_end=None,
        feature_derivation_window_start=None,
        feature_discovery_supervised_feature_reduction=None,
        feature_engineering_prediction_point=None,
        feature_settings=None,
        featurelist_id=None,
        forecast_window_end=None,
        forecast_window_start=None,
        gap_duration=None,
        holdout_duration=None,
        holdout_end_date=None,
        holdout_level=None,
        holdout_pct=None,
        holdout_start_date=None,
        majority_downsampling_rate=None,
        metric=None,
        min_secondary_validation_model_count=None,
        mode=None,
        model_splits=None,
        monotonic_decreasing_featurelist_id=None,
        monotonic_increasing_featurelist_id=None,
        multiseries_id_columns=None,
        number_of_backtests=None,
        offset=None,
        partition_key_cols=None,
        periodicities=None,
        positive_class=None,
        preferable_target_value=None,
        prepare_model_for_deployment=None,
        primary_location_column=None,
        protected_features=None,
        quantile_level=None,
        quickrun=None,
        rate_top_pct_threshold=None,
        relationships_configuration_id=None,
        reps=None,
        response_cap=None,
        run_leakage_removed_feature_list=None,
        sample_step_pct=None,
        scaleout_modeling_mode=None,
        scoring_code_only=None,
        seed=None,
        segmentation_task_id=None,
        shap_only_mode=None,
        smart_downsampled=None,
        stop_words=None,
        target=None,
        target_type=None,
        training_level=None,
        treat_as_exponential=None,
        unsupervised_mode=None,
        unsupervised_type=None,
        use_cross_series_features=None,
        use_project_settings=None,
        use_supervised_feature_reduction=None,
        use_time_series=None,
        user_partition_col=None,
        validation_duration=None,
        validation_level=None,
        validation_pct=None,
        validation_type=None,
        weights=None,
        windows_basis_unit=None,
    ):
        self.autopilot_data_selection_method = autopilot_data_selection_method
        self.only_include_monotonic_blueprints = only_include_monotonic_blueprints
        self.accuracy_optimized_mb = accuracy_optimized_mb
        self.aggregation_type = aggregation_type
        self.allow_partial_history_time_series_predictions = allow_partial_history_time_series_predictions
        self.allowed_pairwise_interaction_groups = allowed_pairwise_interaction_groups
        self.anomaly_detection_context_columns = anomaly_detection_context_columns
        self.autopilot_cluster_list = autopilot_cluster_list
        self.autopilot_data_sampling_method = autopilot_data_sampling_method
        self.autopilot_with_feature_discovery = autopilot_with_feature_discovery
        self.backtests = backtests
        self.blend_best_models = blend_best_models
        self.blueprint_threshold = blueprint_threshold
        self.calendar_id = calendar_id
        self.class_mapping_aggregation_settings = class_mapping_aggregation_settings
        self.consider_blenders_in_recommendation = consider_blenders_in_recommendation
        self.credentials = credentials
        self.cross_series_group_by_columns = cross_series_group_by_columns
        self.cv_holdout_level = cv_holdout_level
        self.cv_method = cv_method
        self.date_removal = date_removal
        self.datetime_partition_column = datetime_partition_column
        self.default_to_a_priori = default_to_a_priori
        self.default_to_do_not_derive = default_to_do_not_derive
        self.default_to_known_in_advance = default_to_known_in_advance
        self.differencing_method = differencing_method
        self.disable_holdout = disable_holdout
        self.events_count = events_count
        self.exponentially_weighted_moving_alpha = exponentially_weighted_moving_alpha
        self.exposure = exposure
        self.external_time_series_baseline_dataset_id = external_time_series_baseline_dataset_id
        self.external_time_series_baseline_dataset_name = external_time_series_baseline_dataset_name
        self.fairness_metrics_set = fairness_metrics_set
        self.fairness_threshold = fairness_threshold
        self.feature_derivation_window_end = feature_derivation_window_end
        self.feature_derivation_window_start = feature_derivation_window_start
        self.feature_discovery_supervised_feature_reduction = feature_discovery_supervised_feature_reduction
        self.feature_engineering_prediction_point = feature_engineering_prediction_point
        self.feature_settings = feature_settings
        self.featurelist_id = featurelist_id
        self.forecast_window_end = forecast_window_end
        self.forecast_window_start = forecast_window_start
        self.gap_duration = gap_duration
        self.holdout_duration = holdout_duration
        self.holdout_end_date = holdout_end_date
        self.holdout_level = holdout_level
        self.holdout_pct = holdout_pct
        self.holdout_start_date = holdout_start_date
        self.majority_downsampling_rate = majority_downsampling_rate
        self.metric = metric
        self.min_secondary_validation_model_count = min_secondary_validation_model_count
        self.mode = mode
        self.model_splits = model_splits
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.multiseries_id_columns = multiseries_id_columns
        self.number_of_backtests = number_of_backtests
        self.offset = offset
        self.partition_key_cols = partition_key_cols
        self.periodicities = periodicities
        self.positive_class = positive_class
        self.preferable_target_value = preferable_target_value
        self.prepare_model_for_deployment = prepare_model_for_deployment
        self.primary_location_column = primary_location_column
        self.protected_features = protected_features
        self.quantile_level = quantile_level
        self.quickrun = quickrun
        self.rate_top_pct_threshold = rate_top_pct_threshold
        self.relationships_configuration_id = relationships_configuration_id
        self.reps = reps
        self.response_cap = response_cap
        self.run_leakage_removed_feature_list = run_leakage_removed_feature_list
        self.sample_step_pct = sample_step_pct
        self.scaleout_modeling_mode = scaleout_modeling_mode
        self.scoring_code_only = scoring_code_only
        self.seed = seed
        self.segmentation_task_id = segmentation_task_id
        self.shap_only_mode = shap_only_mode
        self.smart_downsampled = smart_downsampled
        self.stop_words = stop_words
        self.target = target
        self.target_type = target_type
        self.training_level = training_level
        self.treat_as_exponential = treat_as_exponential
        self.unsupervised_mode = unsupervised_mode
        self.unsupervised_type = unsupervised_type
        self.use_cross_series_features = use_cross_series_features
        self.use_project_settings = use_project_settings
        self.use_supervised_feature_reduction = use_supervised_feature_reduction
        self.use_time_series = use_time_series
        self.user_partition_col = user_partition_col
        self.validation_duration = validation_duration
        self.validation_level = validation_level
        self.validation_pct = validation_pct
        self.validation_type = validation_type
        self.weights = weights
        self.windows_basis_unit = windows_basis_unit

    def __repr__(self):
        return (
            "Aim("
            "autopilot_data_selection_method={0.autopilot_data_selection_method}, "
            "only_include_monotonic_blueprints={0.only_include_monotonic_blueprints}, "
            "accuracy_optimized_mb={0.accuracy_optimized_mb}, "
            "aggregation_type={0.aggregation_type}, "
            "allow_partial_history_time_series_predictions={0.allow_partial_history_time_series_predictions}, "
            "allowed_pairwise_interaction_groups={0.allowed_pairwise_interaction_groups}, "
            "anomaly_detection_context_columns={0.anomaly_detection_context_columns}, "
            "autopilot_cluster_list={0.autopilot_cluster_list}, "
            "autopilot_data_sampling_method={0.autopilot_data_sampling_method}, "
            "autopilot_with_feature_discovery={0.autopilot_with_feature_discovery}, "
            "backtests={0.backtests}, "
            "blend_best_models={0.blend_best_models}, "
            "blueprint_threshold={0.blueprint_threshold}, "
            "calendar_id={0.calendar_id}, "
            "class_mapping_aggregation_settings={0.class_mapping_aggregation_settings}, "
            "consider_blenders_in_recommendation={0.consider_blenders_in_recommendation}, "
            "credentials={0.credentials}, "
            "cross_series_group_by_columns={0.cross_series_group_by_columns}, "
            "cv_holdout_level={0.cv_holdout_level}, "
            "cv_method={0.cv_method}, "
            "date_removal={0.date_removal}, "
            "datetime_partition_column={0.datetime_partition_column}, "
            "default_to_a_priori={0.default_to_a_priori}, "
            "default_to_do_not_derive={0.default_to_do_not_derive}, "
            "default_to_known_in_advance={0.default_to_known_in_advance}, "
            "differencing_method={0.differencing_method}, "
            "disable_holdout={0.disable_holdout}, "
            "events_count={0.events_count}, "
            "exponentially_weighted_moving_alpha={0.exponentially_weighted_moving_alpha}, "
            "exposure={0.exposure}, "
            "external_time_series_baseline_dataset_id={0.external_time_series_baseline_dataset_id}, "
            "external_time_series_baseline_dataset_name={0.external_time_series_baseline_dataset_name}, "
            "fairness_metrics_set={0.fairness_metrics_set}, "
            "fairness_threshold={0.fairness_threshold}, "
            "feature_derivation_window_end={0.feature_derivation_window_end}, "
            "feature_derivation_window_start={0.feature_derivation_window_start}, "
            "feature_discovery_supervised_feature_reduction={0.feature_discovery_supervised_feature_reduction}, "
            "feature_engineering_prediction_point={0.feature_engineering_prediction_point}, "
            "feature_settings={0.feature_settings}, "
            "featurelist_id={0.featurelist_id}, "
            "forecast_window_end={0.forecast_window_end}, "
            "forecast_window_start={0.forecast_window_start}, "
            "gap_duration={0.gap_duration}, "
            "holdout_duration={0.holdout_duration}, "
            "holdout_end_date={0.holdout_end_date}, "
            "holdout_level={0.holdout_level}, "
            "holdout_pct={0.holdout_pct}, "
            "holdout_start_date={0.holdout_start_date}, "
            "majority_downsampling_rate={0.majority_downsampling_rate}, "
            "metric={0.metric}, "
            "min_secondary_validation_model_count={0.min_secondary_validation_model_count}, "
            "mode={0.mode}, "
            "model_splits={0.model_splits}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "multiseries_id_columns={0.multiseries_id_columns}, "
            "number_of_backtests={0.number_of_backtests}, "
            "offset={0.offset}, "
            "partition_key_cols={0.partition_key_cols}, "
            "periodicities={0.periodicities}, "
            "positive_class={0.positive_class}, "
            "preferable_target_value={0.preferable_target_value}, "
            "prepare_model_for_deployment={0.prepare_model_for_deployment}, "
            "primary_location_column={0.primary_location_column}, "
            "protected_features={0.protected_features}, "
            "quantile_level={0.quantile_level}, "
            "quickrun={0.quickrun}, "
            "rate_top_pct_threshold={0.rate_top_pct_threshold}, "
            "relationships_configuration_id={0.relationships_configuration_id}, "
            "reps={0.reps}, "
            "response_cap={0.response_cap}, "
            "run_leakage_removed_feature_list={0.run_leakage_removed_feature_list}, "
            "sample_step_pct={0.sample_step_pct}, "
            "scaleout_modeling_mode={0.scaleout_modeling_mode}, "
            "scoring_code_only={0.scoring_code_only}, "
            "seed={0.seed}, "
            "segmentation_task_id={0.segmentation_task_id}, "
            "shap_only_mode={0.shap_only_mode}, "
            "smart_downsampled={0.smart_downsampled}, "
            "stop_words={0.stop_words}, "
            "target={0.target}, "
            "target_type={0.target_type}, "
            "training_level={0.training_level}, "
            "treat_as_exponential={0.treat_as_exponential}, "
            "unsupervised_mode={0.unsupervised_mode}, "
            "unsupervised_type={0.unsupervised_type}, "
            "use_cross_series_features={0.use_cross_series_features}, "
            "use_project_settings={0.use_project_settings}, "
            "use_supervised_feature_reduction={0.use_supervised_feature_reduction}, "
            "use_time_series={0.use_time_series}, "
            "user_partition_col={0.user_partition_col}, "
            "validation_duration={0.validation_duration}, "
            "validation_level={0.validation_level}, "
            "validation_pct={0.validation_pct}, "
            "validation_type={0.validation_type}, "
            "weights={0.weights}, "
            "windows_basis_unit={0.windows_basis_unit}, "
        ).format(self)
