#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.histogram_details import HistogramDetails

class AnalyzedFeature(APIObject):
    """
    Attributes
    ----------
    details_histogram:[HistogramDetails]
         Histogram details for the specified feature.
    disparity_score:float
         A number to describe disparity for the feature between the compared classes.
    feature_impact:float
         A feature importance value.
    name:str
         Name of the feature.
    status:str
         A status of the feature.
    """
    _converter = t.Dict(
        {
            t.Key("details_histogram"):  t.List(t.Dict().allow_extra("*")),
            t.Key("disparity_score"):  t.Float(),
            t.Key("feature_impact"):  t.Float(),
            t.Key("name"):  t.String(),
            t.Key("status"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        details_histogram,
        disparity_score,
        feature_impact,
        name,
        status,
    ):
        self.details_histogram = details_histogram
        self.disparity_score = disparity_score
        self.feature_impact = feature_impact
        self.name = name
        self.status = status

    def __repr__(self):
        return (
            "AnalyzedFeature("
            "details_histogram={0.details_histogram}, "
            "disparity_score={0.disparity_score}, "
            "feature_impact={0.feature_impact}, "
            "name={0.name}, "
            "status={0.status}, "
        ).format(self)
