#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.data_point_response import DataPointResponse

class AnomalyAssessmentExplanationsResponse(APIObject):
    """
    Attributes
    ----------
    backtest:bool, date, datetime, dict, float, int, list, str, none_type
         The backtest of the record.
    count:int
         The count of points.
    data:[DataPointResponse]
         Each is a `DataPoint` corresponding to a row in the specified range.
    end_date:datetime
         ISO-formatted last timestamp in the response. For example: ``2019-08-30T00:00:00.000000Z``.
    model_id:str
         The model ID of the record.
    project_id:str
         The project ID of the record.
    record_id:str
         The ID of the anomaly assessment record.
    series_id:str, none_type
         The series id of the record. Applicable in multiseries projects
    shap_base_value:float
         shap base value
    source:str
         The source of the record
    start_date:datetime
         ISO-formatted first timestamp in the response. For example: ``2019-08-01T00:00:00.000000Z``.
    """
    _converter = t.Dict(
        {
            t.Key("backtest"):  t.Any(),
            t.Key("count"):  t.Int(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("end_date"):  t.DateTime(),
            t.Key("model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("record_id"):  t.String(),
            t.Key("series_id"):  t.String(),
            t.Key("shap_base_value"):  t.Float(),
            t.Key("source"):  t.String(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest,
        count,
        data,
        end_date,
        model_id,
        project_id,
        record_id,
        series_id,
        shap_base_value,
        source,
        start_date,
    ):
        self.backtest = backtest
        self.count = count
        self.data = data
        self.end_date = end_date
        self.model_id = model_id
        self.project_id = project_id
        self.record_id = record_id
        self.series_id = series_id
        self.shap_base_value = shap_base_value
        self.source = source
        self.start_date = start_date

    def __repr__(self):
        return (
            "AnomalyAssessmentExplanationsResponse("
            "backtest={0.backtest}, "
            "count={0.count}, "
            "data={0.data}, "
            "end_date={0.end_date}, "
            "model_id={0.model_id}, "
            "project_id={0.project_id}, "
            "record_id={0.record_id}, "
            "series_id={0.series_id}, "
            "shap_base_value={0.shap_base_value}, "
            "source={0.source}, "
            "start_date={0.start_date}, "
        ).format(self)
