#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class AnomalyAssessmentInitialize(APIObject):
    """
    Attributes
    ----------
    backtest:bool, date, datetime, dict, float, int, list, str, none_type
         The backtest to compute insight for.
    source:str
         The source to compute insight for.
    series_id:str [optional]
         Required for multiseries projects. The series id to compute insight for.. 
    """
    _converter = t.Dict(
        {
            t.Key("backtest"):  t.Any(),
            t.Key("source"):  t.String(),
            t.Key("series_id", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtest,
        source,
        series_id=None,
    ):
        self.backtest = backtest
        self.source = source
        self.series_id = series_id

    def __repr__(self):
        return (
            "AnomalyAssessmentInitialize("
            "backtest={0.backtest}, "
            "source={0.source}, "
            "series_id={0.series_id}, "
        ).format(self)
